/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.shortcircuit.InitialVoltageProfileMode;
import com.powsybl.shortcircuit.StudyType;
import com.powsybl.shortcircuit.VoltageRange;
import com.powsybl.shortcircuit.json.ShortCircuitAnalysisJsonModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaultParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(FaultParameters.class);
    public static final String VERSION = "1.3";
    private final String id;
    private final boolean withLimitViolations;
    private final boolean withFortescueResult;
    private final StudyType studyType;
    private final boolean withFeederResult;
    private final boolean withVoltageResult;
    private final double minVoltageDropProportionalThreshold;
    private final double subTransientCoefficient;
    private final boolean withLoads;
    private final boolean withShuntCompensators;
    private final boolean withVSCConverterStations;
    private final boolean withNeutralPosition;
    private final InitialVoltageProfileMode initialVoltageProfileMode;
    private final List<VoltageRange> voltageRanges;

    public String getId() {
        return this.id;
    }

    public boolean isWithLimitViolations() {
        return this.withLimitViolations;
    }

    public boolean isWithFortescueResult() {
        return this.withFortescueResult;
    }

    public StudyType getStudyType() {
        return this.studyType;
    }

    public boolean isWithFeederResult() {
        return this.withFeederResult;
    }

    public boolean isWithVoltageResult() {
        return this.withVoltageResult;
    }

    public double getMinVoltageDropProportionalThreshold() {
        return this.minVoltageDropProportionalThreshold;
    }

    public double getSubTransientCoefficient() {
        return this.subTransientCoefficient;
    }

    public boolean isWithLoads() {
        return this.withLoads;
    }

    public boolean isWithShuntCompensators() {
        return this.withShuntCompensators;
    }

    public boolean isWithVSCConverterStations() {
        return this.withVSCConverterStations;
    }

    public boolean isWithNeutralPosition() {
        return this.withNeutralPosition;
    }

    public InitialVoltageProfileMode getInitialVoltageProfileMode() {
        return this.initialVoltageProfileMode;
    }

    public List<VoltageRange> getVoltageRanges() {
        return this.voltageRanges;
    }

    public FaultParameters(String id, boolean withLimitViolations, boolean withVoltageResult, boolean withFeederResult, StudyType studyType, double minVoltageDropProportionalThreshold, boolean withFortescueResult, double subTransientCoefficient, boolean withLoads, boolean withShuntCompensators, boolean withVSCConverterStations, boolean withNeutralPosition, InitialVoltageProfileMode initialVoltageProfileMode, List<VoltageRange> voltageRanges) {
        this.id = Objects.requireNonNull(id);
        this.withLimitViolations = withLimitViolations;
        this.withVoltageResult = withVoltageResult;
        this.withFeederResult = withFeederResult;
        this.studyType = studyType;
        this.minVoltageDropProportionalThreshold = minVoltageDropProportionalThreshold;
        this.withFortescueResult = withFortescueResult;
        this.subTransientCoefficient = this.checkSubTransientCoefficient(subTransientCoefficient);
        this.withLoads = withLoads;
        this.withShuntCompensators = withShuntCompensators;
        this.withVSCConverterStations = withVSCConverterStations;
        this.withNeutralPosition = withNeutralPosition;
        this.initialVoltageProfileMode = initialVoltageProfileMode;
        this.voltageRanges = new ArrayList<VoltageRange>();
        if (voltageRanges != null) {
            if (initialVoltageProfileMode == InitialVoltageProfileMode.CONFIGURED) {
                VoltageRange.checkVoltageRange(voltageRanges);
                this.voltageRanges.addAll(voltageRanges);
            } else {
                LOGGER.warn("Nominal voltage ranges with associated coefficient are defined but InitialVoltageProfileMode is not CONFIGURED: they are ignored");
            }
        }
        this.validate();
    }

    private double checkSubTransientCoefficient(double subTransientCoefficient) {
        if (subTransientCoefficient > 1.0) {
            throw new PowsyblException("subTransientCoefficient > 1");
        }
        return subTransientCoefficient;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaultParameters that = (FaultParameters)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.withLimitViolations, that.withLimitViolations) && Objects.equals(this.withVoltageResult, that.withVoltageResult) && Objects.equals(this.withFeederResult, that.withFeederResult) && Objects.equals((Object)this.studyType, (Object)that.studyType) && Objects.equals(this.minVoltageDropProportionalThreshold, that.minVoltageDropProportionalThreshold) && Objects.equals(this.withFortescueResult, that.withFortescueResult) && Objects.equals(this.subTransientCoefficient, that.subTransientCoefficient) && Objects.equals(this.withLoads, that.withLoads) && Objects.equals(this.withShuntCompensators, that.withShuntCompensators) && Objects.equals(this.withVSCConverterStations, that.withVSCConverterStations) && Objects.equals(this.withNeutralPosition, that.withNeutralPosition) && Objects.equals((Object)this.initialVoltageProfileMode, (Object)that.initialVoltageProfileMode) && Objects.equals(this.voltageRanges, that.voltageRanges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.withLimitViolations, this.withVoltageResult, this.withFeederResult, this.studyType, this.minVoltageDropProportionalThreshold, this.withFortescueResult, this.subTransientCoefficient, this.withLoads, this.withShuntCompensators, this.withVSCConverterStations, this.withNeutralPosition, this.initialVoltageProfileMode, this.voltageRanges});
    }

    public String toString() {
        return "FaultParameters{id=" + this.id + ", withLimitViolations=" + this.withLimitViolations + ", withVoltageResult=" + this.withVoltageResult + ", withFeederResult=" + this.withFeederResult + ", studyType=" + this.studyType + ", minVoltageDropProportionalThreshold=" + this.minVoltageDropProportionalThreshold + ", withFortescueResult=" + this.withFortescueResult + ", subTransientCoefficient=" + this.subTransientCoefficient + ", withLoads=" + this.withLoads + ", withShuntCompensators=" + this.withShuntCompensators + ", withVSCConverterStations=" + this.withVSCConverterStations + ", withNeutralPosition=" + this.withNeutralPosition + ", initialVoltageProfileMode=" + this.initialVoltageProfileMode + ", voltageRanges=" + this.voltageRanges + "}";
    }

    private static ObjectMapper createObjectMapper() {
        return JsonUtil.createObjectMapper().registerModule((Module)new ShortCircuitAnalysisJsonModule());
    }

    public static void write(List<FaultParameters> parameters, Path jsonFile) {
        try (OutputStream out = Files.newOutputStream(jsonFile, new OpenOption[0]);){
            FaultParameters.createObjectMapper().writerWithDefaultPrettyPrinter().writeValue(out, parameters);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static List<FaultParameters> read(Path jsonFile) {
        List list;
        block8: {
            InputStream is = Files.newInputStream(jsonFile, new OpenOption[0]);
            try {
                list = (List)FaultParameters.createObjectMapper().readerForListOf(FaultParameters.class).readValue(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return list;
    }

    public void validate() {
        if (this.initialVoltageProfileMode == InitialVoltageProfileMode.CONFIGURED && (this.voltageRanges == null || this.voltageRanges.isEmpty())) {
            throw new PowsyblException("Configured initial voltage profile but nominal voltage ranges with associated coefficients are missing.");
        }
    }
}

