/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit;

import com.powsybl.iidm.network.extensions.util.FortescueUtil;
import com.powsybl.math.matrix.DenseMatrix;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.util.Pair;

public class FortescueValue {
    private final double positiveMagnitude;
    private final double zeroMagnitude;
    private final double negativeMagnitude;
    private final double positiveAngle;
    private final double zeroAngle;
    private final double negativeAngle;

    public FortescueValue(double positiveMagnitude, double zeroMagnitude, double negativeMagnitude, double positiveAngle, double zeroAngle, double negativeAngle) {
        this.positiveMagnitude = positiveMagnitude;
        this.positiveAngle = positiveAngle;
        this.zeroMagnitude = zeroMagnitude;
        this.negativeMagnitude = negativeMagnitude;
        this.zeroAngle = zeroAngle;
        this.negativeAngle = negativeAngle;
    }

    public FortescueValue(double positiveMagnitude, double positiveAngle) {
        this(positiveMagnitude, Double.NaN, Double.NaN, positiveAngle, Double.NaN, Double.NaN);
    }

    public FortescueValue(double positiveMagnitude) {
        this(positiveMagnitude, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    public double getPositiveMagnitude() {
        return this.positiveMagnitude;
    }

    public double getZeroMagnitude() {
        return this.zeroMagnitude;
    }

    public double getNegativeMagnitude() {
        return this.negativeMagnitude;
    }

    public double getPositiveAngle() {
        return this.positiveAngle;
    }

    public double getZeroAngle() {
        return this.zeroAngle;
    }

    public double getNegativeAngle() {
        return this.negativeAngle;
    }

    public ThreePhaseValue toThreePhaseValue() {
        Vector2D positiveSequence = FortescueUtil.getCartesianFromPolar((double)this.positiveMagnitude, (double)this.positiveAngle);
        Vector2D zeroSequence = FortescueUtil.getCartesianFromPolar((double)this.zeroMagnitude, (double)this.zeroAngle);
        Vector2D negativeSequence = FortescueUtil.getCartesianFromPolar((double)this.negativeMagnitude, (double)this.negativeAngle);
        DenseMatrix mGfortescue = new DenseMatrix(6, 1);
        mGfortescue.add(0, 0, zeroSequence.getX());
        mGfortescue.add(1, 0, zeroSequence.getY());
        mGfortescue.add(2, 0, positiveSequence.getX());
        mGfortescue.add(3, 0, positiveSequence.getY());
        mGfortescue.add(4, 0, negativeSequence.getX());
        mGfortescue.add(5, 0, negativeSequence.getY());
        DenseMatrix mGphase = FortescueUtil.getFortescueMatrix().times(mGfortescue).toDense();
        Pair phaseA = FortescueUtil.getPolarFromCartesian((double)mGphase.get(0, 0), (double)mGphase.get(1, 0));
        Pair phaseB = FortescueUtil.getPolarFromCartesian((double)mGphase.get(2, 0), (double)mGphase.get(3, 0));
        Pair phaseC = FortescueUtil.getPolarFromCartesian((double)mGphase.get(4, 0), (double)mGphase.get(5, 0));
        return new ThreePhaseValue((Double)phaseA.getKey() / Math.sqrt(3.0), (Double)phaseB.getKey() / Math.sqrt(3.0), (Double)phaseC.getKey() / Math.sqrt(3.0), (Double)phaseA.getValue(), (Double)phaseB.getValue(), (Double)phaseC.getValue());
    }

    public class ThreePhaseValue {
        private final double magnitudeA;
        private final double magnitudeB;
        private final double magnitudeC;
        private final double angleA;
        private final double angleB;
        private final double angleC;

        public ThreePhaseValue(double magnitudeA, double magnitudeB, double magnitudeC, double angleA, double angleB, double angleC) {
            this.magnitudeA = magnitudeA;
            this.magnitudeB = magnitudeB;
            this.magnitudeC = magnitudeC;
            this.angleA = angleA;
            this.angleB = angleB;
            this.angleC = angleC;
        }

        public double getMagnitudeA() {
            return this.magnitudeA;
        }

        public double getMagnitudeB() {
            return this.magnitudeB;
        }

        public double getMagnitudeC() {
            return this.magnitudeC;
        }

        public double getAngleA() {
            return this.angleA;
        }

        public double getAngleB() {
            return this.angleB;
        }

        public double getAngleC() {
            return this.angleC;
        }
    }
}

