/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit;

import com.powsybl.commons.Versionable;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.config.PlatformConfigNamedProvider;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.local.LocalComputationManager;
import com.powsybl.iidm.network.Network;
import com.powsybl.shortcircuit.Fault;
import com.powsybl.shortcircuit.FaultParameters;
import com.powsybl.shortcircuit.ShortCircuitAnalysisProvider;
import com.powsybl.shortcircuit.ShortCircuitAnalysisResult;
import com.powsybl.shortcircuit.ShortCircuitParameters;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class ShortCircuitAnalysis {
    private static final String NOT_NULL_COMPUTATION_MANAGER_MESSAGE = "ComputationManager should not be null";
    private static final String NOT_NULL_PARAMETERS_MESSAGE = "Short circuit parameters should not be null";
    private static final String NOT_NULL_NETWORK_MESSAGE = "Network should not be null";
    private static final String NOT_NULL_FAULT_MESSAGE = "Fault characteristics should not be null";

    private ShortCircuitAnalysis() {
        throw new IllegalStateException("Utility class should not been instantiated");
    }

    public static Runner find(String name) {
        return new Runner((ShortCircuitAnalysisProvider)PlatformConfigNamedProvider.Finder.find((String)name, (String)"shortcircuits-analysis", ShortCircuitAnalysisProvider.class, (PlatformConfig)PlatformConfig.defaultConfig()));
    }

    public static Runner find() {
        return ShortCircuitAnalysis.find(null);
    }

    public static CompletableFuture<ShortCircuitAnalysisResult> runAsync(Network network, List<Fault> faults, ShortCircuitParameters parameters, ComputationManager computationManager, List<FaultParameters> faultParameters) {
        return ShortCircuitAnalysis.find().runAsync(network, faults, parameters, computationManager, faultParameters);
    }

    public static CompletableFuture<ShortCircuitAnalysisResult> runAsync(Network network, List<Fault> faults, ShortCircuitParameters parameters, ComputationManager computationManager, List<FaultParameters> faultParameters, ReportNode reportNode) {
        return ShortCircuitAnalysis.find().runAsync(network, faults, parameters, computationManager, faultParameters, reportNode);
    }

    public static ShortCircuitAnalysisResult run(Network network, List<Fault> faults, ShortCircuitParameters parameters, ComputationManager computationManager, List<FaultParameters> faultParameters, ReportNode reportNode) {
        return ShortCircuitAnalysis.find().run(network, faults, parameters, computationManager, faultParameters, reportNode);
    }

    public static ShortCircuitAnalysisResult run(Network network, List<Fault> faults, ShortCircuitParameters parameters, ComputationManager computationManager, List<FaultParameters> faultParameters) {
        return ShortCircuitAnalysis.find().run(network, faults, parameters, computationManager, faultParameters);
    }

    public static ShortCircuitAnalysisResult run(Network network, List<Fault> faults, ShortCircuitParameters parameters, List<FaultParameters> faultParameters) {
        return ShortCircuitAnalysis.find().run(network, faults, parameters, faultParameters);
    }

    public static ShortCircuitAnalysisResult run(Network network, List<Fault> faults, List<FaultParameters> faultParameters) {
        return ShortCircuitAnalysis.find().run(network, faults, faultParameters);
    }

    public static ShortCircuitAnalysisResult run(Network network, List<Fault> faults) {
        return ShortCircuitAnalysis.find().run(network, faults, Collections.emptyList());
    }

    public static final class Runner
    implements Versionable {
        private final ShortCircuitAnalysisProvider provider;

        private Runner(ShortCircuitAnalysisProvider provider) {
            this.provider = Objects.requireNonNull(provider);
        }

        public CompletableFuture<ShortCircuitAnalysisResult> runAsync(Network network, List<Fault> faults, ShortCircuitParameters parameters, ComputationManager computationManager, List<FaultParameters> faultParameters, ReportNode reportNode) {
            Objects.requireNonNull(network, ShortCircuitAnalysis.NOT_NULL_NETWORK_MESSAGE);
            Objects.requireNonNull(faults, ShortCircuitAnalysis.NOT_NULL_FAULT_MESSAGE);
            Objects.requireNonNull(computationManager, ShortCircuitAnalysis.NOT_NULL_COMPUTATION_MANAGER_MESSAGE);
            Objects.requireNonNull(parameters, ShortCircuitAnalysis.NOT_NULL_PARAMETERS_MESSAGE);
            Objects.requireNonNull(reportNode, "ReportNode should not be null");
            this.validateParameters(parameters);
            return this.provider.run(network, faults, parameters, computationManager, faultParameters, reportNode);
        }

        public CompletableFuture<ShortCircuitAnalysisResult> runAsync(Network network, List<Fault> faults, ShortCircuitParameters parameters, ComputationManager computationManager, List<FaultParameters> faultParameters) {
            Objects.requireNonNull(network, ShortCircuitAnalysis.NOT_NULL_NETWORK_MESSAGE);
            Objects.requireNonNull(faults, ShortCircuitAnalysis.NOT_NULL_FAULT_MESSAGE);
            Objects.requireNonNull(computationManager, ShortCircuitAnalysis.NOT_NULL_COMPUTATION_MANAGER_MESSAGE);
            Objects.requireNonNull(parameters, ShortCircuitAnalysis.NOT_NULL_PARAMETERS_MESSAGE);
            this.validateParameters(parameters);
            return this.provider.run(network, faults, parameters, computationManager, faultParameters);
        }

        private void validateParameters(ShortCircuitParameters shortCircuitParameters) {
            shortCircuitParameters.validate();
        }

        public ShortCircuitAnalysisResult run(Network network, List<Fault> faults, ShortCircuitParameters parameters, ComputationManager computationManager, List<FaultParameters> faultParameters, ReportNode reportNode) {
            return this.runAsync(network, faults, parameters, computationManager, faultParameters, reportNode).join();
        }

        public ShortCircuitAnalysisResult run(Network network, List<Fault> faults, ShortCircuitParameters parameters, ComputationManager computationManager, List<FaultParameters> faultParameters) {
            return this.runAsync(network, faults, parameters, computationManager, faultParameters).join();
        }

        public ShortCircuitAnalysisResult run(Network network, List<Fault> faults, ShortCircuitParameters parameters, List<FaultParameters> faultParameters) {
            return this.run(network, faults, parameters, LocalComputationManager.getDefault(), faultParameters);
        }

        public ShortCircuitAnalysisResult run(Network network, List<Fault> faults, List<FaultParameters> faultParameters) {
            return this.run(network, faults, ShortCircuitParameters.load(), faultParameters);
        }

        public ShortCircuitAnalysisResult run(Network network, List<Fault> faults) {
            return this.run(network, faults, ShortCircuitParameters.load(), Collections.emptyList());
        }

        public String getName() {
            return this.provider.getName();
        }

        public String getVersion() {
            return this.provider.getVersion();
        }
    }
}

