/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit;

import com.google.common.collect.Lists;
import com.powsybl.commons.Versionable;
import com.powsybl.commons.config.ModuleConfig;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.config.PlatformConfigNamedProvider;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.commons.parameters.ConfiguredParameter;
import com.powsybl.commons.parameters.Parameter;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.network.Network;
import com.powsybl.shortcircuit.Fault;
import com.powsybl.shortcircuit.FaultParameters;
import com.powsybl.shortcircuit.ShortCircuitAnalysis;
import com.powsybl.shortcircuit.ShortCircuitAnalysisResult;
import com.powsybl.shortcircuit.ShortCircuitParameters;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;

public interface ShortCircuitAnalysisProvider
extends Versionable,
PlatformConfigNamedProvider {
    public static List<ShortCircuitAnalysisProvider> findAll() {
        return Lists.newArrayList(ServiceLoader.load(ShortCircuitAnalysisProvider.class, ShortCircuitAnalysisProvider.class.getClassLoader()));
    }

    default public CompletableFuture<ShortCircuitAnalysisResult> run(Network network, List<Fault> faults, ShortCircuitParameters parameters, ComputationManager computationManager, List<FaultParameters> faultParameters) {
        return ShortCircuitAnalysis.runAsync(network, faults, parameters, computationManager, faultParameters);
    }

    default public CompletableFuture<ShortCircuitAnalysisResult> run(Network network, List<Fault> faults, ShortCircuitParameters parameters, ComputationManager computationManager, List<FaultParameters> faultParameters, ReportNode reportNode) {
        return ShortCircuitAnalysis.runAsync(network, faults, parameters, computationManager, faultParameters, reportNode);
    }

    default public Optional<ExtensionJsonSerializer> getSpecificParametersSerializer() {
        return Optional.empty();
    }

    default public Optional<Extension<ShortCircuitParameters>> loadSpecificParameters(PlatformConfig config) {
        return Optional.empty();
    }

    default public Optional<Extension<ShortCircuitParameters>> loadSpecificParameters(Map<String, String> properties) {
        return Optional.empty();
    }

    default public void updateSpecificParameters(Extension<ShortCircuitParameters> extension, Map<String, String> properties) {
    }

    default public List<Parameter> getSpecificParameters() {
        return Collections.emptyList();
    }

    default public List<Parameter> getSpecificParameters(PlatformConfig platformConfigConfig) {
        return ConfiguredParameter.load(this.getSpecificParameters(), (ModuleConfig)this.getModuleConfig(platformConfigConfig).orElse(null));
    }

    default public Optional<ModuleConfig> getModuleConfig(PlatformConfig platformConfig) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

