/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit;

import com.powsybl.commons.extensions.AbstractExtendable;
import com.powsybl.shortcircuit.FaultResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class ShortCircuitAnalysisResult
extends AbstractExtendable<ShortCircuitAnalysisResult> {
    public static final String VERSION = "1.3";
    private final Map<String, FaultResult> resultByFaultId = new TreeMap<String, FaultResult>();
    private final Map<String, List<FaultResult>> resultByElementId = new TreeMap<String, List<FaultResult>>();

    public ShortCircuitAnalysisResult(List<FaultResult> faultResults) {
        Objects.requireNonNull(faultResults);
        faultResults.forEach(r -> {
            this.resultByFaultId.put(r.getFault().getId(), (FaultResult)r);
            this.resultByElementId.computeIfAbsent(r.getFault().getElementId(), k -> new ArrayList()).add(r);
        });
    }

    public List<FaultResult> getFaultResults() {
        return new ArrayList<FaultResult>(this.resultByFaultId.values());
    }

    public FaultResult getFaultResult(String id) {
        return this.resultByFaultId.get(id);
    }

    public List<FaultResult> getFaultResults(String elementId) {
        return this.resultByElementId.getOrDefault(elementId, Collections.emptyList());
    }
}

