/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.ModuleConfig;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.extensions.AbstractExtendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.commons.util.ServiceLoaderCache;
import com.powsybl.shortcircuit.InitialVoltageProfileMode;
import com.powsybl.shortcircuit.ShortCircuitAnalysisProvider;
import com.powsybl.shortcircuit.ShortCircuitConstants;
import com.powsybl.shortcircuit.StudyType;
import com.powsybl.shortcircuit.VoltageRange;
import com.powsybl.shortcircuit.json.ShortCircuitAnalysisJsonModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ShortCircuitParameters
extends AbstractExtendable<ShortCircuitParameters> {
    public static final String VERSION = "1.4";
    private boolean withLimitViolations = true;
    private boolean withFortescueResult = true;
    private boolean withFeederResult = true;
    private StudyType studyType = ShortCircuitConstants.DEFAULT_STUDY_TYPE;
    private boolean withVoltageResult = true;
    private double minVoltageDropProportionalThreshold = 0.0;
    private double subTransientCoefficient = 0.7;
    private boolean withLoads = true;
    private boolean withShuntCompensators = true;
    private boolean withVSCConverterStations = true;
    private boolean withNeutralPosition = false;
    private InitialVoltageProfileMode initialVoltageProfileMode = ShortCircuitConstants.DEFAULT_INITIAL_VOLTAGE_PROFILE_MODE;
    private List<VoltageRange> voltageRanges;
    private boolean detailedReport = true;
    private String debugDir = ShortCircuitConstants.DEFAULT_DEBUG_DIR;

    public static ShortCircuitParameters load() {
        return ShortCircuitParameters.load(PlatformConfig.defaultConfig());
    }

    public static ShortCircuitParameters load(PlatformConfig platformConfig) {
        Objects.requireNonNull(platformConfig);
        ShortCircuitParameters parameters = new ShortCircuitParameters();
        platformConfig.getOptionalModuleConfig("short-circuit-parameters").ifPresent(config -> parameters.setWithLimitViolations(config.getBooleanProperty("with-limit-violations", true)).setWithVoltageResult(config.getBooleanProperty("with-voltage-result", true)).setWithFeederResult(config.getBooleanProperty("with-feeder-result", true)).setStudyType((StudyType)config.getEnumProperty("study-type", StudyType.class, (Enum)ShortCircuitConstants.DEFAULT_STUDY_TYPE)).setWithFortescueResult(config.getBooleanProperty("with-fortescue-result", true)).setMinVoltageDropProportionalThreshold(config.getDoubleProperty("min-voltage-drop-proportional-threshold", 0.0)).setSubTransientCoefficient(config.getDoubleProperty("sub-transient-coefficient", 0.7)).setWithLoads(config.getBooleanProperty("with-loads", true)).setWithShuntCompensators(config.getBooleanProperty("with-shunt-compensators", true)).setWithVSCConverterStations(config.getBooleanProperty("with-vsc-converter-stations", true)).setWithNeutralPosition(config.getBooleanProperty("with-neutral-position", false)).setInitialVoltageProfileMode((InitialVoltageProfileMode)config.getEnumProperty("initial-voltage-profile-mode", InitialVoltageProfileMode.class, (Enum)ShortCircuitConstants.DEFAULT_INITIAL_VOLTAGE_PROFILE_MODE)).setVoltageRanges(ShortCircuitParameters.getVoltageRangesFromConfig(config)).setDetailedReport(config.getBooleanProperty("detailed-report", true)).setDebugDir(config.getStringProperty("debug-dir", ShortCircuitConstants.DEFAULT_DEBUG_DIR)));
        parameters.validate();
        parameters.readExtensions(platformConfig);
        return parameters;
    }

    private static List<VoltageRange> getVoltageRangesFromConfig(ModuleConfig config) {
        return config.getOptionalPathProperty("voltage-ranges").map(voltageRangePath -> {
            List list;
            block8: {
                ObjectMapper mapper = JsonUtil.createObjectMapper().registerModule((Module)new ShortCircuitAnalysisJsonModule());
                InputStream is = Files.newInputStream(voltageRangePath, new OpenOption[0]);
                try {
                    list = (List)mapper.readValue(is, (TypeReference)new TypeReference<List<VoltageRange>>(){});
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                is.close();
            }
            return list;
        }).orElse(Collections.emptyList());
    }

    private void readExtensions(PlatformConfig platformConfig) {
        for (ShortCircuitAnalysisProvider provider : new ServiceLoaderCache(ShortCircuitAnalysisProvider.class).getServices()) {
            provider.loadSpecificParameters(platformConfig).ifPresent(shortCircuitParametersExtension -> this.addExtension(shortCircuitParametersExtension.getClass(), (Extension)shortCircuitParametersExtension));
        }
    }

    public boolean isWithLimitViolations() {
        return this.withLimitViolations;
    }

    public ShortCircuitParameters setWithLimitViolations(boolean withLimitViolations) {
        this.withLimitViolations = withLimitViolations;
        return this;
    }

    @Deprecated(since="5.2.0")
    public boolean isWithVoltageMap() {
        return this.isWithVoltageResult();
    }

    @Deprecated(since="5.2.0")
    public ShortCircuitParameters setWithVoltageMap(boolean withVoltageMap) {
        this.withVoltageResult = withVoltageMap;
        return this;
    }

    public boolean isWithFortescueResult() {
        return this.withFortescueResult;
    }

    public ShortCircuitParameters setWithFortescueResult(boolean withFortescueResult) {
        this.withFortescueResult = withFortescueResult;
        return this;
    }

    public StudyType getStudyType() {
        return this.studyType;
    }

    public ShortCircuitParameters setStudyType(StudyType studyType) {
        this.studyType = studyType;
        return this;
    }

    public boolean isWithFeederResult() {
        return this.withFeederResult;
    }

    public ShortCircuitParameters setWithFeederResult(boolean withFeederResult) {
        this.withFeederResult = withFeederResult;
        return this;
    }

    public boolean isWithVoltageResult() {
        return this.withVoltageResult;
    }

    public ShortCircuitParameters setWithVoltageResult(boolean withVoltageResult) {
        this.withVoltageResult = withVoltageResult;
        return this;
    }

    public double getMinVoltageDropProportionalThreshold() {
        return this.minVoltageDropProportionalThreshold;
    }

    public ShortCircuitParameters setMinVoltageDropProportionalThreshold(double minVoltageDropProportionalThreshold) {
        this.minVoltageDropProportionalThreshold = minVoltageDropProportionalThreshold;
        return this;
    }

    public double getSubTransientCoefficient() {
        return this.subTransientCoefficient;
    }

    public ShortCircuitParameters setSubTransientCoefficient(double subTransientCoefficient) {
        this.subTransientCoefficient = this.checkSubTransientCoefficient(subTransientCoefficient);
        return this;
    }

    public boolean isWithLoads() {
        return this.withLoads;
    }

    public ShortCircuitParameters setWithLoads(boolean withLoads) {
        this.withLoads = withLoads;
        return this;
    }

    public boolean isWithShuntCompensators() {
        return this.withShuntCompensators;
    }

    public ShortCircuitParameters setWithShuntCompensators(boolean withShuntCompensators) {
        this.withShuntCompensators = withShuntCompensators;
        return this;
    }

    public boolean isWithVSCConverterStations() {
        return this.withVSCConverterStations;
    }

    public ShortCircuitParameters setWithVSCConverterStations(boolean withVSCConverterStations) {
        this.withVSCConverterStations = withVSCConverterStations;
        return this;
    }

    public boolean isWithNeutralPosition() {
        return this.withNeutralPosition;
    }

    public ShortCircuitParameters setWithNeutralPosition(boolean withNeutralPosition) {
        this.withNeutralPosition = withNeutralPosition;
        return this;
    }

    public InitialVoltageProfileMode getInitialVoltageProfileMode() {
        return this.initialVoltageProfileMode;
    }

    public ShortCircuitParameters setInitialVoltageProfileMode(InitialVoltageProfileMode initialVoltageProfileMode) {
        this.initialVoltageProfileMode = initialVoltageProfileMode;
        return this;
    }

    public List<VoltageRange> getVoltageRanges() {
        return this.voltageRanges;
    }

    public ShortCircuitParameters setVoltageRanges(List<VoltageRange> voltageRanges) {
        VoltageRange.checkVoltageRange(voltageRanges);
        this.voltageRanges = voltageRanges;
        return this;
    }

    public boolean isDetailedReport() {
        return this.detailedReport;
    }

    public ShortCircuitParameters setDetailedReport(boolean detailedReport) {
        this.detailedReport = detailedReport;
        return this;
    }

    public String getDebugDir() {
        return this.debugDir;
    }

    public ShortCircuitParameters setDebugDir(String debugDir) {
        this.debugDir = debugDir;
        return this;
    }

    public void validate() {
        if (this.initialVoltageProfileMode == InitialVoltageProfileMode.CONFIGURED && (this.voltageRanges == null || this.voltageRanges.isEmpty())) {
            throw new PowsyblException("Configured initial voltage profile but nominal voltage ranges with associated coefficients are missing.");
        }
    }

    private double checkSubTransientCoefficient(double subTransientCoefficient) {
        if (subTransientCoefficient > 1.0) {
            throw new PowsyblException("subTransientCoefficient > 1");
        }
        return subTransientCoefficient;
    }
}

