/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit;

import com.powsybl.commons.PowsyblException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Range;

public class VoltageRange {
    private final Range<Double> range;
    private final double rangeCoefficient;
    private final double voltage;

    public VoltageRange(double lowVoltage, double highVoltage, double rangeCoefficient) {
        this(lowVoltage, highVoltage, rangeCoefficient, Double.NaN);
    }

    public VoltageRange(double lowVoltage, double highVoltage, double rangeCoefficient, double voltage) {
        this.range = Range.of((Comparable)Double.valueOf(lowVoltage), (Comparable)Double.valueOf(highVoltage));
        this.rangeCoefficient = VoltageRange.checkCoefficient(rangeCoefficient);
        this.voltage = VoltageRange.checkVoltage(voltage, this.range);
    }

    public Range<Double> getRange() {
        return this.range;
    }

    public double getRangeCoefficient() {
        return this.rangeCoefficient;
    }

    public double getMinimumNominalVoltage() {
        return (Double)this.range.getMinimum();
    }

    public double getMaximumNominalVoltage() {
        return (Double)this.range.getMaximum();
    }

    public double getVoltage() {
        return this.voltage;
    }

    static void checkVoltageRange(List<VoltageRange> voltageRange) {
        if (voltageRange == null || voltageRange.isEmpty()) {
            return;
        }
        for (int i = 0; i < voltageRange.size() - 1; ++i) {
            for (int j = i + 1; j < voltageRange.size(); ++j) {
                if (!voltageRange.get(i).getRange().isOverlappedBy(voltageRange.get(j).getRange())) continue;
                throw new PowsyblException("Voltage ranges for configured initial voltage profile are overlapping");
            }
        }
    }

    private static double checkCoefficient(double rangeCoefficient) {
        if (rangeCoefficient < 0.8 || rangeCoefficient > 1.2) {
            throw new PowsyblException("rangeCoefficient " + rangeCoefficient + " is out of bounds, should be between 0.8 and 1.2.");
        }
        return rangeCoefficient;
    }

    private static double checkVoltage(double voltage, Range<Double> voltageRange) {
        if (!Double.isNaN(voltage) && !voltageRange.contains((Object)voltage)) {
            throw new PowsyblException("Range voltage should be in voltageRange " + voltageRange + " but it is " + voltage);
        }
        return voltage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoltageRange that = (VoltageRange)o;
        return this.range.equals(that.range) && this.rangeCoefficient == that.rangeCoefficient && this.voltage == that.voltage;
    }

    public int hashCode() {
        return Objects.hash(this.range, this.rangeCoefficient, this.voltage);
    }
}

