/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit.converter;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.auto.service.AutoService;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.network.Network;
import com.powsybl.shortcircuit.ShortCircuitAnalysisResult;
import com.powsybl.shortcircuit.converter.ShortCircuitAnalysisResultExporter;
import com.powsybl.shortcircuit.json.ShortCircuitAnalysisJsonModule;
import java.io.IOException;
import java.io.Writer;

@AutoService(value={ShortCircuitAnalysisResultExporter.class})
public class JsonShortCircuitAnalysisResultExporter
implements ShortCircuitAnalysisResultExporter {
    @Override
    public String getFormat() {
        return "JSON";
    }

    @Override
    public String getComment() {
        return "Export a result in JSON format";
    }

    @Override
    public void export(ShortCircuitAnalysisResult result, Writer writer, Network network) throws IOException {
        ObjectMapper objectMapper = JsonUtil.createObjectMapper().registerModule((Module)new ShortCircuitAnalysisJsonModule());
        ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
        objectWriter.writeValue(writer, (Object)result);
    }
}

