/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit.converter;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Network;
import com.powsybl.shortcircuit.ShortCircuitAnalysisResult;
import com.powsybl.shortcircuit.converter.ShortCircuitAnalysisResultExporter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.ServiceLoader;

public final class ShortCircuitAnalysisResultExporters {
    private ShortCircuitAnalysisResultExporters() {
    }

    public static Collection<String> getFormats() {
        ArrayList<String> formats = new ArrayList<String>();
        for (ShortCircuitAnalysisResultExporter e : ServiceLoader.load(ShortCircuitAnalysisResultExporter.class, ShortCircuitAnalysisResultExporters.class.getClassLoader())) {
            formats.add(e.getFormat());
        }
        return formats;
    }

    public static ShortCircuitAnalysisResultExporter getExporter(String format) {
        Objects.requireNonNull(format);
        for (ShortCircuitAnalysisResultExporter e : ServiceLoader.load(ShortCircuitAnalysisResultExporter.class, ShortCircuitAnalysisResultExporters.class.getClassLoader())) {
            if (!format.equals(e.getFormat())) continue;
            return e;
        }
        return null;
    }

    public static void export(ShortCircuitAnalysisResult result, Path path, String format, Network network) {
        Objects.requireNonNull(path);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            ShortCircuitAnalysisResultExporters.export(result, writer, format, network);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void export(ShortCircuitAnalysisResult result, Writer writer, String format, Network network) throws IOException {
        Objects.requireNonNull(result);
        Objects.requireNonNull(writer);
        Objects.requireNonNull(format);
        ShortCircuitAnalysisResultExporter exporter = ShortCircuitAnalysisResultExporters.getExporter(format);
        if (exporter == null) {
            throw new PowsyblException("Unsupported format: " + format + " [" + ShortCircuitAnalysisResultExporters.getFormats() + "]");
        }
        exporter.export(result, writer, network);
    }
}

