/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.shortcircuit.FaultParameters;
import com.powsybl.shortcircuit.InitialVoltageProfileMode;
import com.powsybl.shortcircuit.StudyType;
import com.powsybl.shortcircuit.VoltageRange;
import com.powsybl.shortcircuit.json.ParametersDeserializationConstants;
import java.io.IOException;
import java.util.List;

class FaultParametersDeserializer
extends StdDeserializer<FaultParameters> {
    private static final String CONTEXT_NAME = "ShortCircuitFaultParameters";
    private static final String TAG = "TAG: ";

    FaultParametersDeserializer() {
        super(FaultParameters.class);
    }

    public FaultParameters deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        String version = null;
        String id = null;
        boolean withLimitViolations = false;
        boolean withVoltageAndVoltageDropProfileResult = false;
        boolean withFeederResult = false;
        StudyType type = null;
        double minVoltageDropProportionalThreshold = Double.NaN;
        boolean withFortescueResult = false;
        double subTransientCoefficient = Double.NaN;
        boolean withLoads = false;
        boolean withShuntCompensators = false;
        boolean withVSCConverterStations = false;
        boolean withNeutralPosition = false;
        InitialVoltageProfileMode initialVoltageProfileMode = null;
        List voltageRanges = null;
        block36: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.currentName()) {
                case "version": {
                    parser.nextToken();
                    version = parser.getValueAsString();
                    JsonUtil.setSourceVersion((DatabindContext)deserializationContext, (String)version, (String)"sourceVersionAttribute");
                    deserializationContext.setAttribute((Object)"sourceParameterTypeAttribute", (Object)ParametersDeserializationConstants.ParametersType.FAULT);
                    continue block36;
                }
                case "id": {
                    parser.nextToken();
                    id = (String)parser.readValueAs(String.class);
                    continue block36;
                }
                case "withLimitViolations": {
                    parser.nextToken();
                    withLimitViolations = (Boolean)parser.readValueAs(Boolean.class);
                    continue block36;
                }
                case "withVoltageMap": {
                    JsonUtil.assertLessThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: voltageMap", version, (String)"1.1");
                    parser.nextToken();
                    withVoltageAndVoltageDropProfileResult = (Boolean)parser.readValueAs(Boolean.class);
                    continue block36;
                }
                case "withVoltageResult": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: withVoltageAndVoltageDropProfileResult", version, (String)"1.1");
                    parser.nextToken();
                    withVoltageAndVoltageDropProfileResult = (Boolean)parser.readValueAs(Boolean.class);
                    continue block36;
                }
                case "withFeederResult": {
                    parser.nextToken();
                    withFeederResult = (Boolean)parser.readValueAs(Boolean.class);
                    continue block36;
                }
                case "studyType": {
                    parser.nextToken();
                    type = StudyType.valueOf((String)parser.readValueAs(String.class));
                    continue block36;
                }
                case "minVoltageDropProportionalThreshold": {
                    parser.nextToken();
                    minVoltageDropProportionalThreshold = (Double)parser.readValueAs(Double.class);
                    continue block36;
                }
                case "withFortescueResult": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.1");
                    parser.nextToken();
                    withFortescueResult = (Boolean)parser.readValueAs(Boolean.class);
                    continue block36;
                }
                case "subTransientCoefficient": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.2");
                    parser.nextToken();
                    subTransientCoefficient = (Double)parser.readValueAs(Double.class);
                    continue block36;
                }
                case "withLoads": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.2");
                    parser.nextToken();
                    withLoads = (Boolean)parser.readValueAs(Boolean.class);
                    continue block36;
                }
                case "withShuntCompensators": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.2");
                    parser.nextToken();
                    withShuntCompensators = (Boolean)parser.readValueAs(Boolean.class);
                    continue block36;
                }
                case "withVSCConverterStations": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.2");
                    parser.nextToken();
                    withVSCConverterStations = (Boolean)parser.readValueAs(Boolean.class);
                    continue block36;
                }
                case "withNeutralPosition": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.2");
                    parser.nextToken();
                    withNeutralPosition = (Boolean)parser.readValueAs(Boolean.class);
                    continue block36;
                }
                case "initialVoltageProfileMode": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.2");
                    parser.nextToken();
                    initialVoltageProfileMode = InitialVoltageProfileMode.valueOf((String)parser.readValueAs(String.class));
                    continue block36;
                }
                case "voltageRanges": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.2");
                    parser.nextToken();
                    voltageRanges = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, VoltageRange.class);
                    continue block36;
                }
            }
            throw new IllegalStateException("Unexpected field: " + parser.currentName());
        }
        FaultParameters faultParameters = new FaultParameters(id, withLimitViolations, withVoltageAndVoltageDropProfileResult, withFeederResult, type, minVoltageDropProportionalThreshold, withFortescueResult, subTransientCoefficient, withLoads, withShuntCompensators, withVSCConverterStations, withNeutralPosition, initialVoltageProfileMode, voltageRanges);
        faultParameters.validate();
        return faultParameters;
    }
}

