/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.shortcircuit.FaultParameters;
import com.powsybl.shortcircuit.InitialVoltageProfileMode;
import com.powsybl.shortcircuit.StudyType;
import java.io.IOException;

public class FaultParametersSerializer
extends StdSerializer<FaultParameters> {
    public FaultParametersSerializer() {
        super(FaultParameters.class);
    }

    public void serialize(FaultParameters parameters, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("version", "1.3");
        jsonGenerator.writeStringField("id", parameters.getId());
        JsonUtil.writeOptionalBooleanField((JsonGenerator)jsonGenerator, (String)"withLimitViolations", (boolean)parameters.isWithLimitViolations(), (boolean)false);
        JsonUtil.writeOptionalBooleanField((JsonGenerator)jsonGenerator, (String)"withVoltageResult", (boolean)parameters.isWithVoltageResult(), (boolean)false);
        JsonUtil.writeOptionalBooleanField((JsonGenerator)jsonGenerator, (String)"withFeederResult", (boolean)parameters.isWithFeederResult(), (boolean)false);
        JsonUtil.writeOptionalStringField((JsonGenerator)jsonGenerator, (String)"studyType", parameters.getStudyType() != null ? parameters.getStudyType().name() : null);
        JsonUtil.writeOptionalDoubleField((JsonGenerator)jsonGenerator, (String)"minVoltageDropProportionalThreshold", (double)parameters.getMinVoltageDropProportionalThreshold());
        JsonUtil.writeOptionalBooleanField((JsonGenerator)jsonGenerator, (String)"withFortescueResult", (boolean)parameters.isWithFortescueResult(), (boolean)false);
        if (parameters.getStudyType() == StudyType.SUB_TRANSIENT) {
            JsonUtil.writeOptionalDoubleField((JsonGenerator)jsonGenerator, (String)"subTransientCoefficient", (double)parameters.getSubTransientCoefficient());
        }
        JsonUtil.writeOptionalBooleanField((JsonGenerator)jsonGenerator, (String)"withLoads", (boolean)parameters.isWithLoads(), (boolean)false);
        JsonUtil.writeOptionalBooleanField((JsonGenerator)jsonGenerator, (String)"withShuntCompensators", (boolean)parameters.isWithShuntCompensators(), (boolean)false);
        JsonUtil.writeOptionalBooleanField((JsonGenerator)jsonGenerator, (String)"withVSCConverterStations", (boolean)parameters.isWithVSCConverterStations(), (boolean)false);
        JsonUtil.writeOptionalBooleanField((JsonGenerator)jsonGenerator, (String)"withNeutralPosition", (boolean)parameters.isWithNeutralPosition(), (boolean)false);
        JsonUtil.writeOptionalStringField((JsonGenerator)jsonGenerator, (String)"initialVoltageProfileMode", parameters.getInitialVoltageProfileMode() != null ? parameters.getInitialVoltageProfileMode().name() : null);
        if (parameters.getInitialVoltageProfileMode() == InitialVoltageProfileMode.CONFIGURED) {
            serializerProvider.defaultSerializeField("voltageRanges", parameters.getVoltageRanges(), jsonGenerator);
        }
        jsonGenerator.writeEndObject();
    }
}

