/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.google.common.base.Suppliers;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.commons.extensions.ExtensionProviders;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.security.LimitViolation;
import com.powsybl.shortcircuit.FailedFaultResult;
import com.powsybl.shortcircuit.Fault;
import com.powsybl.shortcircuit.FaultResult;
import com.powsybl.shortcircuit.FeederResult;
import com.powsybl.shortcircuit.FortescueFaultResult;
import com.powsybl.shortcircuit.FortescueValue;
import com.powsybl.shortcircuit.MagnitudeFaultResult;
import com.powsybl.shortcircuit.ShortCircuitBusResults;
import com.powsybl.shortcircuit.json.ShortCircuitBusResultsDeserializer;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

class FaultResultDeserializer {
    private static final String CONTEXT_NAME = "FaultResult";
    private static final Supplier<ExtensionProviders<ExtensionJsonSerializer>> SUPPLIER = Suppliers.memoize(() -> ExtensionProviders.createProvider(ExtensionJsonSerializer.class, (String)"short-circuit-analysis"));

    FaultResultDeserializer() {
    }

    public List<FaultResult> deserialize(JsonParser parser, DeserializationContext deserializationContext, String version) throws IOException {
        ArrayList<FaultResult> faultResults = new ArrayList<FaultResult>();
        parser.nextToken();
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            List extensions = Collections.emptyList();
            FaultResultParameters faultResultParameters = new FaultResultParameters();
            block29: while (parser.nextToken() != JsonToken.END_OBJECT) {
                switch (parser.currentName()) {
                    case "fault": {
                        parser.nextToken();
                        faultResultParameters.fault = (Fault)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, Fault.class);
                        continue block29;
                    }
                    case "shortCircuitPower": {
                        parser.nextToken();
                        faultResultParameters.shortCircuitPower = (Double)parser.readValueAs(Double.class);
                        continue block29;
                    }
                    case "timeConstant": {
                        parser.nextToken();
                        faultResultParameters.timeConstant = Duration.parse((CharSequence)parser.readValueAs(String.class));
                        continue block29;
                    }
                    case "feederResult": {
                        parser.nextToken();
                        faultResultParameters.feederResults = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, FeederResult.class);
                        continue block29;
                    }
                    case "limitViolations": {
                        parser.nextToken();
                        faultResultParameters.limitViolations = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, LimitViolation.class);
                        continue block29;
                    }
                    case "current": {
                        parser.nextToken();
                        faultResultParameters.current = (FortescueValue)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, FortescueValue.class);
                        continue block29;
                    }
                    case "voltage": {
                        parser.nextToken();
                        faultResultParameters.voltage = (FortescueValue)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, FortescueValue.class);
                        continue block29;
                    }
                    case "currentMagnitude": {
                        parser.nextToken();
                        faultResultParameters.currentMagnitude = (Double)parser.readValueAs(Double.class);
                        continue block29;
                    }
                    case "voltageMagnitude": {
                        parser.nextToken();
                        faultResultParameters.voltageMagnitude = (Double)parser.readValueAs(Double.class);
                        continue block29;
                    }
                    case "shortCircuitBusResults": {
                        faultResultParameters.shortCircuitBusResults = new ShortCircuitBusResultsDeserializer().deserialize(parser, version);
                        continue block29;
                    }
                    case "status": {
                        JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)("Tag: " + parser.currentName()), (String)version, (String)"1.1");
                        parser.nextToken();
                        faultResultParameters.status = FaultResult.Status.valueOf(parser.getValueAsString());
                        continue block29;
                    }
                    case "extensions": {
                        parser.nextToken();
                        extensions = JsonUtil.readExtensions((JsonParser)parser, (DeserializationContext)deserializationContext, SUPPLIER.get());
                        continue block29;
                    }
                }
                throw new IllegalStateException("Unexpected field: " + parser.currentName());
            }
            FaultResult faultResult = this.getFaultResult(faultResultParameters, version);
            SUPPLIER.get().addExtensions((Extendable)faultResult, extensions);
            faultResults.add(faultResult);
        }
        return faultResults;
    }

    private FaultResult getFaultResult(FaultResultParameters parameters, String version) {
        if (parameters.status == null) {
            JsonUtil.assertLessThanOrEqualToReferenceVersion((String)CONTEXT_NAME, (String)"No status", (String)version, (String)"1.0");
            if (parameters.current == null && Double.isNaN(parameters.currentMagnitude)) {
                return new FailedFaultResult(parameters.fault, FaultResult.Status.FAILURE);
            }
            if (!Double.isNaN(parameters.currentMagnitude)) {
                return new MagnitudeFaultResult(parameters.fault, parameters.shortCircuitPower, parameters.feederResults, parameters.limitViolations, parameters.currentMagnitude, parameters.voltageMagnitude, parameters.shortCircuitBusResults, parameters.timeConstant, FaultResult.Status.SUCCESS);
            }
            return new FortescueFaultResult(parameters.fault, parameters.shortCircuitPower, parameters.feederResults, parameters.limitViolations, parameters.current, parameters.voltage, parameters.shortCircuitBusResults, parameters.timeConstant, FaultResult.Status.SUCCESS);
        }
        if (parameters.status == FaultResult.Status.FAILURE) {
            return new FailedFaultResult(parameters.fault, parameters.status);
        }
        if (!Double.isNaN(parameters.currentMagnitude)) {
            return new MagnitudeFaultResult(parameters.fault, parameters.shortCircuitPower, parameters.feederResults, parameters.limitViolations, parameters.currentMagnitude, parameters.voltageMagnitude, parameters.shortCircuitBusResults, parameters.timeConstant, parameters.status);
        }
        return new FortescueFaultResult(parameters.fault, parameters.shortCircuitPower, parameters.feederResults, parameters.limitViolations, parameters.current, parameters.voltage, parameters.shortCircuitBusResults, parameters.timeConstant, parameters.status);
    }

    private static final class FaultResultParameters {
        FaultResult.Status status = null;
        Fault fault = null;
        double shortCircuitPower = Double.NaN;
        Duration timeConstant = null;
        FortescueValue current = null;
        FortescueValue voltage = null;
        double currentMagnitude = Double.NaN;
        double voltageMagnitude = Double.NaN;
        List<FeederResult> feederResults = Collections.emptyList();
        List<LimitViolation> limitViolations = Collections.emptyList();
        List<ShortCircuitBusResults> shortCircuitBusResults = Collections.emptyList();

        private FaultResultParameters() {
        }
    }
}

