/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.shortcircuit.FaultResult;
import com.powsybl.shortcircuit.FortescueFaultResult;
import com.powsybl.shortcircuit.MagnitudeFaultResult;
import java.io.IOException;
import java.util.Objects;

public class FaultResultSerializer
extends StdSerializer<FaultResult> {
    public FaultResultSerializer() {
        super(FaultResult.class);
    }

    public void serialize(FaultResult faultResult, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Objects.requireNonNull(faultResult);
        Objects.requireNonNull(faultResult.getFault());
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("status", String.valueOf((Object)faultResult.getStatus()));
        serializerProvider.defaultSerializeField("fault", (Object)faultResult.getFault(), jsonGenerator);
        JsonUtil.writeOptionalDoubleField((JsonGenerator)jsonGenerator, (String)"shortCircuitPower", (double)faultResult.getShortCircuitPower());
        if (faultResult.getTimeConstant() != null) {
            jsonGenerator.writeStringField("timeConstant", faultResult.getTimeConstant().toString());
        }
        if (faultResult instanceof FortescueFaultResult) {
            FortescueFaultResult fortescueFaultResult = (FortescueFaultResult)faultResult;
            this.fortescueResultSerialization(fortescueFaultResult, jsonGenerator, serializerProvider);
        } else if (faultResult instanceof MagnitudeFaultResult) {
            this.magnitudeResultSerialization(faultResult, jsonGenerator, serializerProvider);
        }
        if (!faultResult.getLimitViolations().isEmpty()) {
            serializerProvider.defaultSerializeField("limitViolations", faultResult.getLimitViolations(), jsonGenerator);
        }
        if (!faultResult.getShortCircuitBusResults().isEmpty()) {
            serializerProvider.defaultSerializeField("shortCircuitBusResults", faultResult.getShortCircuitBusResults(), jsonGenerator);
        }
        JsonUtil.writeExtensions((Extendable)faultResult, (JsonGenerator)jsonGenerator, (SerializerProvider)serializerProvider);
        jsonGenerator.writeEndObject();
    }

    private void fortescueResultSerialization(FortescueFaultResult result, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (!result.getFeederResults().isEmpty()) {
            serializerProvider.defaultSerializeField("feederResult", (Object)result.getFeederResults(), jsonGenerator);
        }
        if (result.getCurrent() != null) {
            serializerProvider.defaultSerializeField("current", (Object)result.getCurrent(), jsonGenerator);
        }
        if (result.getVoltage() != null) {
            serializerProvider.defaultSerializeField("voltage", (Object)result.getVoltage(), jsonGenerator);
        }
    }

    private void magnitudeResultSerialization(FaultResult faultResult, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (!faultResult.getFeederResults().isEmpty()) {
            serializerProvider.defaultSerializeField("feederResult", faultResult.getFeederResults(), jsonGenerator);
        }
        if (!Double.isNaN(((MagnitudeFaultResult)faultResult).getCurrent())) {
            serializerProvider.defaultSerializeField("currentMagnitude", (Object)((MagnitudeFaultResult)faultResult).getCurrent(), jsonGenerator);
        }
        if (!Double.isNaN(((MagnitudeFaultResult)faultResult).getVoltage())) {
            serializerProvider.defaultSerializeField("voltageMagnitude", (Object)((MagnitudeFaultResult)faultResult).getVoltage(), jsonGenerator);
        }
    }
}

