/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.shortcircuit.BranchFault;
import com.powsybl.shortcircuit.Fault;
import java.io.IOException;

public class FaultSerializer
extends StdSerializer<Fault> {
    public FaultSerializer() {
        super(Fault.class);
    }

    public void serialize(Fault fault, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", fault.getType().name());
        jsonGenerator.writeStringField("id", fault.getId());
        jsonGenerator.writeStringField("elementId", fault.getElementId());
        JsonUtil.writeOptionalDoubleField((JsonGenerator)jsonGenerator, (String)"r", (double)fault.getRToGround());
        JsonUtil.writeOptionalDoubleField((JsonGenerator)jsonGenerator, (String)"x", (double)fault.getXToGround());
        jsonGenerator.writeStringField("connection", fault.getConnectionType().name());
        jsonGenerator.writeStringField("faultType", fault.getFaultType().name());
        if (fault.getType() == Fault.Type.BRANCH) {
            JsonUtil.writeOptionalDoubleField((JsonGenerator)jsonGenerator, (String)"proportionalLocation", (double)((BranchFault)fault).getProportionalLocation());
        }
        jsonGenerator.writeEndObject();
    }
}

