/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.shortcircuit.FeederResult;
import com.powsybl.shortcircuit.FortescueFeederResult;
import com.powsybl.shortcircuit.FortescueValue;
import com.powsybl.shortcircuit.MagnitudeFeederResult;
import java.io.IOException;

class FeederResultDeserializer
extends StdDeserializer<FeederResult> {
    FeederResultDeserializer() {
        super(FeederResult.class);
    }

    public FeederResult deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        String connectableId = null;
        FortescueValue current = null;
        Double currentMagnitude = Double.NaN;
        ThreeSides side = null;
        block12: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.currentName()) {
                case "connectableId": {
                    parser.nextToken();
                    connectableId = (String)parser.readValueAs(String.class);
                    continue block12;
                }
                case "current": {
                    parser.nextToken();
                    current = (FortescueValue)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, FortescueValue.class);
                    continue block12;
                }
                case "currentMagnitude": {
                    parser.nextToken();
                    currentMagnitude = (Double)parser.readValueAs(Double.class);
                    continue block12;
                }
                case "side": {
                    parser.nextToken();
                    side = (ThreeSides)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, ThreeSides.class);
                    continue block12;
                }
            }
            throw new IllegalStateException("Unexpected field: " + parser.currentName());
        }
        if (current == null) {
            return new MagnitudeFeederResult(connectableId, currentMagnitude, side);
        }
        return new FortescueFeederResult(connectableId, current, side);
    }
}

