/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.shortcircuit.FeederResult;
import com.powsybl.shortcircuit.FortescueFeederResult;
import com.powsybl.shortcircuit.MagnitudeFeederResult;
import java.io.IOException;

public class FeederResultSerializer
extends StdSerializer<FeederResult> {
    public FeederResultSerializer() {
        super(FeederResult.class);
    }

    public void serialize(FeederResult result, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("connectableId", result.getConnectableId());
        if (result instanceof FortescueFeederResult) {
            FortescueFeederResult fortescueFeederResult = (FortescueFeederResult)result;
            if (fortescueFeederResult.getCurrent() != null) {
                serializerProvider.defaultSerializeField("current", (Object)fortescueFeederResult.getCurrent(), jsonGenerator);
            }
        } else if (!Double.isNaN(((MagnitudeFeederResult)result).getCurrent())) {
            serializerProvider.defaultSerializeField("currentMagnitude", (Object)((MagnitudeFeederResult)result).getCurrent(), jsonGenerator);
        }
        JsonUtil.writeOptionalEnumField((JsonGenerator)jsonGenerator, (String)"side", (Enum)result.getSide());
        jsonGenerator.writeEndObject();
    }
}

