/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit.json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.commons.extensions.ExtensionProvider;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.commons.util.ServiceLoaderCache;
import com.powsybl.shortcircuit.ShortCircuitAnalysisProvider;
import com.powsybl.shortcircuit.ShortCircuitParameters;
import com.powsybl.shortcircuit.json.ShortCircuitAnalysisJsonModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class JsonShortCircuitParameters {
    private JsonShortCircuitParameters() {
    }

    public static Map<String, ExtensionJsonSerializer> getExtensionSerializers() {
        List providers = new ServiceLoaderCache(ShortCircuitAnalysisProvider.class).getServices();
        return providers.stream().flatMap(shortCircuitAnalysisProvider -> shortCircuitAnalysisProvider.getSpecificParametersSerializer().stream()).collect(Collectors.toMap(ExtensionProvider::getExtensionName, shortCircuitAnalysisProvider -> shortCircuitAnalysisProvider));
    }

    public static ShortCircuitParameters update(ShortCircuitParameters parameters, Path jsonFile) {
        ShortCircuitParameters shortCircuitParameters;
        block8: {
            Objects.requireNonNull(jsonFile);
            InputStream is = Files.newInputStream(jsonFile, new OpenOption[0]);
            try {
                shortCircuitParameters = JsonShortCircuitParameters.update(parameters, is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return shortCircuitParameters;
    }

    public static ShortCircuitParameters update(ShortCircuitParameters parameters, InputStream is) {
        try {
            ObjectMapper objectMapper = JsonShortCircuitParameters.createObjectMapper();
            return (ShortCircuitParameters)((Object)objectMapper.readerForUpdating((Object)parameters).readValue(is));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static ObjectMapper createObjectMapper() {
        return JsonUtil.createObjectMapper().registerModule((Module)new ShortCircuitAnalysisJsonModule());
    }

    public static void write(ShortCircuitParameters parameters, Path jsonFile) {
        Objects.requireNonNull(jsonFile);
        try (OutputStream outputStream = Files.newOutputStream(jsonFile, new OpenOption[0]);){
            JsonShortCircuitParameters.write(parameters, outputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(ShortCircuitParameters parameters, OutputStream outputStream) {
        try {
            ObjectMapper objectMapper = JsonShortCircuitParameters.createObjectMapper();
            ObjectWriter writer = objectMapper.writerWithDefaultPrettyPrinter();
            writer.writeValue(outputStream, (Object)parameters);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static ShortCircuitParameters read(Path jsonFile) {
        return JsonShortCircuitParameters.update(new ShortCircuitParameters(), jsonFile);
    }

    public static ShortCircuitParameters read(InputStream jsonStream) {
        return JsonShortCircuitParameters.update(new ShortCircuitParameters(), jsonStream);
    }

    public static interface ExtensionSerializer<E extends Extension<ShortCircuitParameters>>
    extends ExtensionJsonSerializer<ShortCircuitParameters, E> {
    }
}

