/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.base.Suppliers;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.commons.extensions.ExtensionProviders;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.shortcircuit.FaultResult;
import com.powsybl.shortcircuit.ShortCircuitAnalysisResult;
import com.powsybl.shortcircuit.json.FaultResultDeserializer;
import com.powsybl.shortcircuit.json.ShortCircuitAnalysisJsonModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class ShortCircuitAnalysisResultDeserializer
extends StdDeserializer<ShortCircuitAnalysisResult> {
    private static final Supplier<ExtensionProviders<ExtensionJsonSerializer>> SUPPLIER = Suppliers.memoize(() -> ExtensionProviders.createProvider(ExtensionJsonSerializer.class, (String)"short-circuit-analysis"));

    ShortCircuitAnalysisResultDeserializer() {
        super(ShortCircuitAnalysisResult.class);
    }

    public ShortCircuitAnalysisResult deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        String version = null;
        List<FaultResult> faultResults = null;
        List extensions = Collections.emptyList();
        block10: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.currentName()) {
                case "version": {
                    parser.nextToken();
                    version = (String)parser.readValueAs(String.class);
                    ctx.setAttribute((Object)"violationLocationSupport", (Object)(version.compareTo("1.3") >= 0 ? 1 : 0));
                    continue block10;
                }
                case "faultResults": {
                    faultResults = new FaultResultDeserializer().deserialize(parser, ctx, version);
                    continue block10;
                }
                case "extensions": {
                    parser.nextToken();
                    extensions = JsonUtil.readExtensions((JsonParser)parser, (DeserializationContext)ctx, SUPPLIER.get());
                    continue block10;
                }
            }
            throw new IllegalStateException("Unexpected field: " + parser.currentName());
        }
        ShortCircuitAnalysisResult result = new ShortCircuitAnalysisResult(faultResults);
        SUPPLIER.get().addExtensions((Extendable)result, extensions);
        return result;
    }

    public static ShortCircuitAnalysisResult read(Path jsonFile) {
        ShortCircuitAnalysisResult shortCircuitAnalysisResult;
        block8: {
            InputStream is = Files.newInputStream(jsonFile, new OpenOption[0]);
            try {
                shortCircuitAnalysisResult = ShortCircuitAnalysisResultDeserializer.read(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return shortCircuitAnalysisResult;
    }

    public static ShortCircuitAnalysisResult read(InputStream is) {
        Objects.requireNonNull(is);
        ObjectMapper objectMapper = JsonUtil.createObjectMapper().registerModule((Module)new ShortCircuitAnalysisJsonModule());
        try {
            return (ShortCircuitAnalysisResult)((Object)objectMapper.readValue(is, ShortCircuitAnalysisResult.class));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

