/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.shortcircuit.FortescueShortCircuitBusResults;
import com.powsybl.shortcircuit.FortescueValue;
import com.powsybl.shortcircuit.MagnitudeShortCircuitBusResults;
import com.powsybl.shortcircuit.ShortCircuitBusResults;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class ShortCircuitBusResultsDeserializer {
    private static final String CONTEXT_NAME = "ShortCircuitBusResults";

    ShortCircuitBusResultsDeserializer() {
    }

    public List<ShortCircuitBusResults> deserialize(JsonParser parser, String version) throws IOException {
        ArrayList<ShortCircuitBusResults> shortCircuitBusResults = new ArrayList<ShortCircuitBusResults>();
        parser.nextToken();
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            String voltageLevelId = null;
            String busId = null;
            Double initialVoltageMagnitude = Double.NaN;
            FortescueValue voltage = null;
            Double voltageMagnitude = Double.NaN;
            Double voltageDropProportional = Double.NaN;
            block17: while (parser.nextToken() != JsonToken.END_OBJECT) {
                switch (parser.currentName()) {
                    case "voltageLevelId": {
                        parser.nextToken();
                        voltageLevelId = (String)parser.readValueAs(String.class);
                        continue block17;
                    }
                    case "busId": {
                        parser.nextToken();
                        busId = (String)parser.readValueAs(String.class);
                        continue block17;
                    }
                    case "initialVoltageMagnitude": {
                        JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: initialVoltageMagnitude", (String)version, (String)"1.1");
                        parser.nextToken();
                        initialVoltageMagnitude = (Double)parser.readValueAs(Double.class);
                        continue block17;
                    }
                    case "voltage": {
                        parser.nextToken();
                        voltage = (FortescueValue)parser.readValueAs(FortescueValue.class);
                        continue block17;
                    }
                    case "voltageMagnitude": {
                        JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: voltageMagnitude", (String)version, (String)"1.1");
                        parser.nextToken();
                        voltageMagnitude = (Double)parser.readValueAs(Double.class);
                        continue block17;
                    }
                    case "voltageDropProportional": {
                        JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: voltageDropProportional", (String)version, (String)"1.1");
                        parser.nextToken();
                        voltageDropProportional = (Double)parser.readValueAs(Double.class);
                        continue block17;
                    }
                }
                throw new IllegalStateException("Unexpected field: " + parser.currentName());
            }
            if (voltage != null) {
                shortCircuitBusResults.add(new FortescueShortCircuitBusResults(voltageLevelId, busId, initialVoltageMagnitude, voltage, voltageDropProportional));
                continue;
            }
            shortCircuitBusResults.add(new MagnitudeShortCircuitBusResults(voltageLevelId, busId, initialVoltageMagnitude, voltageMagnitude, voltageDropProportional));
        }
        return shortCircuitBusResults;
    }
}

