/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.shortcircuit.FortescueShortCircuitBusResults;
import com.powsybl.shortcircuit.MagnitudeShortCircuitBusResults;
import com.powsybl.shortcircuit.ShortCircuitBusResults;
import java.io.IOException;
import java.util.Objects;

public class ShortCircuitBusResultsSerializer
extends StdSerializer<ShortCircuitBusResults> {
    public ShortCircuitBusResultsSerializer() {
        super(ShortCircuitBusResults.class);
    }

    public void serialize(ShortCircuitBusResults busResults, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        MagnitudeShortCircuitBusResults magnitudeShortCircuitBusResults;
        FortescueShortCircuitBusResults fortescueShortCircuitBusResults;
        Objects.requireNonNull(busResults);
        jsonGenerator.writeStartObject();
        JsonUtil.writeOptionalStringField((JsonGenerator)jsonGenerator, (String)"voltageLevelId", (String)busResults.getVoltageLevelId());
        JsonUtil.writeOptionalStringField((JsonGenerator)jsonGenerator, (String)"busId", (String)busResults.getBusId());
        if (!Double.isNaN(busResults.getInitialVoltageMagnitude())) {
            serializerProvider.defaultSerializeField("initialVoltageMagnitude", (Object)busResults.getInitialVoltageMagnitude(), jsonGenerator);
        }
        if (busResults instanceof FortescueShortCircuitBusResults && (fortescueShortCircuitBusResults = (FortescueShortCircuitBusResults)busResults).getVoltage() != null) {
            serializerProvider.defaultSerializeField("voltage", (Object)fortescueShortCircuitBusResults.getVoltage(), jsonGenerator);
        }
        if (busResults instanceof MagnitudeShortCircuitBusResults && !Double.isNaN((magnitudeShortCircuitBusResults = (MagnitudeShortCircuitBusResults)busResults).getVoltage())) {
            serializerProvider.defaultSerializeField("voltageMagnitude", (Object)magnitudeShortCircuitBusResults.getVoltage(), jsonGenerator);
        }
        if (!Double.isNaN(busResults.getVoltageDropProportional())) {
            serializerProvider.defaultSerializeField("voltageDropProportional", (Object)busResults.getVoltageDropProportional(), jsonGenerator);
        }
        jsonGenerator.writeEndObject();
    }
}

