/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.shortcircuit.InitialVoltageProfileMode;
import com.powsybl.shortcircuit.ShortCircuitParameters;
import com.powsybl.shortcircuit.StudyType;
import com.powsybl.shortcircuit.VoltageRange;
import com.powsybl.shortcircuit.json.JsonShortCircuitParameters;
import com.powsybl.shortcircuit.json.ParametersDeserializationConstants;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class ShortCircuitParametersDeserializer
extends StdDeserializer<ShortCircuitParameters> {
    private static final String CONTEXT_NAME = "ShortCircuitFaultParameters";
    private static final String TAG = "Tag: ";

    public ShortCircuitParametersDeserializer() {
        super(ShortCircuitParameters.class);
    }

    public ShortCircuitParameters deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        return this.deserialize(parser, deserializationContext, new ShortCircuitParameters());
    }

    public ShortCircuitParameters deserialize(JsonParser parser, DeserializationContext deserializationContext, ShortCircuitParameters parameters) throws IOException {
        String version = null;
        List extensions = Collections.emptyList();
        block40: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.currentName()) {
                case "version": {
                    parser.nextToken();
                    version = parser.getValueAsString();
                    JsonUtil.setSourceVersion((DatabindContext)deserializationContext, (String)version, (String)"sourceVersionAttribute");
                    deserializationContext.setAttribute((Object)"sourceParameterTypeAttribute", (Object)ParametersDeserializationConstants.ParametersType.SHORT_CIRCUIT);
                    continue block40;
                }
                case "withLimitViolations": {
                    parser.nextToken();
                    parameters.setWithLimitViolations((Boolean)parser.readValueAs(Boolean.class));
                    continue block40;
                }
                case "withVoltageMap": {
                    JsonUtil.assertLessThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.1");
                    parser.nextToken();
                    parameters.setWithVoltageResult((Boolean)parser.readValueAs(Boolean.class));
                    continue block40;
                }
                case "withVoltageResult": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.1");
                    parser.nextToken();
                    parameters.setWithVoltageResult((Boolean)parser.readValueAs(Boolean.class));
                    continue block40;
                }
                case "withFeederResult": {
                    parser.nextToken();
                    parameters.setWithFeederResult((Boolean)parser.readValueAs(Boolean.class));
                    continue block40;
                }
                case "studyType": {
                    parser.nextToken();
                    parameters.setStudyType((StudyType)((Object)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, StudyType.class)));
                    continue block40;
                }
                case "minVoltageDropProportionalThreshold": {
                    parser.nextToken();
                    parameters.setMinVoltageDropProportionalThreshold((Double)parser.readValueAs(Double.class));
                    continue block40;
                }
                case "withFortescueResult": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.1");
                    parser.nextToken();
                    parameters.setWithFortescueResult((Boolean)parser.readValueAs(Boolean.class));
                    continue block40;
                }
                case "subTransientCoefficient": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.2");
                    parser.nextToken();
                    parameters.setSubTransientCoefficient((Double)parser.readValueAs(Double.class));
                    continue block40;
                }
                case "withLoads": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.2");
                    parser.nextToken();
                    parameters.setWithLoads((Boolean)parser.readValueAs(Boolean.class));
                    continue block40;
                }
                case "withShuntCompensators": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.2");
                    parser.nextToken();
                    parameters.setWithShuntCompensators((Boolean)parser.readValueAs(Boolean.class));
                    continue block40;
                }
                case "withVSCConverterStations": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.2");
                    parser.nextToken();
                    parameters.setWithVSCConverterStations((Boolean)parser.readValueAs(Boolean.class));
                    continue block40;
                }
                case "withNeutralPosition": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.2");
                    parser.nextToken();
                    parameters.setWithNeutralPosition((Boolean)parser.readValueAs(Boolean.class));
                    continue block40;
                }
                case "initialVoltageProfileMode": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.2");
                    parser.nextToken();
                    parameters.setInitialVoltageProfileMode((InitialVoltageProfileMode)((Object)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, InitialVoltageProfileMode.class)));
                    continue block40;
                }
                case "voltageRanges": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.2");
                    parser.nextToken();
                    parameters.setVoltageRanges(JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, VoltageRange.class));
                    continue block40;
                }
                case "detailedReport": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.3");
                    parser.nextToken();
                    parameters.setDetailedReport((Boolean)parser.readValueAs(Boolean.class));
                    continue block40;
                }
                case "debugDir": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)(TAG + parser.currentName()), (String)version, (String)"1.4");
                    parser.nextToken();
                    parameters.setDebugDir((String)parser.readValueAs(String.class));
                    continue block40;
                }
                case "extensions": {
                    parser.nextToken();
                    extensions = JsonUtil.updateExtensions((JsonParser)parser, (DeserializationContext)deserializationContext, JsonShortCircuitParameters.getExtensionSerializers()::get, (Extendable)parameters);
                    continue block40;
                }
            }
            throw new IllegalStateException("Unexpected field: " + parser.currentName());
        }
        extensions.forEach(extension -> parameters.addExtension(extension.getClass(), (Extension)extension));
        parameters.validate();
        return parameters;
    }
}

