/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.shortcircuit.InitialVoltageProfileMode;
import com.powsybl.shortcircuit.ShortCircuitParameters;
import com.powsybl.shortcircuit.StudyType;
import com.powsybl.shortcircuit.json.JsonShortCircuitParameters;
import java.io.IOException;

public class ShortCircuitParametersSerializer
extends StdSerializer<ShortCircuitParameters> {
    public ShortCircuitParametersSerializer() {
        super(ShortCircuitParameters.class);
    }

    public void serialize(ShortCircuitParameters parameters, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("version", "1.4");
        jsonGenerator.writeBooleanField("withLimitViolations", parameters.isWithLimitViolations());
        jsonGenerator.writeBooleanField("withVoltageResult", parameters.isWithVoltageResult());
        jsonGenerator.writeBooleanField("withFeederResult", parameters.isWithFeederResult());
        jsonGenerator.writeStringField("studyType", parameters.getStudyType().name());
        if (parameters.getStudyType() == StudyType.SUB_TRANSIENT) {
            JsonUtil.writeOptionalDoubleField((JsonGenerator)jsonGenerator, (String)"subTransientCoefficient", (double)parameters.getSubTransientCoefficient());
        }
        JsonUtil.writeOptionalDoubleField((JsonGenerator)jsonGenerator, (String)"minVoltageDropProportionalThreshold", (double)parameters.getMinVoltageDropProportionalThreshold());
        jsonGenerator.writeBooleanField("withFortescueResult", parameters.isWithFortescueResult());
        jsonGenerator.writeBooleanField("withLoads", parameters.isWithLoads());
        jsonGenerator.writeBooleanField("withShuntCompensators", parameters.isWithShuntCompensators());
        jsonGenerator.writeBooleanField("withVSCConverterStations", parameters.isWithVSCConverterStations());
        jsonGenerator.writeBooleanField("withNeutralPosition", parameters.isWithNeutralPosition());
        jsonGenerator.writeStringField("initialVoltageProfileMode", parameters.getInitialVoltageProfileMode().name());
        if (parameters.getInitialVoltageProfileMode() == InitialVoltageProfileMode.CONFIGURED) {
            serializerProvider.defaultSerializeField("voltageRanges", parameters.getVoltageRanges(), jsonGenerator);
        }
        jsonGenerator.writeBooleanField("detailedReport", parameters.isDetailedReport());
        JsonUtil.writeOptionalStringField((JsonGenerator)jsonGenerator, (String)"debugDir", (String)parameters.getDebugDir());
        JsonUtil.writeExtensions((Extendable)parameters, (JsonGenerator)jsonGenerator, (SerializerProvider)serializerProvider, JsonShortCircuitParameters.getExtensionSerializers()::get);
        jsonGenerator.writeEndObject();
    }
}

