/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.shortcircuit.VoltageRange;
import java.io.IOException;

public class VoltageRangeDeserializer
extends StdDeserializer<VoltageRange> {
    private static final String CONTEXT_NAME = "VoltageRange";

    public VoltageRangeDeserializer() {
        super(VoltageRange.class);
    }

    public VoltageRange deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        Double minimumVoltage = Double.NaN;
        Double maximumVoltage = Double.NaN;
        Double coefficient = Double.NaN;
        Double voltage = Double.NaN;
        String version = JsonUtil.getSourceVersion((DatabindContext)context, (String)"sourceVersionAttribute");
        block12: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.currentName()) {
                case "minimumNominalVoltage": {
                    parser.nextToken();
                    minimumVoltage = (Double)parser.readValueAs(Double.class);
                    continue block12;
                }
                case "maximumNominalVoltage": {
                    parser.nextToken();
                    maximumVoltage = (Double)parser.readValueAs(Double.class);
                    continue block12;
                }
                case "voltageRangeCoefficient": {
                    parser.nextToken();
                    coefficient = (Double)parser.readValueAs(Double.class);
                    continue block12;
                }
                case "voltage": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)("Tag: " + parser.currentName()), (String)version, (String)"1.3");
                    parser.nextToken();
                    voltage = (Double)parser.readValueAs(Double.class);
                    continue block12;
                }
            }
            throw new IllegalStateException("Unexpected field: " + parser.currentName());
        }
        return new VoltageRange(minimumVoltage, maximumVoltage, coefficient, voltage);
    }
}

