/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.shortcircuit.tools;

import com.google.auto.service.AutoService;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.network.Network;
import com.powsybl.shortcircuit.Fault;
import com.powsybl.shortcircuit.FaultParameters;
import com.powsybl.shortcircuit.ShortCircuitAnalysis;
import com.powsybl.shortcircuit.ShortCircuitAnalysisResult;
import com.powsybl.shortcircuit.ShortCircuitParameters;
import com.powsybl.shortcircuit.converter.ShortCircuitAnalysisResultExporters;
import com.powsybl.shortcircuit.json.JsonShortCircuitParameters;
import com.powsybl.shortcircuit.tools.ShortCircuitInput;
import com.powsybl.tools.Command;
import com.powsybl.tools.Tool;
import com.powsybl.tools.ToolOptions;
import com.powsybl.tools.ToolRunningContext;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@AutoService(value={Tool.class})
public class ShortCircuitAnalysisTool
implements Tool {
    public Command getCommand() {
        return new Command(){

            public String getDescription() {
                return "Run short circuit analysis";
            }

            public String getName() {
                return "shortcircuit";
            }

            public Options getOptions() {
                Options options = new Options();
                options.addOption(Option.builder().longOpt("input-file").desc("fault list as JSON file").hasArg().argName("FILE").required().build());
                options.addOption(Option.builder().longOpt("case-file").desc("the case path").hasArg().argName("FILE").required().build());
                options.addOption(Option.builder().longOpt("parameters-file").desc("short circuit parameters as JSON file").hasArg().argName("FILE").build());
                options.addOption(Option.builder().longOpt("output-file").desc("the output path").hasArg().argName("FILE").build());
                options.addOption(Option.builder().longOpt("output-format").desc("the output format " + ShortCircuitAnalysisResultExporters.getFormats()).hasArg().argName("FORMAT").build());
                options.addOption(Option.builder().longOpt("fault-parameters-file").desc("fault parameters file (.json) to get network's info after computation").hasArg().argName("FILE").build());
                return options;
            }

            public String getTheme() {
                return "Computation";
            }

            public String getUsageFooter() {
                return null;
            }
        };
    }

    static Network readNetwork(CommandLine line, ToolRunningContext context) {
        ToolOptions options = new ToolOptions(line, context);
        Path caseFile = (Path)options.getPath("case-file").orElseThrow(IllegalStateException::new);
        context.getOutputStream().println("Loading network '" + caseFile + "'");
        return Network.read((Path)caseFile);
    }

    static ShortCircuitInput readInput(CommandLine line, ToolRunningContext context) throws ParseException {
        ToolOptions options = new ToolOptions(line, context);
        ShortCircuitInput input = new ShortCircuitInput();
        Path inputFile = (Path)options.getPath("input-file").orElseThrow(() -> new ParseException("Missing required option: input-file"));
        context.getOutputStream().println("Loading input '" + inputFile + "'");
        input.setFaults(Fault.read(inputFile));
        input.setParameters(ShortCircuitParameters.load());
        options.getPath("parameters-file").ifPresent(parametersFile -> {
            context.getOutputStream().println("Loading parameters '" + parametersFile + "'");
            JsonShortCircuitParameters.update(input.getParameters(), parametersFile);
        });
        options.getPath("fault-parameters-file").ifPresent(faultParametersFilePath -> {
            context.getOutputStream().println("Loading fault parameters '" + faultParametersFilePath + "'");
            input.setFaultParameters(FaultParameters.read(faultParametersFilePath));
        });
        return input;
    }

    public void run(CommandLine line, ToolRunningContext context) throws Exception {
        ToolOptions options = new ToolOptions(line, context);
        Path outputFile = options.getPath("output-file").orElse(null);
        String format = null;
        if (outputFile != null) {
            format = (String)options.getValue("output-format").orElseThrow(() -> new ParseException("Missing required option: output-format"));
        }
        Network network = ShortCircuitAnalysisTool.readNetwork(line, context);
        ComputationManager computationManager = context.getShortTimeExecutionComputationManager();
        ShortCircuitInput executionInput = ShortCircuitAnalysisTool.readInput(line, context);
        ShortCircuitAnalysisResult shortCircuitAnalysisResult = ShortCircuitAnalysis.runAsync(network, executionInput.getFaults(), executionInput.getParameters(), computationManager, executionInput.getFaultParameters()).join();
        if (shortCircuitAnalysisResult != null) {
            if (outputFile != null) {
                context.getOutputStream().println("Writing results to '" + outputFile + "'");
                ShortCircuitAnalysisResultExporters.export(shortCircuitAnalysisResult, outputFile, format, network);
            } else {
                OutputStreamWriter writer = new OutputStreamWriter(context.getOutputStream());
                ShortCircuitAnalysisResultExporters.export(shortCircuitAnalysisResult, writer, "ASCII", network);
            }
        } else {
            context.getErrorStream().println("Error. No results to be displayed!");
        }
    }
}

