/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Network;
import com.powsybl.sld.builders.NetworkGraphBuilder;
import com.powsybl.sld.layout.HorizontalSubstationLayoutFactory;
import com.powsybl.sld.layout.LayoutParameters;
import com.powsybl.sld.layout.SmartVoltageLevelLayoutFactory;
import com.powsybl.sld.layout.SubstationLayoutFactory;
import com.powsybl.sld.layout.VoltageLevelLayoutFactory;
import com.powsybl.sld.library.ComponentLibrary;
import com.powsybl.sld.library.ConvergenceComponentLibrary;
import com.powsybl.sld.model.graphs.Graph;
import com.powsybl.sld.model.graphs.SubstationGraph;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.svg.DefaultDiagramLabelProvider;
import com.powsybl.sld.svg.DefaultSVGWriter;
import com.powsybl.sld.svg.DiagramLabelProvider;
import com.powsybl.sld.svg.GraphMetadata;
import com.powsybl.sld.svg.styles.StyleProvider;
import com.powsybl.sld.svg.styles.StyleProvidersList;
import com.powsybl.sld.svg.styles.iidm.HighlightLineStateStyleProvider;
import com.powsybl.sld.svg.styles.iidm.TopologicalStyleProvider;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SingleLineDiagram {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleLineDiagram.class);

    private SingleLineDiagram() {
    }

    public static void draw(Network network, String id, String svgFile) {
        SingleLineDiagram.draw(network, id, Path.of(svgFile, new String[0]));
    }

    public static void draw(Network network, String id, Path svgFile) {
        SingleLineDiagram.draw(network, id, svgFile, new LayoutParameters());
    }

    public static void draw(Network network, String id, Path svgFile, LayoutParameters layoutParameters) {
        SingleLineDiagram.draw(network, id, svgFile, layoutParameters, new ConvergenceComponentLibrary());
    }

    public static void draw(Network network, String id, Path svgFile, LayoutParameters layoutParameters, ComponentLibrary componentLibrary) {
        SingleLineDiagram.draw(network, id, svgFile, layoutParameters, componentLibrary, (DiagramLabelProvider)new DefaultDiagramLabelProvider(network, componentLibrary, layoutParameters), SingleLineDiagram.createDefaultStyleProvider(network), "");
    }

    public static void draw(Network network, String id, Path svgFile, LayoutParameters layoutParameters, ComponentLibrary componentLibrary, DiagramLabelProvider initProvider, StyleProvider styleProvider, String prefixId) {
        SingleLineDiagram.draw(network, id, svgFile, layoutParameters, componentLibrary, new HorizontalSubstationLayoutFactory(), new SmartVoltageLevelLayoutFactory(network), initProvider, styleProvider, prefixId);
    }

    private static Identifiable<?> getIdentifiable(Network network, String id) {
        Identifiable identifiable = network.getIdentifiable(id);
        if (identifiable == null) {
            throw new PowsyblException("Network element '" + id + "' not found");
        }
        return identifiable;
    }

    public static void draw(Network network, String id, Path svgFile, LayoutParameters layoutParameters, ComponentLibrary componentLibrary, SubstationLayoutFactory sLayoutFactory, VoltageLevelLayoutFactory vLayoutFactory, DiagramLabelProvider initProvider, StyleProvider styleProvider, String prefixId) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(id);
        Identifiable<?> identifiable = SingleLineDiagram.getIdentifiable(network, id);
        if (identifiable.getType() == IdentifiableType.VOLTAGE_LEVEL) {
            SingleLineDiagram.drawVoltageLevel(network, id, svgFile, layoutParameters, componentLibrary, vLayoutFactory, initProvider, styleProvider, prefixId);
        } else if (identifiable.getType() == IdentifiableType.SUBSTATION) {
            SingleLineDiagram.drawSubstation(network, id, svgFile, layoutParameters, componentLibrary, sLayoutFactory, vLayoutFactory, initProvider, styleProvider, prefixId);
        } else {
            throw new PowsyblException("Given id '" + id + "' is not a substation or voltage level id in given network '" + network.getId() + "'");
        }
    }

    public static void drawVoltageLevel(Network network, String id, String svgFile) {
        SingleLineDiagram.drawVoltageLevel(network, id, Path.of(svgFile, new String[0]));
    }

    public static void drawVoltageLevel(Network network, String id, Path svgFile) {
        SingleLineDiagram.drawVoltageLevel(network, id, svgFile, new LayoutParameters());
    }

    public static void drawVoltageLevel(Network network, String id, Path svgFile, LayoutParameters layoutParameters) {
        SingleLineDiagram.drawVoltageLevel(network, id, svgFile, layoutParameters, new ConvergenceComponentLibrary());
    }

    public static void drawVoltageLevel(Network network, String id, Path svgFile, LayoutParameters layoutParameters, ComponentLibrary componentLibrary) {
        SingleLineDiagram.drawVoltageLevel(network, id, svgFile, layoutParameters, componentLibrary, new DefaultDiagramLabelProvider(network, componentLibrary, layoutParameters), SingleLineDiagram.createDefaultStyleProvider(network), "");
    }

    public static void drawVoltageLevel(Network network, String id, Path svgFile, LayoutParameters layoutParameters, ComponentLibrary componentLibrary, DiagramLabelProvider initProvider, StyleProvider styleProvider, String prefixId) {
        SingleLineDiagram.drawVoltageLevel(network, id, svgFile, layoutParameters, componentLibrary, new SmartVoltageLevelLayoutFactory(network), initProvider, styleProvider, prefixId);
    }

    private static void drawVoltageLevel(Network network, String voltageLevelId, Path svgFile, LayoutParameters layoutParameters, ComponentLibrary componentLibrary, VoltageLevelLayoutFactory vLayoutFactory, DiagramLabelProvider initProvider, StyleProvider styleProvider, String prefixId) {
        Objects.requireNonNull(vLayoutFactory);
        VoltageLevelGraph voltageLevelGraph = new NetworkGraphBuilder(network).buildVoltageLevelGraph(voltageLevelId);
        vLayoutFactory.create(voltageLevelGraph).run(layoutParameters);
        SingleLineDiagram.draw((Graph)voltageLevelGraph, svgFile, layoutParameters, componentLibrary, initProvider, styleProvider, prefixId);
    }

    public static void drawSubstation(Network network, String id, String svgFile) {
        SingleLineDiagram.drawSubstation(network, id, Path.of(svgFile, new String[0]));
    }

    public static void drawSubstation(Network network, String id, Path svgFile) {
        SingleLineDiagram.drawSubstation(network, id, svgFile, new LayoutParameters());
    }

    public static void drawSubstation(Network network, String id, Path svgFile, LayoutParameters layoutParameters) {
        SingleLineDiagram.drawSubstation(network, id, svgFile, layoutParameters, new ConvergenceComponentLibrary());
    }

    public static void drawSubstation(Network network, String id, Path svgFile, LayoutParameters layoutParameters, ComponentLibrary componentLibrary) {
        SingleLineDiagram.drawSubstation(network, id, svgFile, layoutParameters, componentLibrary, new DefaultDiagramLabelProvider(network, componentLibrary, layoutParameters), SingleLineDiagram.createDefaultStyleProvider(network), "");
    }

    public static void drawSubstation(Network network, String id, Path svgFile, LayoutParameters layoutParameters, ComponentLibrary componentLibrary, DiagramLabelProvider initProvider, StyleProvider styleProvider, String prefixId) {
        SingleLineDiagram.drawSubstation(network, id, svgFile, layoutParameters, componentLibrary, new HorizontalSubstationLayoutFactory(), new SmartVoltageLevelLayoutFactory(network), initProvider, styleProvider, prefixId);
    }

    private static void drawSubstation(Network network, String substationId, Path svgFile, LayoutParameters layoutParameters, ComponentLibrary componentLibrary, SubstationLayoutFactory sLayoutFactory, VoltageLevelLayoutFactory vLayoutFactory, DiagramLabelProvider initProvider, StyleProvider styleProvider, String prefixId) {
        Objects.requireNonNull(sLayoutFactory);
        Objects.requireNonNull(vLayoutFactory);
        SubstationGraph substationGraph = new NetworkGraphBuilder(network).buildSubstationGraph(substationId);
        sLayoutFactory.create(substationGraph, vLayoutFactory).run(layoutParameters);
        SingleLineDiagram.draw((Graph)substationGraph, svgFile, layoutParameters, componentLibrary, initProvider, styleProvider, prefixId);
    }

    public static void draw(Graph graph, Path svgFile, LayoutParameters layoutParameters, ComponentLibrary componentLibrary, DiagramLabelProvider initProvider, StyleProvider styleProvider, String prefixId) {
        Objects.requireNonNull(svgFile);
        Path dir = svgFile.toAbsolutePath().getParent();
        Object svgFileName = svgFile.getFileName().toString();
        if (!((String)svgFileName).endsWith(".svg")) {
            svgFileName = (String)svgFileName + ".svg";
        }
        try (BufferedWriter writerForSvg = Files.newBufferedWriter(svgFile, StandardCharsets.UTF_8, new OpenOption[0]);
             BufferedWriter metadataWriter = Files.newBufferedWriter(dir.resolve(((String)svgFileName).replace(".svg", "_metadata.json")), StandardCharsets.UTF_8, new OpenOption[0]);){
            SingleLineDiagram.draw(graph, writerForSvg, metadataWriter, layoutParameters, componentLibrary, initProvider, styleProvider, prefixId);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void draw(Network network, String id, Writer writerForSvg, Writer metadataWriter) {
        SingleLineDiagram.draw(network, id, writerForSvg, metadataWriter, new LayoutParameters());
    }

    public static void draw(Network network, String id, Writer writerForSvg, Writer metadataWriter, LayoutParameters layoutParameters) {
        SingleLineDiagram.draw(network, id, writerForSvg, metadataWriter, layoutParameters, new ConvergenceComponentLibrary());
    }

    public static void draw(Network network, String id, Writer writerForSvg, Writer metadataWriter, LayoutParameters layoutParameters, ComponentLibrary componentLibrary) {
        SingleLineDiagram.draw(network, id, writerForSvg, metadataWriter, layoutParameters, componentLibrary, new DefaultDiagramLabelProvider(network, componentLibrary, layoutParameters), SingleLineDiagram.createDefaultStyleProvider(network), "");
    }

    public static void draw(Network network, String id, Writer writerForSvg, Writer metadataWriter, LayoutParameters layoutParameters, ComponentLibrary componentLibrary, DiagramLabelProvider initProvider, StyleProvider styleProvider, String prefixId) {
        SingleLineDiagram.draw(network, id, writerForSvg, metadataWriter, layoutParameters, componentLibrary, new HorizontalSubstationLayoutFactory(), new SmartVoltageLevelLayoutFactory(network), initProvider, styleProvider, prefixId);
    }

    public static void draw(Network network, String id, Writer writerForSvg, Writer metadataWriter, LayoutParameters layoutParameters, ComponentLibrary componentLibrary, SubstationLayoutFactory sLayoutFactory, VoltageLevelLayoutFactory vLayoutFactory, DiagramLabelProvider initProvider, StyleProvider styleProvider, String prefixId) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(id);
        Identifiable<?> identifiable = SingleLineDiagram.getIdentifiable(network, id);
        if (identifiable.getType() == IdentifiableType.VOLTAGE_LEVEL) {
            SingleLineDiagram.drawVoltageLevel(network, id, writerForSvg, metadataWriter, layoutParameters, componentLibrary, vLayoutFactory, initProvider, styleProvider, prefixId);
        } else if (identifiable.getType() == IdentifiableType.SUBSTATION) {
            SingleLineDiagram.drawSubstation(network, id, writerForSvg, metadataWriter, layoutParameters, componentLibrary, sLayoutFactory, vLayoutFactory, initProvider, styleProvider, prefixId);
        } else {
            throw new PowsyblException("Given id '" + id + "' is not a substation or voltage level id in given network '" + network.getId() + "'");
        }
    }

    public static void drawVoltageLevel(Network network, String id, Writer writerForSvg, Writer metadataWriter) {
        SingleLineDiagram.drawVoltageLevel(network, id, writerForSvg, metadataWriter, new LayoutParameters());
    }

    public static void drawVoltageLevel(Network network, String id, Writer writerForSvg, Writer metadataWriter, LayoutParameters layoutParameters) {
        SingleLineDiagram.drawVoltageLevel(network, id, writerForSvg, metadataWriter, layoutParameters, new ConvergenceComponentLibrary());
    }

    public static void drawVoltageLevel(Network network, String id, Writer writerForSvg, Writer metadataWriter, LayoutParameters layoutParameters, ComponentLibrary componentLibrary) {
        SingleLineDiagram.drawVoltageLevel(network, id, writerForSvg, metadataWriter, layoutParameters, componentLibrary, (DiagramLabelProvider)new DefaultDiagramLabelProvider(network, componentLibrary, layoutParameters), SingleLineDiagram.createDefaultStyleProvider(network), "");
    }

    public static void drawVoltageLevel(Network network, String id, Writer writerForSvg, Writer metadataWriter, LayoutParameters layoutParameters, ComponentLibrary componentLibrary, DiagramLabelProvider initProvider, StyleProvider styleProvider, String prefixId) {
        SingleLineDiagram.drawVoltageLevel(network, id, writerForSvg, metadataWriter, layoutParameters, componentLibrary, new SmartVoltageLevelLayoutFactory(network), initProvider, styleProvider, prefixId);
    }

    private static void drawVoltageLevel(Network network, String voltageLevelId, Writer writerForSvg, Writer metadataWriter, LayoutParameters layoutParameters, ComponentLibrary componentLibrary, VoltageLevelLayoutFactory vLayoutFactory, DiagramLabelProvider initProvider, StyleProvider styleProvider, String prefixId) {
        Objects.requireNonNull(vLayoutFactory);
        VoltageLevelGraph voltageLevelGraph = new NetworkGraphBuilder(network).buildVoltageLevelGraph(voltageLevelId);
        vLayoutFactory.create(voltageLevelGraph).run(layoutParameters);
        SingleLineDiagram.draw(voltageLevelGraph, writerForSvg, metadataWriter, layoutParameters, componentLibrary, initProvider, styleProvider, prefixId);
    }

    public static void drawSubstation(Network network, String id, Writer writerForSvg, Writer metadataWriter) {
        SingleLineDiagram.drawSubstation(network, id, writerForSvg, metadataWriter, new LayoutParameters());
    }

    public static void drawSubstation(Network network, String id, Writer writerForSvg, Writer metadataWriter, LayoutParameters layoutParameters) {
        SingleLineDiagram.drawSubstation(network, id, writerForSvg, metadataWriter, layoutParameters, new ConvergenceComponentLibrary());
    }

    public static void drawSubstation(Network network, String id, Writer writerForSvg, Writer metadataWriter, LayoutParameters layoutParameters, ComponentLibrary componentLibrary) {
        SingleLineDiagram.drawSubstation(network, id, writerForSvg, metadataWriter, layoutParameters, componentLibrary, new DefaultDiagramLabelProvider(network, componentLibrary, layoutParameters), SingleLineDiagram.createDefaultStyleProvider(network), "");
    }

    public static void drawSubstation(Network network, String id, Writer writerForSvg, Writer metadataWriter, LayoutParameters layoutParameters, ComponentLibrary componentLibrary, DiagramLabelProvider initProvider, StyleProvider styleProvider, String prefixId) {
        SingleLineDiagram.drawSubstation(network, id, writerForSvg, metadataWriter, layoutParameters, componentLibrary, new HorizontalSubstationLayoutFactory(), new SmartVoltageLevelLayoutFactory(network), initProvider, styleProvider, prefixId);
    }

    private static void drawSubstation(Network network, String substationId, Writer writerForSvg, Writer metadataWriter, LayoutParameters layoutParameters, ComponentLibrary componentLibrary, SubstationLayoutFactory sLayoutFactory, VoltageLevelLayoutFactory vLayoutFactory, DiagramLabelProvider initProvider, StyleProvider styleProvider, String prefixId) {
        Objects.requireNonNull(sLayoutFactory);
        Objects.requireNonNull(vLayoutFactory);
        SubstationGraph substationGraph = new NetworkGraphBuilder(network).buildSubstationGraph(substationId);
        sLayoutFactory.create(substationGraph, vLayoutFactory).run(layoutParameters);
        SingleLineDiagram.draw(substationGraph, writerForSvg, metadataWriter, layoutParameters, componentLibrary, initProvider, styleProvider, prefixId);
    }

    public static void draw(Graph graph, Writer writerForSvg, Writer metadataWriter, LayoutParameters layoutParameters, ComponentLibrary componentLibrary, DiagramLabelProvider initProvider, StyleProvider styleProvider, String prefixId) {
        SingleLineDiagram.draw(graph, writerForSvg, metadataWriter, new DefaultSVGWriter(componentLibrary, layoutParameters), initProvider, styleProvider, prefixId);
    }

    public static void draw(Graph graph, Writer writerForSvg, Writer metadataWriter, DefaultSVGWriter svgWriter, DiagramLabelProvider initProvider, StyleProvider styleProvider, String prefixId) {
        Objects.requireNonNull(graph);
        Objects.requireNonNull(svgWriter);
        Objects.requireNonNull(initProvider);
        Objects.requireNonNull(styleProvider);
        Objects.requireNonNull(prefixId);
        Objects.requireNonNull(writerForSvg);
        Objects.requireNonNull(metadataWriter);
        LOGGER.info("Writing SVG and JSON metadata files...");
        GraphMetadata metadata = svgWriter.write(prefixId, graph, initProvider, styleProvider, writerForSvg);
        metadata.writeJson(metadataWriter);
    }

    private static StyleProvider createDefaultStyleProvider(Network network) {
        return new StyleProvidersList(new TopologicalStyleProvider(network), new HighlightLineStateStyleProvider(network));
    }
}

