/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld;

import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.sld.AbstractSingleLineDiagramCommand;
import com.powsybl.sld.SingleLineDiagram;
import com.powsybl.sld.layout.HorizontalSubstationLayoutFactory;
import com.powsybl.sld.layout.LayoutParameters;
import com.powsybl.sld.layout.SmartVoltageLevelLayoutFactory;
import com.powsybl.sld.layout.SubstationLayoutFactory;
import com.powsybl.sld.layout.VoltageLevelLayoutFactory;
import com.powsybl.sld.library.ComponentLibrary;
import com.powsybl.sld.library.ConvergenceComponentLibrary;
import com.powsybl.sld.svg.DefaultDiagramLabelProvider;
import com.powsybl.sld.svg.styles.iidm.TopologicalStyleProvider;
import com.powsybl.tools.Command;
import com.powsybl.tools.Tool;
import com.powsybl.tools.ToolOptions;
import com.powsybl.tools.ToolRunningContext;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@AutoService(value=Tool.class)
public class SingleLineDiagramTool
implements Tool {
    private static final String IDS = "ids";
    private static final String ALL_VOLTAGE_LEVELS = "all-voltage-levels";
    private static final String ALL_SUBSTATIONS = "all-substations";

    public Command getCommand() {
        return new AbstractSingleLineDiagramCommand(){

            public String getName() {
                return "generate-substation-diagram";
            }

            public String getDescription() {
                return "generate substation diagram";
            }

            public Options getOptions() {
                Options options = new Options();
                this.addInputFileOption(options);
                this.addOutputDirectoryOption(options);
                options.addOption(Option.builder().longOpt(SingleLineDiagramTool.IDS).desc("voltage level/substation id list").hasArg().argName("ID_LIST").build());
                options.addOption(Option.builder().longOpt(SingleLineDiagramTool.ALL_VOLTAGE_LEVELS).desc("all voltage levels").build());
                options.addOption(Option.builder().longOpt(SingleLineDiagramTool.ALL_SUBSTATIONS).desc("all substations").build());
                return options;
            }

            public String getUsageFooter() {
                return null;
            }
        };
    }

    private Path getSvgFile(Path outputDir, String id) {
        try {
            return outputDir.resolve(URLEncoder.encode(id, StandardCharsets.UTF_8.name()) + ".svg");
        }
        catch (UnsupportedEncodingException e) {
            throw new PowsyblException((Throwable)e);
        }
    }

    private void generateSvg(ToolRunningContext context, Path outputDir, SvgGenerationConfig generationConfig, String vlOrSubstationId, Network network) {
        Path svgFile = this.getSvgFile(outputDir, vlOrSubstationId);
        context.getOutputStream().println("Generating '" + svgFile + "'");
        try {
            SingleLineDiagram.draw(network, vlOrSubstationId, svgFile, generationConfig.layoutParameters, generationConfig.componentLibrary, generationConfig.substationLayoutFactory, generationConfig.voltageLevelLayoutFactory, new DefaultDiagramLabelProvider(network, generationConfig.componentLibrary, generationConfig.layoutParameters), new TopologicalStyleProvider(network), "");
        }
        catch (Exception e) {
            e.printStackTrace(context.getErrorStream());
        }
    }

    private void generateSome(ToolRunningContext context, Path outputDir, List<String> ids, Network network, SvgGenerationConfig generationConfig) {
        for (String id : ids) {
            this.generateSvg(context, outputDir, generationConfig, id, network);
        }
    }

    private void generateAll(ToolRunningContext context, boolean allVoltageLevels, boolean allSubstations, Path outputDir, Network network, SvgGenerationConfig generationConfig) {
        if (allVoltageLevels || !allSubstations) {
            for (VoltageLevel vl : network.getVoltageLevels()) {
                this.generateSvg(context, outputDir, generationConfig, vl.getId(), network);
            }
        }
        if (allSubstations) {
            for (Substation s : network.getSubstations()) {
                this.generateSvg(context, outputDir, generationConfig, s.getId(), network);
            }
        }
    }

    public void run(CommandLine line, ToolRunningContext context) {
        ToolOptions toolOptions = new ToolOptions(line, context);
        Path inputFile = (Path)toolOptions.getPath("input-file").orElseThrow(() -> new PowsyblException("input-file option is missing"));
        Path outputDir = (Path)toolOptions.getPath("output-dir").orElseThrow(() -> new PowsyblException("output-dir option is missing"));
        List<String> ids = toolOptions.getValues(IDS).orElse(Collections.emptyList());
        context.getOutputStream().println("Loading network '" + inputFile + "'...");
        Network network = Network.read((Path)inputFile);
        if (network == null) {
            throw new PowsyblException("File '" + inputFile + "' is not importable");
        }
        SvgGenerationConfig generationConfig = new SvgGenerationConfig(network);
        if (ids.isEmpty()) {
            boolean allVoltageLevels = toolOptions.hasOption(ALL_VOLTAGE_LEVELS);
            boolean allSubstations = toolOptions.hasOption(ALL_SUBSTATIONS);
            this.generateAll(context, allVoltageLevels, allSubstations, outputDir, network, generationConfig);
        } else {
            this.generateSome(context, outputDir, ids, network, generationConfig);
        }
    }

    static class SvgGenerationConfig {
        ComponentLibrary componentLibrary = new ConvergenceComponentLibrary();
        LayoutParameters layoutParameters = new LayoutParameters();
        VoltageLevelLayoutFactory voltageLevelLayoutFactory;
        SubstationLayoutFactory substationLayoutFactory = new HorizontalSubstationLayoutFactory();

        SvgGenerationConfig(Network network) {
            this.voltageLevelLayoutFactory = new SmartVoltageLevelLayoutFactory(network);
        }
    }
}

