/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.builders;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.util.ServiceLoaderCache;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DefaultTopologyVisitor;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorLinearModel;
import com.powsybl.iidm.network.ShuntCompensatorNonLinearModel;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyVisitor;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.BusbarSectionPosition;
import com.powsybl.iidm.network.extensions.ConnectablePosition;
import com.powsybl.sld.builders.GraphBuilder;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.graphs.BaseGraph;
import com.powsybl.sld.model.graphs.Graph;
import com.powsybl.sld.model.graphs.NodeFactory;
import com.powsybl.sld.model.graphs.SubstationGraph;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.graphs.VoltageLevelInfos;
import com.powsybl.sld.model.graphs.ZoneGraph;
import com.powsybl.sld.model.nodes.BusNode;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.Middle3WTNode;
import com.powsybl.sld.model.nodes.Node;
import com.powsybl.sld.model.nodes.NodeSide;
import com.powsybl.sld.model.nodes.SwitchNode;
import com.powsybl.sld.postprocessor.GraphBuildPostProcessor;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkGraphBuilder
implements GraphBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkGraphBuilder.class);
    private static final ServiceLoaderCache<GraphBuildPostProcessor> POST_PROCESSOR_LOADER = new ServiceLoaderCache(GraphBuildPostProcessor.class);
    private final Network network;

    public NetworkGraphBuilder(Network network) {
        this.network = Objects.requireNonNull(network);
    }

    private static boolean isInternalToVoltageLevel(Branch<?> branch) {
        return branch.getTerminal1().getVoltageLevel().getId().equals(branch.getTerminal2().getVoltageLevel().getId());
    }

    private static boolean isNotInternalToVoltageLevel(Branch<?> branch) {
        return !NetworkGraphBuilder.isInternalToVoltageLevel(branch);
    }

    private static boolean isInternalToVoltageLevel(ThreeWindingsTransformer transformer) {
        return transformer.getLeg1().getTerminal().getVoltageLevel().getId().equals(transformer.getLeg2().getTerminal().getVoltageLevel().getId()) && transformer.getLeg2().getTerminal().getVoltageLevel().getId().equals(transformer.getLeg3().getTerminal().getVoltageLevel().getId());
    }

    private static boolean isNotInternalToVoltageLevel(ThreeWindingsTransformer transformer) {
        return !NetworkGraphBuilder.isInternalToVoltageLevel(transformer);
    }

    private static boolean isInternalToSubstation(Branch<?> branch) {
        Optional substation1 = branch.getTerminal1().getVoltageLevel().getSubstation();
        Optional substation2 = branch.getTerminal2().getVoltageLevel().getSubstation();
        return substation1.isPresent() && substation2.isPresent() && substation1.get() == substation2.get();
    }

    private static boolean isNotInternalToSubstation(Branch<?> branch) {
        return !NetworkGraphBuilder.isInternalToSubstation(branch);
    }

    @Override
    public VoltageLevelGraph buildVoltageLevelGraph(String id, Graph parentGraph) {
        VoltageLevel vl = this.network.getVoltageLevel(id);
        if (vl == null) {
            throw new PowsyblException("Voltage level '" + id + "' not found !!");
        }
        VoltageLevelGraph graph = new VoltageLevelGraph(new VoltageLevelInfos(vl.getId(), vl.getNameOrId(), vl.getNominalV()), parentGraph);
        this.buildGraph(graph, vl);
        return graph;
    }

    @Override
    public VoltageLevelGraph buildVoltageLevelGraph(String id) {
        return this.buildVoltageLevelGraph(id, null);
    }

    private void buildGraph(VoltageLevelGraph graph, VoltageLevel vl) {
        LOGGER.info("Building '{}' graph...", (Object)vl.getId());
        switch (vl.getTopologyKind()) {
            case BUS_BREAKER: {
                this.buildBusBreakerGraph(graph, vl);
                break;
            }
            case NODE_BREAKER: {
                this.buildNodeBreakerGraph(graph, vl);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown topology kind: " + vl.getTopologyKind()));
            }
        }
        this.addBranchEdges(graph, vl);
        LOGGER.info("{} nodes, {} edges", (Object)graph.getNodes().size(), (Object)graph.getEdges().size());
        this.handleGraphPostProcessors(graph);
        this.handleConnectedComponents(graph);
    }

    private void addBranchEdges(VoltageLevelGraph graph, VoltageLevel vl) {
        this.addLineEdges(graph, vl.getConnectableStream(Line.class).filter(NetworkGraphBuilder::isInternalToVoltageLevel).collect(Collectors.toList()));
        this.add2wtEdges(graph, vl.getConnectableStream(TwoWindingsTransformer.class).filter(NetworkGraphBuilder::isInternalToVoltageLevel).collect(Collectors.toList()));
        this.add3wtEdges(graph, vl.getConnectableStream(ThreeWindingsTransformer.class).filter(t -> t.getLeg1().getTerminal().getVoltageLevel().getId().equals(t.getLeg2().getTerminal().getVoltageLevel().getId()) && t.getLeg2().getTerminal().getVoltageLevel().getId().equals(t.getLeg3().getTerminal().getVoltageLevel().getId())).collect(Collectors.toList()));
    }

    @Override
    public SubstationGraph buildSubstationGraph(String id, ZoneGraph parentGraph) {
        Substation substation = this.network.getSubstation(id);
        if (substation == null) {
            throw new PowsyblException("Substation '" + id + "' not found !!");
        }
        SubstationGraph graph = SubstationGraph.create(substation.getId(), parentGraph);
        this.buildSubstationGraph(graph, substation);
        return graph;
    }

    @Override
    public SubstationGraph buildSubstationGraph(String id) {
        return this.buildSubstationGraph(id, null);
    }

    private void buildSubstationGraph(SubstationGraph graph, Substation substation) {
        substation.getVoltageLevelStream().sorted(Comparator.comparing(VoltageLevel::getNominalV).reversed()).forEach(v -> {
            VoltageLevelGraph vlGraph = new VoltageLevelGraph(new VoltageLevelInfos(v.getId(), v.getNameOrId(), v.getNominalV()), graph);
            this.buildGraph(vlGraph, (VoltageLevel)v);
            graph.addVoltageLevel(vlGraph);
        });
        this.addSnakeEdges(graph, substation);
        LOGGER.info("Number of voltage levels: {} ", (Object)graph.getVoltageLevels().size());
    }

    private void addSnakeEdges(SubstationGraph graph, Substation substation) {
        this.addLineEdges(graph, substation.getVoltageLevelStream().flatMap(voltageLevel -> voltageLevel.getConnectableStream(Line.class)).filter(NetworkGraphBuilder::isInternalToSubstation).filter(NetworkGraphBuilder::isNotInternalToVoltageLevel).collect(Collectors.toList()));
        this.add2wtEdges(graph, substation.getTwoWindingsTransformerStream().filter(NetworkGraphBuilder::isNotInternalToVoltageLevel).collect(Collectors.toList()));
        this.add3wtEdges(graph, substation.getThreeWindingsTransformerStream().filter(NetworkGraphBuilder::isNotInternalToVoltageLevel).collect(Collectors.toList()));
    }

    static boolean isCapacitor(ShuntCompensator sc) {
        switch (sc.getModelType()) {
            case LINEAR: {
                return ((ShuntCompensatorLinearModel)sc.getModel()).getBPerSection() >= 0.0;
            }
            case NON_LINEAR: {
                ShuntCompensatorNonLinearModel model = (ShuntCompensatorNonLinearModel)sc.getModel();
                double averageB = model.getAllSections().stream().mapToDouble(ShuntCompensatorNonLinearModel.Section::getB).average().orElse(0.0);
                return averageB >= 0.0;
            }
        }
        throw new IllegalStateException("Unknown shunt compensator model type: " + sc.getModelType());
    }

    protected BusBreakerGraphBuilder createBusBreakerGraphBuilder(VoltageLevelGraph graph, Map<String, Node> nodesByBusId) {
        return new BusBreakerGraphBuilder(graph, nodesByBusId);
    }

    private void buildBusBreakerGraph(VoltageLevelGraph graph, VoltageLevel vl) {
        HashMap<String, Node> nodesByBusId = new HashMap<String, Node>();
        int v = 1;
        for (Bus b : vl.getBusBreakerView().getBuses()) {
            BusNode busNode = NodeFactory.createBusNode(graph, b.getId(), b.getNameOrId());
            nodesByBusId.put(b.getId(), busNode);
            busNode.setBusBarIndexSectionIndex(v++, 1);
        }
        vl.visitEquipments((TopologyVisitor)this.createBusBreakerGraphBuilder(graph, nodesByBusId));
        for (Switch sw : vl.getBusBreakerView().getSwitches()) {
            SwitchNode n = this.createSwitchNodeFromSwitch(graph, sw);
            Bus bus1 = vl.getBusBreakerView().getBus1(sw.getId());
            Bus bus2 = vl.getBusBreakerView().getBus2(sw.getId());
            graph.addEdge((Node)nodesByBusId.get(bus1.getId()), n);
            graph.addEdge(n, (Node)nodesByBusId.get(bus2.getId()));
        }
    }

    protected NodeBreakerGraphBuilder createNodeBreakerGraphBuilder(VoltageLevelGraph graph, Map<Integer, Node> nodesByNumber) {
        return new NodeBreakerGraphBuilder(graph, nodesByNumber);
    }

    private void buildNodeBreakerGraph(VoltageLevelGraph graph, VoltageLevel vl) {
        HashMap<Integer, Node> nodesByNumber = new HashMap<Integer, Node>();
        vl.visitEquipments((TopologyVisitor)this.createNodeBreakerGraphBuilder(graph, nodesByNumber));
        for (Switch sw : vl.getNodeBreakerView().getSwitches()) {
            SwitchNode n = this.createSwitchNodeFromSwitch(graph, sw);
            int node1 = vl.getNodeBreakerView().getNode1(sw.getId());
            int node2 = vl.getNodeBreakerView().getNode2(sw.getId());
            this.ensureNodeExists(graph, node1, nodesByNumber);
            this.ensureNodeExists(graph, node2, nodesByNumber);
            graph.addEdge((Node)nodesByNumber.get(node1), n);
            graph.addEdge(n, (Node)nodesByNumber.get(node2));
        }
        vl.getNodeBreakerView().getInternalConnectionStream().forEach(internalConnection -> {
            int node1 = internalConnection.getNode1();
            int node2 = internalConnection.getNode2();
            this.ensureNodeExists(graph, node1, nodesByNumber);
            this.ensureNodeExists(graph, node2, nodesByNumber);
            graph.addEdge((Node)nodesByNumber.get(node1), (Node)nodesByNumber.get(node2));
        });
    }

    private void ensureNodeExists(VoltageLevelGraph graph, int n, Map<Integer, Node> nodesByNumber) {
        nodesByNumber.computeIfAbsent(n, k -> NodeFactory.createConnectivityNode(graph, String.valueOf(k)));
    }

    private void handleConnectedComponents(VoltageLevelGraph graph) {
        List connectedSets = new ConnectivityInspector(graph.toJgrapht()).connectedSets();
        if (connectedSets.size() != 1) {
            LOGGER.warn("{} connected components found", (Object)connectedSets.size());
            connectedSets.stream().sorted(Comparator.comparingInt(Set::size)).map(setNodes -> setNodes.stream().map(Node::getId).collect(Collectors.toSet())).forEach(strings -> LOGGER.warn("   - {}", strings));
        }
        connectedSets.forEach(s -> this.ensureOneBusInConnectedComponent(graph, (Set<Node>)s));
    }

    private void ensureOneBusInConnectedComponent(VoltageLevelGraph graph, Set<Node> nodes) {
        if (nodes.stream().anyMatch(node -> node.getType() == Node.NodeType.BUS)) {
            return;
        }
        Node biggestFn = nodes.stream().filter(node -> node.getType() == Node.NodeType.INTERNAL).sorted(Comparator.comparingInt(node -> node.getAdjacentEdges().size()).reversed().thenComparing(Node::getId)).findFirst().orElseThrow(() -> new PowsyblException("Empty node set"));
        graph.substituteNode(biggestFn, NodeFactory.createFictitiousBusNode(graph, biggestFn.getId() + "FictitiousBus"));
    }

    private void handleGraphPostProcessors(VoltageLevelGraph graph) {
        List listPostProcessors = POST_PROCESSOR_LOADER.getServices();
        for (GraphBuildPostProcessor gbp : listPostProcessors) {
            LOGGER.info("Graph post-processor id '{}' : Adding custom node in graph '{}'", (Object)gbp.getId(), (Object)graph.getVoltageLevelInfos().getId());
            gbp.addNode(graph, this.network);
        }
    }

    private void addLineEdges(Graph graph, List<Line> lines) {
        HashSet linesIds = new HashSet();
        lines.forEach(line -> {
            if (!linesIds.contains(line.getId())) {
                Terminal t1 = line.getTerminal1();
                Terminal t2 = line.getTerminal2();
                VoltageLevel vl1 = t1.getVoltageLevel();
                VoltageLevel vl2 = t2.getVoltageLevel();
                VoltageLevelGraph g1 = graph.getVoltageLevel(vl1.getId());
                VoltageLevelGraph g2 = graph.getVoltageLevel(vl2.getId());
                Node n1 = g1.getNode(line.getId() + "_" + line.getSide(t1).name());
                Node n2 = g2.getNode(line.getId() + "_" + line.getSide(t2).name());
                graph.addLineEdge(line.getId(), n1, n2);
                linesIds.add(line.getId());
            }
        });
    }

    private void add2wtEdges(VoltageLevelGraph graph, List<TwoWindingsTransformer> twoWindingsTransformers) {
        for (TwoWindingsTransformer transfo : twoWindingsTransformers) {
            Node n1 = graph.getNode(transfo.getId() + "_" + Branch.Side.ONE);
            Node n2 = graph.getNode(transfo.getId() + "_" + Branch.Side.TWO);
            NodeFactory.createInternal2WTNode(graph, transfo.getId(), transfo.getNameOrId(), n1, n2, transfo.hasPhaseTapChanger());
        }
    }

    private void add2wtEdges(SubstationGraph graph, List<TwoWindingsTransformer> twoWindingsTransformers) {
        for (TwoWindingsTransformer transfo : twoWindingsTransformers) {
            Terminal t1 = transfo.getTerminal1();
            Terminal t2 = transfo.getTerminal2();
            String id1 = transfo.getId() + "_" + transfo.getSide(t1).name();
            String id2 = transfo.getId() + "_" + transfo.getSide(t2).name();
            VoltageLevel vl1 = t1.getVoltageLevel();
            VoltageLevel vl2 = t2.getVoltageLevel();
            VoltageLevelGraph g1 = graph.getVoltageLevel(vl1.getId());
            VoltageLevelGraph g2 = graph.getVoltageLevel(vl2.getId());
            Node n1 = g1.getNode(id1);
            Node n2 = g2.getNode(id2);
            VoltageLevelInfos voltageLevelInfos1 = new VoltageLevelInfos(vl1.getId(), vl1.getNameOrId(), vl1.getNominalV());
            VoltageLevelInfos voltageLevelInfos2 = new VoltageLevelInfos(vl2.getId(), vl2.getNameOrId(), vl2.getNominalV());
            NodeFactory.createMiddle2WTNode(graph, transfo.getId(), transfo.getNameOrId(), (FeederNode)n1, (FeederNode)n2, voltageLevelInfos1, voltageLevelInfos2, transfo.hasPhaseTapChanger());
        }
    }

    private void add3wtEdges(BaseGraph graph, List<ThreeWindingsTransformer> threeWindingsTransformers) {
        threeWindingsTransformers.forEach(transfo -> {
            List feederNodes = transfo.getLegStream().map(leg -> {
                String vlId = leg.getTerminal().getVoltageLevel().getId();
                String idLeg = transfo.getId() + "_" + transfo.getSide(leg.getTerminal()).name();
                return (FeederNode)graph.getVoltageLevel(vlId).getNode(idLeg);
            }).collect(Collectors.toList());
            NodeFactory.createMiddle3WTNode(graph, transfo.getId(), transfo.getNameOrId(), (FeederNode)feederNodes.get(0), (FeederNode)feederNodes.get(1), (FeederNode)feederNodes.get(2));
        });
    }

    private SwitchNode createSwitchNodeFromSwitch(VoltageLevelGraph graph, Switch aSwitch) {
        String componentType;
        Objects.requireNonNull(graph);
        Objects.requireNonNull(aSwitch);
        switch (aSwitch.getKind()) {
            case BREAKER: {
                componentType = "BREAKER";
                break;
            }
            case DISCONNECTOR: {
                componentType = "DISCONNECTOR";
                break;
            }
            case LOAD_BREAK_SWITCH: {
                componentType = "LOAD_BREAK_SWITCH";
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        SwitchNode.SwitchKind sk = SwitchNode.SwitchKind.valueOf(aSwitch.getKind().name());
        return NodeFactory.createSwitchNode(graph, aSwitch.getId(), aSwitch.getNameOrId(), componentType, aSwitch.isFictitious(), sk, aSwitch.isOpen());
    }

    @Override
    public ZoneGraph buildZoneGraph(List<String> substationIds) {
        Objects.requireNonNull(substationIds);
        List<Substation> zone = substationIds.stream().map(substationId -> {
            Substation substation = this.network.getSubstation(substationId);
            if (substation == null) {
                throw new PowsyblException("Substation '" + substationId + "' not in network " + this.network.getId());
            }
            return substation;
        }).collect(Collectors.toList());
        ZoneGraph graph = ZoneGraph.create(substationIds);
        this.buildZoneGraph(graph, zone);
        return graph;
    }

    private void buildZoneGraph(ZoneGraph zoneGraph, List<Substation> zone) {
        if (zone.isEmpty()) {
            LOGGER.warn("No substations in the zone: skipping graph building");
            return;
        }
        NetworkGraphBuilder graphBuilder = new NetworkGraphBuilder(this.network);
        zone.forEach(substation -> {
            LOGGER.info("Adding substation {} to zone graph", (Object)substation.getId());
            SubstationGraph sGraph = graphBuilder.buildSubstationGraph(substation.getId(), zoneGraph);
            zoneGraph.addSubstation(sGraph);
        });
        this.addLineEdges(zoneGraph, zone.stream().flatMap(Substation::getVoltageLevelStream).flatMap(voltageLevel -> voltageLevel.getConnectableStream(Line.class)).filter(NetworkGraphBuilder::isNotInternalToSubstation).collect(Collectors.toList()));
    }

    public static class BusBreakerGraphBuilder
    extends AbstractGraphBuilder {
        private final Map<String, Node> nodesByBusId;
        private int order = 1;

        protected BusBreakerGraphBuilder(VoltageLevelGraph graph, Map<String, Node> nodesByBusId) {
            super(graph);
            this.nodesByBusId = Objects.requireNonNull(nodesByBusId);
        }

        private void connectToBus(Node node, Terminal terminal) {
            String busId = terminal.getBusBreakerView().getConnectableBus().getId();
            this.graph.addEdge(this.nodesByBusId.get(busId), node);
        }

        @Override
        protected void addTerminalNode(Node node, Terminal terminal) {
            node.setOrder(this.order++);
            node.setDirection(this.order % 2 == 0 ? Direction.TOP : Direction.BOTTOM);
            this.connectToBus(node, terminal);
        }

        @Override
        protected void add3wtFeeder(Middle3WTNode middleNode, FeederNode firstOtherLegNode, FeederNode secondOtherLegNode, Terminal terminal) {
            Direction direction = this.order % 2 == 0 ? Direction.TOP : Direction.BOTTOM;
            firstOtherLegNode.setOrder(this.order++);
            firstOtherLegNode.setDirection(direction);
            secondOtherLegNode.setOrder(this.order++);
            secondOtherLegNode.setDirection(direction);
            this.connectToBus(middleNode, terminal);
        }
    }

    public static class NodeBreakerGraphBuilder
    extends AbstractGraphBuilder {
        private final Map<Integer, Node> nodesByNumber;

        protected NodeBreakerGraphBuilder(VoltageLevelGraph graph, Map<Integer, Node> nodesByNumber) {
            super(graph);
            this.nodesByNumber = Objects.requireNonNull(nodesByNumber);
        }

        public ConnectablePosition.Feeder getFeeder(Terminal terminal) {
            Connectable connectable = terminal.getConnectable();
            ConnectablePosition position = (ConnectablePosition)connectable.getExtension(ConnectablePosition.class);
            if (position == null) {
                return null;
            }
            if (connectable instanceof Injection) {
                return position.getFeeder();
            }
            if (connectable instanceof Branch) {
                Branch branch = (Branch)connectable;
                if (branch.getTerminal1() == terminal) {
                    return position.getFeeder1();
                }
                if (branch.getTerminal2() == terminal) {
                    return position.getFeeder2();
                }
                throw new AssertionError();
            }
            if (connectable instanceof ThreeWindingsTransformer) {
                ThreeWindingsTransformer twt = (ThreeWindingsTransformer)connectable;
                if (twt.getLeg1().getTerminal() == terminal) {
                    return position.getFeeder1();
                }
                if (twt.getLeg2().getTerminal() == terminal) {
                    return position.getFeeder2();
                }
                if (twt.getLeg3().getTerminal() == terminal) {
                    return position.getFeeder3();
                }
                throw new AssertionError();
            }
            throw new AssertionError();
        }

        @Override
        protected void addTerminalNode(Node node, Terminal terminal) {
            ConnectablePosition.Feeder feeder = this.getFeeder(terminal);
            if (feeder != null) {
                feeder.getOrder().ifPresent(node::setOrder);
                feeder.getName().ifPresent(node::setLabel);
                Direction dir = Direction.valueOf(feeder.getDirection().toString());
                node.setDirection(dir == Direction.UNDEFINED ? Direction.TOP : dir);
            }
            this.nodesByNumber.put(terminal.getNodeBreakerView().getNode(), node);
        }

        @Override
        protected void add3wtFeeder(Middle3WTNode middleNode, FeederNode firstOtherLegNode, FeederNode secondOtherLegNode, Terminal terminal) {
            ConnectablePosition.Feeder feeder = this.getFeeder(terminal);
            if (feeder != null) {
                middleNode.setDirection(Direction.valueOf(feeder.getDirection().toString()));
                feeder.getOrder().ifPresent(order -> {
                    firstOtherLegNode.setOrder((int)order);
                    secondOtherLegNode.setOrder(order + 1);
                });
                feeder.getName().ifPresent(name -> {
                    firstOtherLegNode.setLabel((String)name);
                    secondOtherLegNode.setLabel((String)name);
                });
            }
            this.nodesByNumber.put(terminal.getNodeBreakerView().getNode(), middleNode);
        }

        public void visitBusbarSection(BusbarSection busbarSection) {
            BusbarSectionPosition extension = (BusbarSectionPosition)busbarSection.getExtension(BusbarSectionPosition.class);
            BusNode node = NodeFactory.createBusNode(this.graph, busbarSection.getId(), busbarSection.getNameOrId());
            if (extension != null) {
                node.setBusBarIndexSectionIndex(extension.getBusbarIndex(), extension.getSectionIndex());
            }
            this.nodesByNumber.put(busbarSection.getTerminal().getNodeBreakerView().getNode(), node);
        }
    }

    private static abstract class AbstractGraphBuilder
    extends DefaultTopologyVisitor {
        protected final VoltageLevelGraph graph;

        protected AbstractGraphBuilder(VoltageLevelGraph graph) {
            this.graph = graph;
        }

        protected abstract void addTerminalNode(Node var1, Terminal var2);

        protected abstract void add3wtFeeder(Middle3WTNode var1, FeederNode var2, FeederNode var3, Terminal var4);

        private FeederNode createFeederLineNode(VoltageLevelGraph graph, Line line, Branch.Side side) {
            String nodeId = line.getId() + "_" + side.name();
            String equipmentNameOrId = line.getNameOrId();
            String equipmentId = line.getId();
            NodeSide s = NodeSide.valueOf(side.name());
            Branch.Side otherSide = side == Branch.Side.ONE ? Branch.Side.TWO : Branch.Side.ONE;
            VoltageLevel vlOtherSide = line.getTerminal(otherSide).getVoltageLevel();
            return NodeFactory.createFeederLineNode(graph, nodeId, equipmentNameOrId, equipmentId, s, new VoltageLevelInfos(vlOtherSide.getId(), vlOtherSide.getNameOrId(), vlOtherSide.getNominalV()));
        }

        private FeederNode createFeederVscNode(VoltageLevelGraph graph, HvdcConverterStation<?> hvdcStation) {
            return hvdcStation.getOtherConverterStation().map(otherStation -> otherStation.getTerminal().getVoltageLevel()).map(otherVl -> new VoltageLevelInfos(otherVl.getId(), otherVl.getNameOrId(), otherVl.getNominalV())).map(otherVlInfo -> NodeFactory.createVscConverterStation(graph, hvdcStation.getId(), hvdcStation.getNameOrId(), hvdcStation.getHvdcLine().getId(), hvdcStation.getHvdcLine().getConverterStation1() == hvdcStation ? NodeSide.ONE : NodeSide.TWO, otherVlInfo)).orElseGet(() -> NodeFactory.createVscConverterStationInjection(graph, hvdcStation.getId(), hvdcStation.getNameOrId()));
        }

        private Node createInternal2wtSideNode(VoltageLevelGraph graph, TwoWindingsTransformer branch, Branch.Side side) {
            return NodeFactory.createConnectivityNode(graph, branch.getId() + "_" + side.name(), "NODE");
        }

        private FeederNode createFeeder2wtNode(VoltageLevelGraph graph, TwoWindingsTransformer branch, Branch.Side side) {
            String id = branch.getId() + "_" + side.name();
            String name = branch.getNameOrId();
            String equipmentId = branch.getId();
            Branch.Side otherSide = side == Branch.Side.ONE ? Branch.Side.TWO : Branch.Side.ONE;
            VoltageLevel vlOtherSide = branch.getTerminal(otherSide).getVoltageLevel();
            VoltageLevelInfos otherSideVoltageLevelInfos = new VoltageLevelInfos(vlOtherSide.getId(), vlOtherSide.getNameOrId(), vlOtherSide.getNominalV());
            if (graph.isForVoltageLevelDiagram() && NetworkGraphBuilder.isNotInternalToVoltageLevel(branch)) {
                if (!branch.hasPhaseTapChanger()) {
                    return NodeFactory.createFeeder2WTNode(graph, id, name, equipmentId, NodeSide.valueOf(side.name()), otherSideVoltageLevelInfos);
                }
                return NodeFactory.createFeeder2WTNodeWithPhaseShifter(graph, id, name, equipmentId, NodeSide.valueOf(side.name()), otherSideVoltageLevelInfos);
            }
            if (!branch.hasPhaseTapChanger()) {
                return NodeFactory.createFeeder2WTLegNode(graph, id, name, equipmentId, NodeSide.valueOf(side.name()));
            }
            return NodeFactory.createFeeder2WTLegNodeWithPhaseShifter(graph, id, name, equipmentId, NodeSide.valueOf(side.name()));
        }

        private void addFeeder3wtNode(VoltageLevelGraph graph, ThreeWindingsTransformer transformer, ThreeWindingsTransformer.Side side) {
            if (graph.isForVoltageLevelDiagram() && NetworkGraphBuilder.isNotInternalToVoltageLevel(transformer)) {
                NodeSide secondOtherLegSide;
                NodeSide firstOtherLegSide;
                NodeSide vlLegSide;
                Map<NodeSide, VoltageLevelInfos> voltageLevelInfosBySide = Map.of(NodeSide.ONE, AbstractGraphBuilder.createVoltageLevelInfos(transformer.getLeg1().getTerminal()), NodeSide.TWO, AbstractGraphBuilder.createVoltageLevelInfos(transformer.getLeg2().getTerminal()), NodeSide.THREE, AbstractGraphBuilder.createVoltageLevelInfos(transformer.getLeg3().getTerminal()));
                switch (side) {
                    case ONE: {
                        vlLegSide = NodeSide.ONE;
                        firstOtherLegSide = NodeSide.TWO;
                        secondOtherLegSide = NodeSide.THREE;
                        break;
                    }
                    case TWO: {
                        vlLegSide = NodeSide.TWO;
                        firstOtherLegSide = NodeSide.ONE;
                        secondOtherLegSide = NodeSide.THREE;
                        break;
                    }
                    case THREE: {
                        vlLegSide = NodeSide.THREE;
                        firstOtherLegSide = NodeSide.ONE;
                        secondOtherLegSide = NodeSide.TWO;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                String firstOtherLegNodeId = transformer.getId() + "_" + firstOtherLegSide.name();
                FeederNode firstOtherLegNode = NodeFactory.createFeeder3WTLegNodeForVoltageLevelDiagram(graph, firstOtherLegNodeId, transformer.getNameOrId(), transformer.getId(), firstOtherLegSide, voltageLevelInfosBySide.get((Object)firstOtherLegSide));
                String secondOtherLegNodeId = transformer.getId() + "_" + secondOtherLegSide.name();
                FeederNode secondOtherLegNode = NodeFactory.createFeeder3WTLegNodeForVoltageLevelDiagram(graph, secondOtherLegNodeId, transformer.getNameOrId(), transformer.getId(), secondOtherLegSide, voltageLevelInfosBySide.get((Object)secondOtherLegSide));
                Middle3WTNode middleNode = NodeFactory.createMiddle3WTNode(graph, transformer.getId(), transformer.getNameOrId(), vlLegSide, firstOtherLegNode, secondOtherLegNode, voltageLevelInfosBySide.get((Object)NodeSide.ONE), voltageLevelInfosBySide.get((Object)NodeSide.TWO), voltageLevelInfosBySide.get((Object)NodeSide.THREE));
                this.add3wtFeeder(middleNode, firstOtherLegNode, secondOtherLegNode, transformer.getTerminal(side));
            } else {
                String id = transformer.getId() + "_" + side.name();
                FeederNode legNode = NodeFactory.createFeeder3WTLegNodeForSubstationDiagram(graph, id, transformer.getNameOrId(), transformer.getId(), NodeSide.valueOf(side.name()));
                this.addTerminalNode(legNode, transformer.getTerminal(side));
            }
        }

        public void visitLoad(Load load) {
            this.addTerminalNode(NodeFactory.createLoad(this.graph, load.getId(), load.getNameOrId()), load.getTerminal());
        }

        public void visitGenerator(Generator generator) {
            this.addTerminalNode(NodeFactory.createGenerator(this.graph, generator.getId(), generator.getNameOrId()), generator.getTerminal());
        }

        public void visitBattery(Battery battery) {
            this.addTerminalNode(NodeFactory.createBattery(this.graph, battery.getId(), battery.getNameOrId()), battery.getTerminal());
        }

        public void visitShuntCompensator(ShuntCompensator sc) {
            FeederNode feederNode = NetworkGraphBuilder.isCapacitor(sc) ? NodeFactory.createCapacitor(this.graph, sc.getId(), sc.getNameOrId()) : NodeFactory.createInductor(this.graph, sc.getId(), sc.getNameOrId());
            this.addTerminalNode(feederNode, sc.getTerminal());
        }

        public void visitDanglingLine(DanglingLine dl) {
            this.addTerminalNode(NodeFactory.createDanglingLine(this.graph, dl.getId(), dl.getNameOrId()), dl.getTerminal());
        }

        public void visitHvdcConverterStation(HvdcConverterStation<?> converterStation) {
            this.addTerminalNode(this.createFeederVscNode(this.graph, converterStation), converterStation.getTerminal());
        }

        public void visitStaticVarCompensator(StaticVarCompensator svc) {
            this.addTerminalNode(NodeFactory.createStaticVarCompensator(this.graph, svc.getId(), svc.getNameOrId()), svc.getTerminal());
        }

        public void visitTwoWindingsTransformer(TwoWindingsTransformer transformer, Branch.Side side) {
            Node transformerNode = NetworkGraphBuilder.isInternalToVoltageLevel(transformer) ? this.createInternal2wtSideNode(this.graph, transformer, side) : this.createFeeder2wtNode(this.graph, transformer, side);
            this.addTerminalNode(transformerNode, transformer.getTerminal(side));
        }

        public void visitLine(Line line, Branch.Side side) {
            this.addTerminalNode(this.createFeederLineNode(this.graph, line, side), line.getTerminal(side));
        }

        private static VoltageLevelInfos createVoltageLevelInfos(Terminal terminal) {
            VoltageLevel vl = terminal.getVoltageLevel();
            return new VoltageLevelInfos(vl.getId(), vl.getNameOrId(), vl.getNominalV());
        }

        public void visitThreeWindingsTransformer(ThreeWindingsTransformer transformer, ThreeWindingsTransformer.Side side) {
            this.addFeeder3wtNode(this.graph, transformer, side);
        }
    }
}

