/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.builders;

import com.powsybl.sld.builders.GraphBuilder;
import com.powsybl.sld.builders.SubstationRawBuilder;
import com.powsybl.sld.builders.VoltageLevelRawBuilder;
import com.powsybl.sld.model.graphs.Graph;
import com.powsybl.sld.model.graphs.SubstationGraph;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.graphs.VoltageLevelInfos;
import com.powsybl.sld.model.graphs.ZoneGraph;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class RawGraphBuilder
implements GraphBuilder {
    private final Map<String, VoltageLevelRawBuilder> vlBuilders = new TreeMap<String, VoltageLevelRawBuilder>();
    private final Map<String, SubstationRawBuilder> ssBuilders = new TreeMap<String, SubstationRawBuilder>();

    public VoltageLevelRawBuilder createVoltageLevelBuilder(VoltageLevelInfos voltageLevelInfos, SubstationRawBuilder parentBuilder) {
        VoltageLevelRawBuilder vlBuilder = new VoltageLevelRawBuilder(voltageLevelInfos, parentBuilder, this::getVoltageLevelInfosFromId);
        if (parentBuilder != null) {
            parentBuilder.addVlBuilder(vlBuilder);
        }
        this.vlBuilders.put(voltageLevelInfos.getId(), vlBuilder);
        return vlBuilder;
    }

    public VoltageLevelRawBuilder createVoltageLevelBuilder(String vlId, double vlNominalV, SubstationRawBuilder parentBuilder) {
        return this.createVoltageLevelBuilder(new VoltageLevelInfos(vlId, vlId, vlNominalV), parentBuilder);
    }

    public VoltageLevelRawBuilder createVoltageLevelBuilder(String vlId, double vlNominalV) {
        return this.createVoltageLevelBuilder(new VoltageLevelInfos(vlId, vlId, vlNominalV), null);
    }

    public VoltageLevelInfos getVoltageLevelInfosFromId(String id) {
        if (this.vlBuilders.containsKey(id)) {
            return this.vlBuilders.get(id).getVoltageLevelInfos();
        }
        return new VoltageLevelInfos("OTHER", "OTHER", 0.0);
    }

    public SubstationRawBuilder createSubstationBuilder(String id) {
        SubstationRawBuilder ssb = new SubstationRawBuilder(id);
        this.ssBuilders.put(id, ssb);
        return ssb;
    }

    @Override
    public VoltageLevelGraph buildVoltageLevelGraph(String id, Graph parentGraph) {
        return this.vlBuilders.get(id).getGraph();
    }

    @Override
    public VoltageLevelGraph buildVoltageLevelGraph(String id) {
        return this.buildVoltageLevelGraph(id, null);
    }

    @Override
    public SubstationGraph buildSubstationGraph(String id, ZoneGraph zoneGraph) {
        SubstationRawBuilder sGraphBuilder = this.ssBuilders.get(id);
        SubstationGraph ssGraph = sGraphBuilder.getGraph();
        sGraphBuilder.voltageLevelBuilders.stream().map(VoltageLevelRawBuilder::getGraph).sorted(Comparator.comparingDouble(vlGraph -> -vlGraph.getVoltageLevelInfos().getNominalVoltage())).forEach(ssGraph::addVoltageLevel);
        return ssGraph;
    }

    @Override
    public SubstationGraph buildSubstationGraph(String id) {
        return this.buildSubstationGraph(id, null);
    }

    @Override
    public ZoneGraph buildZoneGraph(List<String> substationIds) {
        return null;
    }
}

