/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.builders;

import com.powsybl.sld.builders.VoltageLevelRawBuilder;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.graphs.NodeFactory;
import com.powsybl.sld.model.graphs.SubstationGraph;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.NodeSide;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubstationRawBuilder {
    SubstationGraph substationGraph;
    List<VoltageLevelRawBuilder> voltageLevelBuilders = new ArrayList<VoltageLevelRawBuilder>();

    public SubstationRawBuilder(String id) {
        this.substationGraph = SubstationGraph.create(id);
    }

    public SubstationGraph getGraph() {
        return this.substationGraph;
    }

    public void addVlBuilder(VoltageLevelRawBuilder vlBuilder) {
        this.voltageLevelBuilders.add(vlBuilder);
        vlBuilder.setSubstationBuilder(this);
    }

    public Map<VoltageLevelRawBuilder, FeederNode> createLine(String id, VoltageLevelRawBuilder vl1, VoltageLevelRawBuilder vl2, int order1, int order2, Direction direction1, Direction direction2) {
        HashMap<VoltageLevelRawBuilder, FeederNode> feederLineNodes = new HashMap<VoltageLevelRawBuilder, FeederNode>();
        FeederNode feederLineNode1 = vl1.createFeederLineNode(id, vl2.getVoltageLevelInfos().getId(), NodeSide.ONE, order1, direction1);
        FeederNode feederLineNode2 = vl2.createFeederLineNode(id, vl1.getVoltageLevelInfos().getId(), NodeSide.TWO, order2, direction2);
        feederLineNodes.put(vl1, feederLineNode1);
        feederLineNodes.put(vl2, feederLineNode2);
        this.substationGraph.addLineEdge(id, feederLineNode1, feederLineNode2);
        return feederLineNodes;
    }

    public Map<VoltageLevelRawBuilder, FeederNode> createLine(String id, VoltageLevelRawBuilder vl1, VoltageLevelRawBuilder vl2) {
        return this.createLine(id, vl1, vl2, 0, 0, null, null);
    }

    public Map<VoltageLevelRawBuilder, FeederNode> createFeeder2WT(String id, VoltageLevelRawBuilder vl1, VoltageLevelRawBuilder vl2, int order1, int order2, Direction direction1, Direction direction2) {
        HashMap<VoltageLevelRawBuilder, FeederNode> f2WTNodes = new HashMap<VoltageLevelRawBuilder, FeederNode>();
        FeederNode feeder2WtNode1 = vl1.createFeeder2wtLegNode(id, NodeSide.ONE, order1, direction1);
        FeederNode feeder2WTNode2 = vl2.createFeeder2wtLegNode(id, NodeSide.TWO, order2, direction2);
        f2WTNodes.put(vl1, feeder2WtNode1);
        f2WTNodes.put(vl2, feeder2WTNode2);
        NodeFactory.createMiddle2WTNode(this.substationGraph, id, id, feeder2WtNode1, feeder2WTNode2, vl1.getVoltageLevelInfos(), vl2.getVoltageLevelInfos(), false);
        return f2WTNodes;
    }

    public Map<VoltageLevelRawBuilder, FeederNode> createFeeder2WT(String id, VoltageLevelRawBuilder vl1, VoltageLevelRawBuilder vl2) {
        return this.createFeeder2WT(id, vl1, vl2, 0, 0, null, null);
    }

    public Map<VoltageLevelRawBuilder, FeederNode> createFeeder3WT(String id, VoltageLevelRawBuilder vl1, VoltageLevelRawBuilder vl2, VoltageLevelRawBuilder vl3, int order1, int order2, int order3, Direction direction1, Direction direction2, Direction direction3) {
        HashMap<VoltageLevelRawBuilder, FeederNode> f3WTNodes = new HashMap<VoltageLevelRawBuilder, FeederNode>();
        FeederNode feeder3WTNode1 = vl1.createFeeder3wtLegNode(id, NodeSide.ONE, order1, direction1);
        FeederNode feeder3WTNode2 = vl2.createFeeder3wtLegNode(id, NodeSide.TWO, order2, direction2);
        FeederNode feeder3WTNode3 = vl3.createFeeder3wtLegNode(id, NodeSide.THREE, order3, direction3);
        f3WTNodes.put(vl1, feeder3WTNode1);
        f3WTNodes.put(vl2, feeder3WTNode2);
        f3WTNodes.put(vl3, feeder3WTNode3);
        NodeFactory.createMiddle3WTNode(this.substationGraph, id, id, feeder3WTNode1, feeder3WTNode2, feeder3WTNode3);
        return f3WTNodes;
    }

    public Map<VoltageLevelRawBuilder, FeederNode> createFeeder3WT(String id, VoltageLevelRawBuilder vl1, VoltageLevelRawBuilder vl2, VoltageLevelRawBuilder vl3) {
        return this.createFeeder3WT(id, vl1, vl2, vl3, 0, 0, 0, null, null, null);
    }
}

