/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.builders;

import com.powsybl.sld.builders.SubstationRawBuilder;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.graphs.NodeFactory;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.graphs.VoltageLevelInfos;
import com.powsybl.sld.model.nodes.BusNode;
import com.powsybl.sld.model.nodes.ConnectivityNode;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.Node;
import com.powsybl.sld.model.nodes.NodeSide;
import com.powsybl.sld.model.nodes.SwitchNode;
import java.util.function.Function;

public class VoltageLevelRawBuilder {
    private final VoltageLevelInfos voltageLevelInfos;
    private final VoltageLevelGraph voltageLevelGraph;
    private final Function<String, VoltageLevelInfos> getVoltageLevelInfosFromId;
    private SubstationRawBuilder substationBuilder;

    public VoltageLevelRawBuilder(VoltageLevelInfos voltageLevelInfos, SubstationRawBuilder parentBuilder, Function<String, VoltageLevelInfos> getVoltageLevelInfosFromId) {
        this.voltageLevelInfos = voltageLevelInfos;
        this.voltageLevelGraph = new VoltageLevelGraph(voltageLevelInfos, parentBuilder == null ? null : parentBuilder.getGraph());
        this.getVoltageLevelInfosFromId = getVoltageLevelInfosFromId;
    }

    public VoltageLevelGraph getGraph() {
        return this.voltageLevelGraph;
    }

    public SubstationRawBuilder getSubstationBuilder() {
        return this.substationBuilder;
    }

    public void setSubstationBuilder(SubstationRawBuilder substationBuilder) {
        this.substationBuilder = substationBuilder;
    }

    public BusNode createBusBarSection(String id, int busbarIndex, int sectionIndex) {
        BusNode busNode = NodeFactory.createBusNode(this.voltageLevelGraph, id, id);
        busNode.setBusBarIndexSectionIndex(busbarIndex, sectionIndex);
        return busNode;
    }

    public BusNode createBusBarSection(String id) {
        return NodeFactory.createBusNode(this.voltageLevelGraph, id, id);
    }

    public SwitchNode createSwitchNode(SwitchNode.SwitchKind sk, String id, boolean fictitious, boolean open) {
        return NodeFactory.createSwitchNode(this.voltageLevelGraph, id, id, sk.name(), fictitious, sk, open);
    }

    public SwitchNode createSwitchNode(SwitchNode.SwitchKind sk, String id, boolean fictitious, boolean open, Integer order, Direction direction) {
        SwitchNode sw = NodeFactory.createSwitchNode(this.voltageLevelGraph, id, id, sk.name(), fictitious, sk, open);
        if (direction != null || order != null) {
            this.addExtension(sw, order, direction);
        }
        return sw;
    }

    public void connectNode(Node node1, Node node2) {
        this.voltageLevelGraph.addEdge(node1, node2);
    }

    public ConnectivityNode createConnectivityNode(String id) {
        return NodeFactory.createConnectivityNode(this.voltageLevelGraph, id);
    }

    public void addExtension(Node fn, Integer order, Direction direction) {
        if (order != null) {
            fn.setOrder(order);
        }
        fn.setDirection(direction == null ? Direction.UNDEFINED : direction);
    }

    private void commonFeederSetting(FeederNode node, String id, int order, Direction direction) {
        node.setLabel(id);
        if (direction != null) {
            this.addExtension(node, order, direction);
        }
    }

    public FeederNode createLoad(String id) {
        return this.createLoad(id, 0, null);
    }

    public FeederNode createLoad(String id, int order, Direction direction) {
        FeederNode fn = NodeFactory.createLoad(this.voltageLevelGraph, id, id);
        this.commonFeederSetting(fn, id, order, direction);
        return fn;
    }

    public FeederNode createGenerator(String id) {
        return this.createGenerator(id, 0, null);
    }

    public FeederNode createGenerator(String id, int order, Direction direction) {
        FeederNode fn = NodeFactory.createGenerator(this.voltageLevelGraph, id, id);
        this.commonFeederSetting(fn, id, order, direction);
        return fn;
    }

    public FeederNode createBattery(String id) {
        return this.createBattery(id, 0, null);
    }

    public FeederNode createBattery(String id, int order, Direction direction) {
        FeederNode fn = NodeFactory.createBattery(this.voltageLevelGraph, id, id);
        this.commonFeederSetting(fn, id, order, direction);
        return fn;
    }

    public FeederNode createFeederLineNode(String id, String otherVlId, NodeSide side, int order, Direction direction) {
        FeederNode fln = NodeFactory.createFeederLineNode(this.voltageLevelGraph, id + "_" + side, id, id, side, this.getVoltageLevelInfosFromId.apply(otherVlId));
        this.commonFeederSetting(fln, id, order, direction);
        return fln;
    }

    public FeederNode createFeeder2WTNode(String id, String otherVlId, NodeSide side, int order, Direction direction) {
        FeederNode f2WTe = NodeFactory.createFeeder2WTNode(this.voltageLevelGraph, id + "_" + side, id, id, side, this.getVoltageLevelInfosFromId.apply(otherVlId));
        this.commonFeederSetting(f2WTe, id, order, direction);
        return f2WTe;
    }

    public FeederNode createFeeder2wtLegNode(String id, NodeSide side, int order, Direction direction) {
        FeederNode f2WTe = NodeFactory.createFeeder2WTLegNode(this.voltageLevelGraph, id + "_" + side, id, id, side);
        this.commonFeederSetting(f2WTe, id, order, direction);
        return f2WTe;
    }

    public FeederNode createFeeder3wtLegNode(String id, NodeSide side, int order, Direction direction) {
        FeederNode f3WTe = NodeFactory.createFeeder3WTLegNodeForSubstationDiagram(this.voltageLevelGraph, id + "_" + side, id, id, side);
        this.commonFeederSetting(f3WTe, id + side.getIntValue(), order, direction);
        return f3WTe;
    }

    public VoltageLevelInfos getVoltageLevelInfos() {
        return this.voltageLevelInfos;
    }
}

