/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.commons.PowsyblException;
import com.powsybl.sld.layout.InfosNbSnakeLinesHorizontal;
import com.powsybl.sld.layout.Layout;
import com.powsybl.sld.layout.LayoutParameters;
import com.powsybl.sld.model.cells.Cell;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.coordinate.Orientation;
import com.powsybl.sld.model.coordinate.Point;
import com.powsybl.sld.model.graphs.BaseGraph;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.BranchEdge;
import com.powsybl.sld.model.nodes.Edge;
import com.powsybl.sld.model.nodes.Middle2WTNode;
import com.powsybl.sld.model.nodes.Middle3WTNode;
import com.powsybl.sld.model.nodes.MiddleTwtNode;
import com.powsybl.sld.model.nodes.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.jgrapht.alg.util.Pair;

public abstract class AbstractLayout
implements Layout {
    public abstract BaseGraph getGraph();

    protected abstract void manageSnakeLines(LayoutParameters var1);

    protected void manageSnakeLines(BaseGraph graph, LayoutParameters layoutParameters) {
        for (MiddleTwtNode multiNode : graph.getMultiTermNodes()) {
            List<Edge> adjacentEdges = multiNode.getAdjacentEdges();
            List<Node> adjacentNodes = multiNode.getAdjacentNodes();
            if (multiNode instanceof Middle2WTNode) {
                List<Point> pol = this.calculatePolylineSnakeLine(layoutParameters, adjacentNodes.get(0), adjacentNodes.get(1), true);
                List<List<Point>> pollingSplit = this.splitPolyline2(pol, multiNode);
                ((BranchEdge)adjacentEdges.get(0)).setSnakeLine(pollingSplit.get(0));
                ((BranchEdge)adjacentEdges.get(1)).setSnakeLine(pollingSplit.get(1));
                this.handle2wtNodeOrientation((Middle2WTNode)multiNode, pollingSplit);
                continue;
            }
            if (!(multiNode instanceof Middle3WTNode)) continue;
            List<Point> pol1 = this.calculatePolylineSnakeLine(layoutParameters, adjacentNodes.get(0), adjacentNodes.get(1), true);
            List<Point> pol2 = this.calculatePolylineSnakeLine(layoutParameters, adjacentNodes.get(1), adjacentNodes.get(2), false);
            List<List<Point>> pollingSplit = this.splitPolyline3(pol1, pol2, multiNode);
            for (int i = 0; i < 3; ++i) {
                ((BranchEdge)adjacentEdges.get(i)).setSnakeLine(pollingSplit.get(i));
            }
            this.handle3wtNodeOrientation((Middle3WTNode)multiNode, pollingSplit);
        }
        for (BranchEdge lineEdge : graph.getLineEdges()) {
            List<Node> adjacentNodes = lineEdge.getNodes();
            lineEdge.setSnakeLine(this.calculatePolylineSnakeLine(layoutParameters, adjacentNodes.get(0), adjacentNodes.get(1), true));
        }
    }

    private void handle2wtNodeOrientation(Middle2WTNode node, List<List<Point>> pollingSplit) {
        List<Point> pol1 = pollingSplit.get(0);
        List<Point> pol2 = pollingSplit.get(1);
        Point coord1 = pol1.get(pol1.size() - 2);
        Point coord2 = pol2.get(pol2.size() - 2);
        if (coord1.getX() == coord2.getX()) {
            node.setOrientation(coord2.getY() > coord1.getY() ? Orientation.DOWN : Orientation.UP);
        } else {
            node.setOrientation(coord1.getX() < coord2.getX() ? Orientation.RIGHT : Orientation.LEFT);
        }
    }

    private void handle3wtNodeOrientation(Middle3WTNode node, List<List<Point>> snakeLines) {
        List<Point> snakeLineLeg1 = snakeLines.get(0);
        List<Point> snakeLineLeg2 = snakeLines.get(1);
        List<Point> snakeLineLeg3 = snakeLines.get(2);
        Point leg1 = snakeLineLeg1.get(snakeLineLeg1.size() - 2);
        Point leg2 = snakeLineLeg2.get(snakeLineLeg2.size() - 2);
        Point leg3 = snakeLineLeg3.get(snakeLineLeg3.size() - 2);
        if (leg1.getY() == leg3.getY()) {
            node.setOrientation(leg2.getY() < leg1.getY() ? Orientation.DOWN : Orientation.UP);
            this.setWindingOrder(node, () -> leg1.getX() < leg3.getX(), Arrays.asList(Middle3WTNode.Winding.UPPER_LEFT, Middle3WTNode.Winding.DOWN, Middle3WTNode.Winding.UPPER_RIGHT, Middle3WTNode.Winding.UPPER_RIGHT, Middle3WTNode.Winding.DOWN, Middle3WTNode.Winding.UPPER_LEFT));
        } else if (leg2.getX() == leg1.getX()) {
            node.setOrientation(leg3.getX() > leg1.getX() ? Orientation.LEFT : Orientation.RIGHT);
            this.setWindingOrder(node, () -> leg3.getX() > leg1.getX() == leg1.getY() > leg2.getY(), Arrays.asList(Middle3WTNode.Winding.UPPER_LEFT, Middle3WTNode.Winding.UPPER_RIGHT, Middle3WTNode.Winding.DOWN, Middle3WTNode.Winding.UPPER_RIGHT, Middle3WTNode.Winding.UPPER_LEFT, Middle3WTNode.Winding.DOWN));
        } else if (leg2.getX() == leg3.getX()) {
            node.setOrientation(leg1.getX() > leg3.getX() ? Orientation.LEFT : Orientation.RIGHT);
            this.setWindingOrder(node, () -> leg1.getX() > leg3.getX() == leg2.getY() > leg3.getY(), Arrays.asList(Middle3WTNode.Winding.DOWN, Middle3WTNode.Winding.UPPER_LEFT, Middle3WTNode.Winding.UPPER_RIGHT, Middle3WTNode.Winding.DOWN, Middle3WTNode.Winding.UPPER_RIGHT, Middle3WTNode.Winding.UPPER_LEFT));
        }
    }

    private void setWindingOrder(Middle3WTNode node, BooleanSupplier cond, List<Middle3WTNode.Winding> windings) {
        if (cond.getAsBoolean()) {
            node.setWindingOrder(windings.get(0), windings.get(1), windings.get(2));
        } else {
            node.setWindingOrder(windings.get(3), windings.get(4), windings.get(5));
        }
    }

    protected abstract List<Point> calculatePolylineSnakeLine(LayoutParameters var1, Node var2, Node var3, boolean var4);

    protected Direction getNodeDirection(Node node, int nb) {
        if (node.getType() != Node.NodeType.FEEDER) {
            throw new PowsyblException("Node " + nb + " is not a feeder node");
        }
        Direction dNode = this.getGraph().getCell(node).map(Cell::getDirection).orElse(Direction.TOP);
        if (dNode != Direction.TOP && dNode != Direction.BOTTOM) {
            throw new PowsyblException("Node " + nb + " cell direction not TOP or BOTTOM");
        }
        return dNode;
    }

    protected List<Point> calculatePolylineSnakeLineForHorizontalLayout(LayoutParameters layoutParam, Node node1, Node node2, boolean increment, InfosNbSnakeLinesHorizontal infosNbSnakeLines, double yMin, double yMax) {
        ArrayList<Point> pol = new ArrayList<Point>();
        pol.add(this.getGraph().getShiftedPoint(node1));
        this.addMiddlePoints(layoutParam, (Pair<Node, Node>)new Pair((Object)node1, (Object)node2), infosNbSnakeLines, increment, pol, (Pair<Double, Double>)new Pair((Object)yMin, (Object)yMax));
        pol.add(this.getGraph().getShiftedPoint(node2));
        return pol;
    }

    private void addMiddlePoints(LayoutParameters layoutParam, Pair<Node, Node> nodes, InfosNbSnakeLinesHorizontal infosNbSnakeLines, boolean increment, List<Point> pol, Pair<Double, Double> yMinMax) {
        double y2;
        Node node1 = (Node)nodes.getFirst();
        Node node2 = (Node)nodes.getSecond();
        double yMin = (Double)yMinMax.getFirst();
        double yMax = (Double)yMinMax.getSecond();
        Direction dNode1 = this.getNodeDirection(node1, 1);
        Direction dNode2 = this.getNodeDirection(node2, 2);
        VoltageLevelGraph vlGraph1 = this.getGraph().getVoltageLevelGraph(node1);
        VoltageLevelGraph vlGraph2 = this.getGraph().getVoltageLevelGraph(node2);
        Map<Direction, Integer> nbSnakeLinesTopBottom = infosNbSnakeLines.getNbSnakeLinesTopBottom();
        double x1 = node1.getX() + vlGraph1.getX();
        double x2 = node2.getX() + vlGraph2.getX();
        double y1 = dNode1 == Direction.BOTTOM ? yMax : yMin;
        double d = y2 = dNode2 == Direction.BOTTOM ? yMax : yMin;
        if (dNode1 == dNode2) {
            if (increment) {
                nbSnakeLinesTopBottom.compute(dNode1, (k, v) -> v + 1);
            }
            double decalV = AbstractLayout.getVerticalShift(layoutParam, dNode1, nbSnakeLinesTopBottom);
            double yDecal = y1 + decalV;
            pol.add(new Point(x1, yDecal));
            pol.add(new Point(x2, yDecal));
        } else {
            if (increment) {
                nbSnakeLinesTopBottom.compute(dNode1, (k, v) -> v + 1);
                nbSnakeLinesTopBottom.compute(dNode2, (k, v) -> v + 1);
            }
            VoltageLevelGraph rightestVoltageLevel = vlGraph1.getX() > vlGraph2.getX() ? vlGraph1 : vlGraph2;
            double xMaxGraph = rightestVoltageLevel.getX();
            String idMaxGraph = rightestVoltageLevel.getId();
            LayoutParameters.Padding vlPadding = layoutParam.getVoltageLevelPadding();
            double decal1V = AbstractLayout.getVerticalShift(layoutParam, dNode1, nbSnakeLinesTopBottom);
            double decal2V = AbstractLayout.getVerticalShift(layoutParam, dNode2, nbSnakeLinesTopBottom);
            double xBetweenGraph = xMaxGraph - vlPadding.getLeft() - (double)(infosNbSnakeLines.getNbSnakeLinesVerticalBetween().compute(idMaxGraph, (k, v) -> v + 1) - 1) * layoutParam.getHorizontalSnakeLinePadding();
            pol.addAll(Point.createPointsList(x1, y1 + decal1V, xBetweenGraph, y1 + decal1V, xBetweenGraph, y2 + decal2V, x2, y2 + decal2V));
        }
    }

    private static double getVerticalShift(LayoutParameters layoutParam, Direction dNode1, Map<Direction, Integer> nbSnakeLinesTopBottom) {
        if (dNode1 == Direction.BOTTOM) {
            return (double)Math.max(nbSnakeLinesTopBottom.get((Object)dNode1) - 1, 0) * layoutParam.getVerticalSnakeLinePadding() + layoutParam.getVoltageLevelPadding().getBottom();
        }
        return (double)(-Math.max(nbSnakeLinesTopBottom.get((Object)dNode1) - 1, 0)) * layoutParam.getVerticalSnakeLinePadding() - layoutParam.getVoltageLevelPadding().getTop();
    }

    protected List<List<Point>> splitPolyline2(List<Point> points, Node multiNode) {
        int iMiddle0 = points.size() / 2 - 1;
        int iMiddle1 = points.size() / 2;
        Point pointSplit = points.get(iMiddle0).getMiddlePoint(points.get(iMiddle1));
        multiNode.setCoordinates(pointSplit);
        ArrayList<Point> part1 = new ArrayList<Point>(points.subList(0, iMiddle1));
        part1.add(new Point(pointSplit));
        LinkedList<Point> part2 = new LinkedList<Point>();
        points.stream().skip(iMiddle1).forEach(part2::addFirst);
        part2.add(new Point(pointSplit));
        return Arrays.asList(part1, part2);
    }

    protected List<List<Point>> splitPolyline3(List<Point> points1, List<Point> points2, Node coord) {
        ArrayList<Point> part1 = new ArrayList<Point>(points1.subList(0, points1.size() - 1));
        List<Point> part2 = Arrays.asList(points1.get(points1.size() - 1), new Point(points1.get(points1.size() - 2)));
        LinkedList part3 = new LinkedList();
        points2.stream().skip(1L).forEach(part3::addFirst);
        coord.setCoordinates(points2.get(1));
        return Arrays.asList(part1, part2, part3);
    }

    protected static double getWidthVerticalSnakeLines(String vlGraphId, LayoutParameters layoutParameters, InfosNbSnakeLinesHorizontal infosNbSnakeLines) {
        return (double)Math.max(infosNbSnakeLines.getNbSnakeLinesVerticalBetween().get(vlGraphId) - 1, 0) * layoutParameters.getHorizontalSnakeLinePadding();
    }

    protected static double getHeightSnakeLines(LayoutParameters layoutParameters, Direction top, InfosNbSnakeLinesHorizontal infosNbSnakeLines) {
        return (double)Math.max(infosNbSnakeLines.getNbSnakeLinesTopBottom().get((Object)top) - 1, 0) * layoutParameters.getVerticalSnakeLinePadding();
    }
}

