/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.layout.LBSCluster;
import com.powsybl.sld.layout.LegBusSet;
import com.powsybl.sld.layout.PositionFinder;
import com.powsybl.sld.layout.Subsection;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.BusNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractPositionFinder
implements PositionFinder {
    @Override
    public List<Subsection> buildLayout(VoltageLevelGraph graph, boolean handleShunt) {
        if (graph.getNodes().isEmpty()) {
            return new ArrayList<Subsection>();
        }
        Map<BusNode, Integer> busToNb = this.indexBusPosition(graph.getNodeBuses(), graph.getBusCells());
        List<LegBusSet> legBusSets = LegBusSet.createLegBusSets(graph, busToNb, handleShunt);
        LBSCluster lbsCluster = this.organizeLegBusSets(graph, legBusSets);
        graph.setMaxBusPosition();
        List<Subsection> subsections = Subsection.createSubsections(graph, lbsCluster, handleShunt);
        this.organizeDirections(graph, subsections);
        return subsections;
    }

    @Override
    public void forceSameOrientationForShuntedCell(VoltageLevelGraph graph) {
        graph.getShuntCellStream().forEach(sc -> sc.alignDirections(Side.LEFT));
    }

    @Override
    public void organizeDirections(VoltageLevelGraph graph, List<Subsection> subsections) {
        this.forceSameOrientationForShuntedCell(graph);
    }
}

