/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.commons.PowsyblException;
import com.powsybl.sld.layout.BlockPositionner;
import com.powsybl.sld.layout.CellBlockDecomposer;
import com.powsybl.sld.layout.LayoutParameters;
import com.powsybl.sld.layout.PositionFinder;
import com.powsybl.sld.layout.Subsection;
import com.powsybl.sld.model.blocks.Block;
import com.powsybl.sld.model.blocks.FeederPrimaryBlock;
import com.powsybl.sld.model.blocks.LegPrimaryBlock;
import com.powsybl.sld.model.cells.BusCell;
import com.powsybl.sld.model.cells.Cell;
import com.powsybl.sld.model.cells.ExternCell;
import com.powsybl.sld.model.cells.InternCell;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.Node;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockOrganizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockOrganizer.class);
    private final PositionFinder positionFinder;
    private final boolean stack;
    private final boolean handleShunt;
    private final boolean exceptionIfPatternNotHandled;
    private final Map<String, Side> busInfoMap;

    public BlockOrganizer(PositionFinder positionFinder, boolean stack, boolean exceptionIfPatternNotHandled, boolean handleShunt, Map<String, Side> busInfoMap) {
        this.positionFinder = Objects.requireNonNull(positionFinder);
        this.stack = stack;
        this.exceptionIfPatternNotHandled = exceptionIfPatternNotHandled;
        this.handleShunt = handleShunt;
        this.busInfoMap = busInfoMap;
    }

    public void organize(VoltageLevelGraph graph, LayoutParameters layoutParameters) {
        LOGGER.info("Organizing graph cells into blocks");
        graph.getBusCellStream().forEach(cell -> {
            CellBlockDecomposer.determineComplexCell(graph, cell, this.exceptionIfPatternNotHandled);
            this.checkBlocks((BusCell)cell, layoutParameters);
            if (cell.getType() == Cell.CellType.INTERN) {
                ((InternCell)cell).organizeBlocks();
            }
        });
        graph.getShuntCellStream().forEach(CellBlockDecomposer::determineShuntCellBlocks);
        if (this.stack) {
            this.determineStackableBlocks(graph);
        }
        List<Subsection> subsections = this.positionFinder.buildLayout(graph, this.handleShunt);
        graph.getExternCellStream().forEach(ExternCell::organizeBlockDirections);
        graph.getCellStream().forEach(Cell::blockSizing);
        new BlockPositionner().determineBlockPositions(graph, subsections, this.busInfoMap);
    }

    private void checkBlocks(BusCell cell, LayoutParameters layoutParameters) {
        cell.getLegPrimaryBlocks().forEach(lpb -> this.checkLegPrimaryBlockConsistency((LegPrimaryBlock)lpb, layoutParameters.getComponentsOnBusbars()));
        cell.getFeederPrimaryBlocks().forEach(this::checkFeederPrimaryBlockConsistency);
    }

    private void checkLegPrimaryBlockConsistency(LegPrimaryBlock legPrimaryBlock, List<String> componentsOnBus) {
        boolean consistent;
        List<Node> nodes = legPrimaryBlock.getNodes();
        boolean bl = consistent = nodes.size() == 3 && nodes.get(0).getType() == Node.NodeType.BUS && nodes.get(1).getComponentType().equals("BUS_CONNECTION") || componentsOnBus.contains(nodes.get(1).getComponentType()) && nodes.get(2).getType() == Node.NodeType.INTERNAL;
        if (!consistent) {
            throw new PowsyblException("LegPrimaryBlock not consistent");
        }
    }

    private void checkFeederPrimaryBlockConsistency(FeederPrimaryBlock lpb) {
        boolean consistent;
        List<Node> nodes = lpb.getNodes();
        boolean bl = consistent = nodes.size() == 2 && nodes.get(1).getType() == Node.NodeType.FEEDER && nodes.get(0).getType() == Node.NodeType.INTERNAL;
        if (!consistent) {
            throw new PowsyblException("FeederPrimaryBlock not consistent");
        }
    }

    private void determineStackableBlocks(VoltageLevelGraph graph) {
        LOGGER.info("Determining stackable Blocks");
        graph.getBusCellStream().filter(cell -> !cell.getLegPrimaryBlocks().isEmpty()).forEach(BlockOrganizer::determineStackableBlocks);
    }

    private static void determineStackableBlocks(BusCell cell) {
        List<LegPrimaryBlock> blocks = cell.getLegPrimaryBlocks();
        for (int i = 0; i < blocks.size(); ++i) {
            LegPrimaryBlock block1 = blocks.get(i);
            if (block1.getNodes().size() != 3) continue;
            for (int j = i + 1; j < blocks.size(); ++j) {
                LegPrimaryBlock block2 = blocks.get(j);
                if (block2.getNodes().size() != 3 || !block1.getExtremityNode(Block.Extremity.END).equals(block2.getExtremityNode(Block.Extremity.END)) || block1.getExtremityNode(Block.Extremity.START).equals(block2.getExtremityNode(Block.Extremity.START))) continue;
                block1.addStackableBlock(block2);
                block2.addStackableBlock(block1);
            }
        }
    }
}

