/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.layout.Subsection;
import com.powsybl.sld.model.cells.BusCell;
import com.powsybl.sld.model.cells.InternCell;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.coordinate.Position;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.BusNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class BlockPositionner {
    BlockPositionner() {
    }

    void determineBlockPositions(VoltageLevelGraph graph, List<Subsection> subsections, Map<String, Side> busInfoMap) {
        int hPos = 0;
        int prevHPos = 0;
        int hSpace = 0;
        int maxV = graph.getMaxVerticalBusPosition();
        ArrayList<InternCell> nonFlatCellsToClose = new ArrayList<InternCell>();
        graph.getNodeBuses().forEach(nodeBus -> nodeBus.getPosition().set(Position.Dimension.V, nodeBus.getBusbarIndex() - 1));
        Subsection prevSs = new Subsection(maxV);
        for (Subsection ss : subsections) {
            List<BusNode> busNodesToClose = this.getBusNodesToClose(prevSs, ss);
            List<BusNode> busNodesToOpen = this.getBusNodesToOpen(prevSs, ss);
            if (busNodesToClose.stream().anyMatch(busNode -> busInfoMap.get(busNode.getId()) == Side.RIGHT)) {
                hPos += 2;
            }
            for (BusNode busNode2 : busNodesToClose) {
                this.closeBusNode(busNode2, hPos - hSpace);
            }
            for (BusNode busNode2 : busNodesToOpen) {
                this.openBusNode(busNode2, hPos);
            }
            if (busNodesToOpen.stream().anyMatch(busNode -> busInfoMap.get(busNode.getId()) == Side.LEFT)) {
                hPos += 2;
            }
            hPos = this.placeCrossOverInternCells(hPos, ss.getInternCells(InternCell.Shape.CROSSOVER, Side.RIGHT), Side.RIGHT, nonFlatCellsToClose);
            hPos = this.placeVerticalCells(hPos, BlockPositionner.getVerticalCells(ss));
            if ((hPos = this.placeCrossOverInternCells(hPos, ss.getInternCells(InternCell.Shape.CROSSOVER, Side.LEFT), Side.LEFT, nonFlatCellsToClose)) == prevHPos) {
                hPos += 2;
            }
            hSpace = this.placeFlatInternCells(hPos, ss.getInternCells(InternCell.Shape.FLAT, Side.LEFT)) - hPos;
            prevHPos = hPos += hSpace;
            prevSs = ss;
        }
        List<BusNode> busNodesToClose = this.getBusNodesToClose(prevSs, new Subsection(maxV));
        if (busNodesToClose.stream().anyMatch(busNode -> busInfoMap.get(busNode.getId()) == Side.RIGHT)) {
            hPos += 2;
        }
        for (BusNode busNode3 : busNodesToClose) {
            this.closeBusNode(busNode3, hPos - hSpace);
        }
        this.manageInternCellOverlaps(graph);
    }

    private static List<BusCell> getVerticalCells(Subsection ss) {
        ArrayList<BusCell> verticalCells = new ArrayList<BusCell>();
        verticalCells.addAll(ss.getVerticalInternCells());
        verticalCells.addAll(ss.getExternCells());
        verticalCells.sort(Comparator.comparingInt(bc -> bc.getOrder().orElse(-1)));
        return verticalCells;
    }

    private List<BusNode> getBusNodesToClose(Subsection prevSS, Subsection ss) {
        ArrayList<BusNode> busNodesToClose = new ArrayList<BusNode>();
        for (int v = 0; v < prevSS.getSize(); ++v) {
            BusNode prevBusNode = prevSS.getBusNode(v);
            BusNode actualBusNode = ss.getBusNode(v);
            if (prevBusNode == null || actualBusNode != null && prevBusNode == actualBusNode) continue;
            busNodesToClose.add(prevBusNode);
        }
        return busNodesToClose;
    }

    private List<BusNode> getBusNodesToOpen(Subsection prevSS, Subsection ss) {
        ArrayList<BusNode> busNodesToOpen = new ArrayList<BusNode>();
        for (int v = 0; v < prevSS.getSize(); ++v) {
            BusNode prevBusNode = prevSS.getBusNode(v);
            BusNode actualBusNode = ss.getBusNode(v);
            if (actualBusNode == null || prevBusNode != null && prevBusNode == actualBusNode) continue;
            busNodesToOpen.add(actualBusNode);
        }
        return busNodesToOpen;
    }

    private void closeBusNode(BusNode busNode, int hPositionRight) {
        int positionLeft = Math.max(busNode.getPosition().get(Position.Dimension.H), 0);
        busNode.getPosition().setSpan(Position.Dimension.H, hPositionRight - positionLeft);
    }

    private void openBusNode(BusNode busNode, int hPositionLeft) {
        busNode.getPosition().set(Position.Dimension.H, hPositionLeft);
    }

    private int placeVerticalCells(int hPos, Collection<BusCell> busCells) {
        int hPosRes = hPos;
        for (BusCell cell : busCells) {
            hPosRes = cell.newHPosition(hPosRes);
        }
        return hPosRes;
    }

    private int placeFlatInternCells(int hPos, List<InternCell> cells) {
        int hPosRes = hPos;
        for (BusCell busCell : cells) {
            hPosRes = Math.max(hPosRes, busCell.newHPosition(hPos));
        }
        return hPosRes;
    }

    private int placeCrossOverInternCells(int hPos, List<InternCell> cells, Side side, List<InternCell> nonFlatCellsToClose) {
        int hPosRes = hPos;
        cells.sort(Comparator.comparingInt(c -> -nonFlatCellsToClose.indexOf(c)));
        for (InternCell cell : cells) {
            hPosRes = cell.newHPosition(hPosRes, side);
        }
        if (side == Side.LEFT) {
            nonFlatCellsToClose.addAll(cells);
        } else {
            nonFlatCellsToClose.removeAll(cells);
        }
        return hPosRes;
    }

    private void manageInternCellOverlaps(VoltageLevelGraph graph) {
        List<InternCell> cellsToHandle = graph.getInternCellStream().filter(internCell -> internCell.checkIsNotShape(InternCell.Shape.FLAT, InternCell.Shape.UNDEFINED, InternCell.Shape.UNHANDLED_PATTERN)).collect(Collectors.toList());
        InternCellsLanes lane = new InternCellsLanes(cellsToHandle);
        lane.run();
    }

    private class InternCellsLanes {
        InternCellsLanes nextLane;
        List<InternCellsLanes> lanes;
        List<InternCell> cells;

        InternCellsLanes(List<InternCell> cells) {
            this.cells = new ArrayList<InternCell>(cells);
            this.lanes = new ArrayList<InternCellsLanes>();
            this.lanes.add(this);
        }

        InternCellsLanes(InternCell cell, List<InternCellsLanes> lanes) {
            this.lanes = lanes;
            lanes.add(this);
            this.cells = new ArrayList<InternCell>();
            this.addCell(cell);
        }

        void addCell(InternCell cell) {
            this.cells.add(cell);
        }

        void run() {
            this.bundleToCompatibleLanes();
            this.arrangeLanes();
        }

        private void bundleToCompatibleLanes() {
            Map<InternCell, List<InternCell>> incompatibilities = this.identifyIncompatibilities();
            while (!incompatibilities.isEmpty()) {
                this.shiftIncompatibilities(incompatibilities);
                incompatibilities = this.identifyIncompatibilities();
            }
            if (this.nextLane != null) {
                this.nextLane.bundleToCompatibleLanes();
            }
        }

        private Map<InternCell, List<InternCell>> identifyIncompatibilities() {
            LinkedHashMap<InternCell, List<InternCell>> incompatibilities = new LinkedHashMap<InternCell, List<InternCell>>();
            for (int i = 0; i < this.cells.size(); ++i) {
                InternCell internCellA = this.cells.get(i);
                int hAmin = this.getHfromSide(internCellA, Side.LEFT);
                int hAmax = this.getHfromSide(internCellA, Side.RIGHT);
                for (int j = i + 1; j < this.cells.size(); ++j) {
                    InternCell internCellB = this.cells.get(j);
                    int hBmin = this.getHfromSide(internCellB, Side.LEFT);
                    int hBmax = this.getHfromSide(internCellB, Side.RIGHT);
                    if (hAmin >= hBmax || hBmin >= hAmax) continue;
                    incompatibilities.putIfAbsent(internCellA, new ArrayList());
                    ((List)incompatibilities.get(internCellA)).add(internCellB);
                    incompatibilities.putIfAbsent(internCellB, new ArrayList());
                    ((List)incompatibilities.get(internCellB)).add(internCellA);
                }
            }
            return incompatibilities;
        }

        private int getHfromSide(InternCell cell, Side side) {
            if (cell.checkIsShape(InternCell.Shape.ONE_LEG)) {
                return cell.getSideHPos(Side.UNDEFINED);
            }
            return cell.getSideHPos(side);
        }

        private void shiftIncompatibilities(Map<InternCell, List<InternCell>> incompatibilities) {
            incompatibilities.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).max(Comparator.comparingInt(e -> ((List)e.getValue()).size())).map(Map.Entry::getKey).ifPresent(cell -> {
                this.cells.remove(cell);
                if (this.nextLane == null) {
                    this.nextLane = new InternCellsLanes((InternCell)cell, this.lanes);
                } else {
                    this.nextLane.addCell((InternCell)cell);
                }
            });
        }

        private void arrangeLanes() {
            int i = 0;
            for (InternCellsLanes lane : this.lanes) {
                int j = i % 2;
                int newV = i / 2;
                lane.cells.forEach(c -> {
                    if (c.getDirection() == Direction.UNDEFINED) {
                        c.setDirection(j == 0 ? Direction.TOP : Direction.BOTTOM);
                    }
                    if (!c.checkIsShape(InternCell.Shape.ONE_LEG)) {
                        c.getBodyBlock().getPosition().set(Position.Dimension.V, newV);
                    }
                });
                ++i;
            }
        }

        public String toString() {
            return this.lanes.indexOf(this) + 1 + "/" + this.lanes.size() + " " + this.cells.toString();
        }
    }
}

