/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.layout.LayoutParameters;
import com.powsybl.sld.model.blocks.Block;
import com.powsybl.sld.model.blocks.BlockVisitor;
import com.powsybl.sld.model.blocks.BodyParallelBlock;
import com.powsybl.sld.model.blocks.BodyPrimaryBlock;
import com.powsybl.sld.model.blocks.ComposedBlock;
import com.powsybl.sld.model.blocks.FeederPrimaryBlock;
import com.powsybl.sld.model.blocks.LegParallelBlock;
import com.powsybl.sld.model.blocks.LegPrimaryBlock;
import com.powsybl.sld.model.blocks.SerialBlock;
import com.powsybl.sld.model.blocks.UndefinedBlock;
import com.powsybl.sld.model.nodes.Node;
import java.util.HashSet;
import java.util.Set;
import java.util.function.DoubleBinaryOperator;

public final class CalculateCellHeightBlockVisitor
implements BlockVisitor {
    private double blockHeight;
    private final Set<Node> encounteredNodes;
    private final LayoutParameters layoutParameters;

    private CalculateCellHeightBlockVisitor(LayoutParameters layoutParameters, Set<Node> encounteredNodes) {
        this.layoutParameters = layoutParameters;
        this.encounteredNodes = encounteredNodes;
    }

    public static CalculateCellHeightBlockVisitor create(LayoutParameters layoutParameters, Set<Node> encounteredNodes) {
        return new CalculateCellHeightBlockVisitor(layoutParameters, encounteredNodes);
    }

    public static CalculateCellHeightBlockVisitor create(LayoutParameters layoutParameters) {
        return new CalculateCellHeightBlockVisitor(layoutParameters, new HashSet<Node>());
    }

    public double getBlockHeight() {
        return this.blockHeight;
    }

    @Override
    public void visit(LegPrimaryBlock block) {
        this.blockHeight = 0.0;
    }

    @Override
    public void visit(FeederPrimaryBlock block) {
        this.blockHeight = 0.0;
    }

    @Override
    public void visit(BodyPrimaryBlock block) {
        double componentHeight = this.layoutParameters.getMaxComponentHeight() + this.layoutParameters.getMinSpaceBetweenComponents();
        long nbNodes = block.getNodes().stream().filter(n -> !this.encounteredNodes.contains(n) && n.getType() != Node.NodeType.BUS).count();
        this.blockHeight = (double)(nbNodes - 1L) * componentHeight;
    }

    @Override
    public void visit(SerialBlock block) {
        this.calculateSubHeight(block, Double::sum);
    }

    @Override
    public void visit(LegParallelBlock block) {
        this.calculateSubHeight(block, Math::max);
    }

    @Override
    public void visit(BodyParallelBlock block) {
        this.calculateSubHeight(block, Math::max);
    }

    @Override
    public void visit(UndefinedBlock block) {
        this.calculateSubHeight(block, Math::max);
    }

    private void calculateSubHeight(ComposedBlock block, DoubleBinaryOperator merge) {
        this.blockHeight = 0.0;
        for (Block sub : block.getSubBlocks()) {
            CalculateCellHeightBlockVisitor cch = CalculateCellHeightBlockVisitor.create(this.layoutParameters, this.encounteredNodes);
            sub.accept(cch);
            this.blockHeight = merge.applyAsDouble(this.blockHeight, cch.blockHeight);
        }
    }
}

