/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.layout.LayoutContext;
import com.powsybl.sld.layout.LayoutParameters;
import com.powsybl.sld.model.blocks.BlockVisitor;
import com.powsybl.sld.model.blocks.BodyParallelBlock;
import com.powsybl.sld.model.blocks.BodyPrimaryBlock;
import com.powsybl.sld.model.blocks.ComposedBlock;
import com.powsybl.sld.model.blocks.FeederPrimaryBlock;
import com.powsybl.sld.model.blocks.LegParallelBlock;
import com.powsybl.sld.model.blocks.LegPrimaryBlock;
import com.powsybl.sld.model.blocks.SerialBlock;
import com.powsybl.sld.model.blocks.UndefinedBlock;
import com.powsybl.sld.model.coordinate.Coord;
import com.powsybl.sld.model.coordinate.Orientation;
import com.powsybl.sld.model.coordinate.Position;
import com.powsybl.sld.model.nodes.Node;

public final class CalculateCoordBlockVisitor
implements BlockVisitor {
    private final LayoutParameters layoutParameters;
    private final LayoutContext layoutContext;

    private CalculateCoordBlockVisitor(LayoutParameters layoutParameters, LayoutContext layoutContext) {
        this.layoutParameters = layoutParameters;
        this.layoutContext = layoutContext;
    }

    public static CalculateCoordBlockVisitor create(LayoutParameters layoutParameters, LayoutContext layoutContext) {
        return new CalculateCoordBlockVisitor(layoutParameters, layoutContext);
    }

    @Override
    public void visit(BodyPrimaryBlock block) {
        if (block.getPosition().getOrientation().isVertical()) {
            int sign = block.getOrientation() == Orientation.UP ? 1 : -1;
            double y0 = block.getCoord().get(Coord.Dimension.Y) + (double)sign * block.getCoord().getSpan(Coord.Dimension.Y) / 2.0;
            double yPxStep = block.getPosition().getSpan(Position.Dimension.V) == 0 ? 0.0 : (double)sign * block.getCoord().getSpan(Coord.Dimension.Y) / (double)(block.getNodes().size() - 1);
            int v = 0;
            for (Node node : block.getNodes()) {
                node.setCoordinates(block.getCoord().get(Coord.Dimension.X), y0 - yPxStep * (double)v);
                ++v;
            }
        } else {
            double x0 = block.getCoord().get(Coord.Dimension.X) - block.getCoord().getSpan(Coord.Dimension.X) / 2.0;
            if (this.layoutContext.isInternCell() && !this.layoutContext.isFlat()) {
                x0 += this.layoutParameters.getCellWidth() / 2.0;
            }
            double xPxStep = block.getCoord().getSpan(Coord.Dimension.X) / (double)(block.getNodes().size() - 1);
            int h = 0;
            for (Node node : block.getNodes()) {
                node.setCoordinates(x0 + xPxStep * (double)h, block.getCoord().get(Coord.Dimension.Y));
                ++h;
            }
        }
    }

    @Override
    public void visit(LegPrimaryBlock block) {
        if (block.getPosition().getOrientation().isVertical()) {
            block.getNodeOnBus().setCoordinates(block.getCoord().get(Coord.Dimension.X), block.getBusNode().getY());
            block.getLegNode().setX(block.getCoord().get(Coord.Dimension.X));
            if (this.layoutContext.isInternCell() && this.layoutContext.isUnileg()) {
                block.getLegNode().setY(block.getCoord().get(Coord.Dimension.Y) + (double)(block.getOrientation() == Orientation.UP ? -1 : 1) * this.layoutParameters.getInternCellHeight());
            }
        } else {
            block.getNodeOnBus().setCoordinates(block.getCoord().get(Coord.Dimension.X) + block.getCoord().getSpan(Coord.Dimension.X) / 2.0, block.getBusNode().getY());
            block.getLegNode().setY(block.getBusNode().getY());
        }
    }

    @Override
    public void visit(FeederPrimaryBlock block) {
        if (block.getPosition().getOrientation().isVertical()) {
            double yFeeder = block.getConnectedNode().getY() + (double)block.getOrientation().progressionSign() * this.layoutParameters.getFeederSpan();
            block.getFeederNode().setCoordinates(block.getCoord().get(Coord.Dimension.X), yFeeder);
        }
    }

    @Override
    public void visit(UndefinedBlock block) {
        this.replicateCoordInSubblocks(block, Coord.Dimension.X);
        this.replicateCoordInSubblocks(block, Coord.Dimension.Y);
        block.getSubBlocks().forEach(b -> b.accept(this));
    }

    @Override
    public void visit(BodyParallelBlock block) {
        if (block.getPosition().getOrientation().isVertical()) {
            this.translatePosInCoord(block, Coord.Dimension.Y, Coord.Dimension.X, Position.Dimension.H, 1);
        } else {
            this.translatePosInCoord(block, Coord.Dimension.X, Coord.Dimension.Y, Position.Dimension.V, 1);
        }
    }

    @Override
    public void visit(SerialBlock block) {
        if (block.getPosition().getOrientation().isVertical()) {
            this.translatePosInCoord(block, Coord.Dimension.X, Coord.Dimension.Y, Position.Dimension.V, block.getOrientation().progressionSign());
            block.getChainingNodes().forEach(n -> n.setX(block.getCoord().get(Coord.Dimension.X)));
        } else {
            this.translatePosInCoord(block, Coord.Dimension.Y, Coord.Dimension.X, Position.Dimension.H, block.getOrientation().progressionSign());
            block.getChainingNodes().forEach(n -> n.setY(block.getCoord().get(Coord.Dimension.Y)));
        }
    }

    @Override
    public void visit(LegParallelBlock block) {
        if (block.getPosition().getOrientation().isVertical()) {
            this.translatePosInCoord(block, Coord.Dimension.Y, Coord.Dimension.X, Position.Dimension.H, 1);
        }
    }

    void translatePosInCoord(ComposedBlock block, Coord.Dimension cDimSteady, Coord.Dimension cDimVariable, Position.Dimension pDim, int sign) {
        this.replicateCoordInSubblocks(block, cDimSteady);
        this.distributeCoordInSubblocs(block, pDim, cDimVariable, sign);
        block.getSubBlocks().forEach(sub -> sub.accept(this));
    }

    void replicateCoordInSubblocks(ComposedBlock block, Coord.Dimension dim) {
        block.getCoord().getSegment(dim).replicateMe(block.getSubBlocks().stream().map(b -> b.getCoord().getSegment(dim)));
    }

    void distributeCoordInSubblocs(ComposedBlock block, Position.Dimension pDim, Coord.Dimension cDim, int sign) {
        double init = block.getCoord().get(cDim) - (double)sign * block.getCoord().getSpan(cDim) / 2.0;
        int pSpan = block.getPosition().getSpan(pDim);
        double step = pSpan == 0 ? 0.0 : block.getCoord().getSpan(cDim) / (double)pSpan;
        block.getSubBlocks().forEach(sub -> {
            sub.getCoord().set(cDim, init + (double)sign * step * ((double)sub.getPosition().get(pDim) + (double)sub.getPosition().getSpan(pDim) / 2.0));
            sub.getCoord().setSpan(cDim, (double)sub.getPosition().getSpan(pDim) * step);
        });
    }
}

