/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.layout.CalculateCoordBlockVisitor;
import com.powsybl.sld.layout.LayoutContext;
import com.powsybl.sld.layout.LayoutParameters;
import com.powsybl.sld.model.blocks.Block;
import com.powsybl.sld.model.blocks.BodyPrimaryBlock;
import com.powsybl.sld.model.cells.CellVisitor;
import com.powsybl.sld.model.cells.ExternCell;
import com.powsybl.sld.model.cells.InternCell;
import com.powsybl.sld.model.cells.ShuntCell;
import com.powsybl.sld.model.coordinate.Coord;
import com.powsybl.sld.model.coordinate.Position;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.nodes.Node;

public final class CalculateCoordCellVisitor
implements CellVisitor {
    private final LayoutParameters layoutParameters;
    private final LayoutContext layoutContext;

    CalculateCoordCellVisitor(LayoutParameters layoutParameters, LayoutContext layoutContext) {
        this.layoutParameters = layoutParameters;
        this.layoutContext = layoutContext;
    }

    @Override
    public void visit(InternCell cell) {
        if (cell.getShape().checkIsNotShape(InternCell.Shape.ONE_LEG, InternCell.Shape.UNDEFINED, InternCell.Shape.UNHANDLED_PATTERN)) {
            this.calculateRootCoord(cell.getBodyBlock(), this.layoutContext);
        }
        cell.getLegs().values().forEach(lb -> this.calculateRootCoord((Block)lb, this.layoutContext));
    }

    @Override
    public void visit(ExternCell cell) {
        this.calculateRootCoord(cell.getRootBlock(), this.layoutContext);
    }

    @Override
    public void visit(ShuntCell cell) {
        Position lPos = cell.getSidePosition(Side.LEFT);
        this.coordShuntCase(cell.getRootBlock(), lPos.get(Position.Dimension.H) + lPos.getSpan(Position.Dimension.H), cell.getSidePosition(Side.RIGHT).get(Position.Dimension.H));
    }

    private void calculateRootCoord(Block block, LayoutContext layoutContext) {
        Position position = block.getPosition();
        Coord coord = block.getCoord();
        double spanX = (double)position.getSpan(Position.Dimension.H) / 2.0 * this.layoutParameters.getCellWidth();
        coord.setSpan(Coord.Dimension.X, spanX);
        coord.set(Coord.Dimension.X, this.hToX(this.layoutParameters, position.get(Position.Dimension.H)) + spanX / 2.0);
        double spanY = this.getRootSpanYCoord(position, this.layoutParameters, layoutContext.getMaxInternCellHeight(), layoutContext.isInternCell());
        coord.setSpan(Coord.Dimension.Y, spanY);
        coord.set(Coord.Dimension.Y, this.getRootYCoord(position, this.layoutParameters, spanY, layoutContext));
        CalculateCoordBlockVisitor cc = CalculateCoordBlockVisitor.create(this.layoutParameters, layoutContext);
        block.accept(cc);
    }

    private double hToX(LayoutParameters layoutParameters, int h) {
        return layoutParameters.getCellWidth() * (double)h / 2.0;
    }

    private double getRootSpanYCoord(Position position, LayoutParameters layoutParam, double externCellHeight, boolean isInternCell) {
        double ySpan = isInternCell ? (double)position.getSpan(Position.Dimension.V) / 2.0 * layoutParam.getInternCellHeight() : externCellHeight - layoutParam.getStackHeight() - layoutParam.getFeederSpan();
        return ySpan;
    }

    private double getRootYCoord(Position position, LayoutParameters layoutParam, double spanY, LayoutContext layoutContext) {
        double dyToBus = 0.0;
        dyToBus = layoutContext.isInternCell() && !layoutContext.isFlat() ? spanY / 2.0 + layoutParam.getInternCellHeight() * (double)(1 + position.get(Position.Dimension.V)) / 2.0 : spanY / 2.0 + layoutParam.getStackHeight();
        switch (layoutContext.getDirection()) {
            case BOTTOM: {
                return layoutContext.getLastBusY() + dyToBus;
            }
            case TOP: {
                return layoutContext.getFirstBusY() - dyToBus;
            }
            case MIDDLE: {
                return layoutContext.getFirstBusY() + (double)(position.get(Position.Dimension.V) - 1) * layoutParam.getVerticalSpaceBus();
            }
        }
        return 0.0;
    }

    public void coordShuntCase(BodyPrimaryBlock block, int hLeft, int hRight) {
        double x0 = this.hToX(this.layoutParameters, hLeft);
        double y0 = block.getExtremityNode(Block.Extremity.START).getY();
        double x1 = this.hToX(this.layoutParameters, hRight);
        double y1 = block.getExtremityNode(Block.Extremity.END).getY();
        double y = (y0 + y1) / 2.0;
        block.getNodes().get(1).setCoordinates(x0, y);
        block.getNodes().get(block.getNodes().size() - 2).setCoordinates(x1, y);
        double dx = (x1 - x0) / (double)(block.getNodes().size() - 4);
        for (int i = 2; i < block.getNodes().size() - 2; ++i) {
            Node node = block.getNodes().get(i);
            node.setCoordinates(x0 + ((double)i - 1.5) * dx, y);
        }
    }
}

