/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.commons.PowsyblException;
import com.powsybl.sld.model.blocks.AbstractParallelBlock;
import com.powsybl.sld.model.blocks.Block;
import com.powsybl.sld.model.blocks.BodyParallelBlock;
import com.powsybl.sld.model.blocks.BodyPrimaryBlock;
import com.powsybl.sld.model.blocks.FeederPrimaryBlock;
import com.powsybl.sld.model.blocks.LegParallelBlock;
import com.powsybl.sld.model.blocks.LegPrimaryBlock;
import com.powsybl.sld.model.blocks.SerialBlock;
import com.powsybl.sld.model.blocks.UndefinedBlock;
import com.powsybl.sld.model.cells.BusCell;
import com.powsybl.sld.model.cells.ShuntCell;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.BusNode;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CellBlockDecomposer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CellBlockDecomposer.class);

    private CellBlockDecomposer() {
    }

    static void determineShuntCellBlocks(ShuntCell shuntCell) {
        shuntCell.setRootBlock(BodyPrimaryBlock.createBodyPrimaryBlockForShuntCell(shuntCell.getNodes()));
    }

    static void determineComplexCell(VoltageLevelGraph vlGraph, BusCell busCell, boolean exceptionIfPatternNotHandled) {
        List<Block> blocks = CellBlockDecomposer.createPrimaryBlocks(vlGraph, busCell);
        CellBlockDecomposer.mergeBlocks(vlGraph, busCell, blocks, exceptionIfPatternNotHandled);
    }

    private static List<Block> createPrimaryBlocks(VoltageLevelGraph voltageLevelGraph, BusCell busCell) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        HashMap<Node, Integer> nodeRemainingSlots = new HashMap<Node, Integer>();
        busCell.getNodes().stream().filter(n -> n.getType() != Node.NodeType.BUS && n.getType() != Node.NodeType.FEEDER).forEach(n -> nodeRemainingSlots.put((Node)n, n.getCardinality(voltageLevelGraph)));
        CellBlockDecomposer.elaborateLegPrimaryBlock(busCell, nodeRemainingSlots, blocks);
        CellBlockDecomposer.elaborateFeederPrimaryBlock(busCell, nodeRemainingSlots, blocks);
        CellBlockDecomposer.rElaborateBodyPrimaryBlocks(busCell, ((Block)blocks.get(0)).getEndingNode(), nodeRemainingSlots, blocks);
        return blocks;
    }

    private static void mergeBlocks(VoltageLevelGraph vlGraph, BusCell busCell, List<Block> blocks, boolean exceptionIfPatternNotHandled) {
        List<LegPrimaryBlock> legPrimaryBlocks = blocks.stream().filter(LegPrimaryBlock.class::isInstance).map(LegPrimaryBlock.class::cast).collect(Collectors.toList());
        List<FeederPrimaryBlock> feederPrimaryBlocks = blocks.stream().filter(FeederPrimaryBlock.class::isInstance).map(FeederPrimaryBlock.class::cast).collect(Collectors.toList());
        while (blocks.size() != 1) {
            boolean merged = CellBlockDecomposer.searchParallelMerge(blocks);
            if (merged |= CellBlockDecomposer.searchSerialMerge(vlGraph, blocks)) continue;
            if (exceptionIfPatternNotHandled) {
                throw new PowsyblException("Blocks detection impossible for cell " + busCell);
            }
            LOGGER.error("{} busCell, cannot merge any additional blocks, {} blocks remains", (Object)busCell.getType(), (Object)blocks.size());
            UndefinedBlock undefinedBlock = new UndefinedBlock(new ArrayList<Block>(blocks));
            blocks.clear();
            blocks.add(undefinedBlock);
            break;
        }
        busCell.blocksSetting(blocks.get(0), legPrimaryBlocks, feederPrimaryBlocks);
    }

    private static boolean searchSerialMerge(VoltageLevelGraph vlGraph, List<Block> blocks) {
        boolean identifiedMerge = false;
        for (int i = 0; i < blocks.size() - 1; ++i) {
            ArrayList<Block> blockToRemove = new ArrayList<Block>();
            boolean chainIdentified = false;
            Block b1 = blocks.get(i);
            SerialBlock serialBlock = new SerialBlock(b1);
            for (int j = i + 1; j < blocks.size(); ++j) {
                Block b2 = blocks.get(j);
                if (!serialBlock.addSubBlock(vlGraph, b2)) continue;
                chainIdentified = true;
                blockToRemove.add(b2);
            }
            if (!chainIdentified) continue;
            blockToRemove.add(b1);
            identifiedMerge = true;
            blocks.removeAll(blockToRemove);
            blocks.add(i, serialBlock);
            i = -1;
        }
        return identifiedMerge;
    }

    private static boolean searchParallelMerge(List<Block> blocks) {
        ArrayList blocksBundlesToMerge = new ArrayList();
        int i = 0;
        while (i < blocks.size()) {
            ArrayList<Block> blocksBundle = new ArrayList<Block>();
            for (int j = i + 1; j < blocks.size(); ++j) {
                Node commonNode = CellBlockDecomposer.checkParallelCriteria(blocks.get(i), blocks.get(j));
                if (commonNode == null) continue;
                blocksBundle.add(blocks.get(j));
            }
            if (blocksBundle.isEmpty()) {
                ++i;
                continue;
            }
            blocksBundle.add(0, blocks.get(i));
            blocks.removeAll(blocksBundle);
            blocksBundlesToMerge.add(blocksBundle);
        }
        for (List list : blocksBundlesToMerge) {
            AbstractParallelBlock parallelBlock = list.stream().anyMatch(b -> !(b instanceof LegPrimaryBlock)) ? new BodyParallelBlock(list, false) : new LegParallelBlock(list, true);
            blocks.add(parallelBlock);
        }
        return !blocksBundlesToMerge.isEmpty();
    }

    private static Node checkParallelCriteria(Block block1, Block block2) {
        Node s1 = block1.getExtremityNode(Block.Extremity.START);
        Node e1 = block1.getExtremityNode(Block.Extremity.END);
        Node s2 = block2.getExtremityNode(Block.Extremity.START);
        Node e2 = block2.getExtremityNode(Block.Extremity.END);
        if (s1.checkNodeSimilarity(s2) && e1.checkNodeSimilarity(e2) || s1.checkNodeSimilarity(e2) && e1.checkNodeSimilarity(s2)) {
            if (s1.equals(s2) || s1.equals(e2)) {
                return s1;
            }
            return e1;
        }
        return null;
    }

    private static void addNodeInBlockNodes(Map<Node, Integer> nodeRemainingSlots, List<Node> nodes, Node node, int weight) {
        nodes.add(node);
        nodeRemainingSlots.computeIfPresent(node, (n, remainingSlots) -> remainingSlots - weight);
    }

    private static void elaborateLegPrimaryBlock(BusCell busCell, Map<Node, Integer> nodeRemainingSlots, List<Block> blocks) {
        for (BusNode busNode : busCell.getBusNodes()) {
            for (Node busConnection : busCell.getInternalAdjacentNodes(busNode)) {
                ArrayList<Node> legPrimaryBlockNodes = new ArrayList<Node>();
                CellBlockDecomposer.addNodeInBlockNodes(nodeRemainingSlots, legPrimaryBlockNodes, busNode, 1);
                CellBlockDecomposer.addNodeInBlockNodes(nodeRemainingSlots, legPrimaryBlockNodes, busConnection, 2);
                CellBlockDecomposer.addNodeInBlockNodes(nodeRemainingSlots, legPrimaryBlockNodes, CellBlockDecomposer.getNextNode(busConnection, busNode), 1);
                blocks.add(new LegPrimaryBlock(legPrimaryBlockNodes));
            }
        }
    }

    private static void elaborateFeederPrimaryBlock(BusCell busCell, Map<Node, Integer> nodeRemainingSlots, List<Block> blocks) {
        for (FeederNode feederNode : busCell.getFeederNodes()) {
            for (Node feederConnection : busCell.getInternalAdjacentNodes(feederNode)) {
                ArrayList<Node> feederPrimaryBlockNodes = new ArrayList<Node>();
                CellBlockDecomposer.addNodeInBlockNodes(nodeRemainingSlots, feederPrimaryBlockNodes, feederNode, 1);
                CellBlockDecomposer.addNodeInBlockNodes(nodeRemainingSlots, feederPrimaryBlockNodes, feederConnection, 1);
                blocks.add(new FeederPrimaryBlock(feederPrimaryBlockNodes));
            }
        }
    }

    private static boolean checkRemainingSlots(Map<Node, Integer> nodeRemainingSlots, Node node, int greaterOrEqVal) {
        return nodeRemainingSlots.containsKey(node) && nodeRemainingSlots.get(node) >= greaterOrEqVal;
    }

    private static void rElaborateBodyPrimaryBlocks(BusCell busCell, Node entryNode, Map<Node, Integer> nodeRemainingSlots, List<Block> blocks) {
        if (CellBlockDecomposer.checkRemainingSlots(nodeRemainingSlots, entryNode, 1)) {
            for (Node node : busCell.getInternalAdjacentNodes(entryNode)) {
                if (!CellBlockDecomposer.checkRemainingSlots(nodeRemainingSlots, node, 1)) continue;
                List<Node> primaryPattern = CellBlockDecomposer.pileUp2adjNodes(entryNode, node, nodeRemainingSlots);
                blocks.add(BodyPrimaryBlock.createBodyPrimaryBlockInBusCell(primaryPattern));
                Node lastNode = primaryPattern.get(primaryPattern.size() - 1);
                CellBlockDecomposer.rElaborateBodyPrimaryBlocks(busCell, lastNode, nodeRemainingSlots, blocks);
            }
        }
    }

    private static List<Node> pileUp2adjNodes(Node parentNode, Node node, Map<Node, Integer> nodeRemainingSlots) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        CellBlockDecomposer.addNodeInBlockNodes(nodeRemainingSlots, nodes, parentNode, 1);
        Node parentCurrentNode = parentNode;
        Node currentNode = node;
        while (currentNode.getAdjacentNodes().size() == 2 && CellBlockDecomposer.checkRemainingSlots(nodeRemainingSlots, currentNode, 2)) {
            CellBlockDecomposer.addNodeInBlockNodes(nodeRemainingSlots, nodes, currentNode, 2);
            Node nextNode = CellBlockDecomposer.getNextNode(currentNode, parentCurrentNode);
            parentCurrentNode = currentNode;
            currentNode = nextNode;
        }
        CellBlockDecomposer.addNodeInBlockNodes(nodeRemainingSlots, nodes, currentNode, 1);
        return nodes;
    }

    private static Node getNextNode(Node currentNode, Node parentCurrentNode) {
        List<Node> adjacentNodes;
        return adjacentNodes.get((adjacentNodes = currentNode.getAdjacentNodes()).get(0).equals(parentCurrentNode) ? 1 : 0);
    }
}

