/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.model.nodes.Node;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class GraphTraversal {
    private GraphTraversal() {
    }

    static boolean run(Node node, Predicate<Node> extremityCriteria, Predicate<Node> unsuccessfulCriteria, Set<Node> nodesResult, Set<Node> outsideNodes) {
        if (outsideNodes.contains(node)) {
            return false;
        }
        nodesResult.add(node);
        List nodesToVisit = node.getAdjacentNodes().stream().filter(n -> !outsideNodes.contains(n) && !nodesResult.contains(n)).collect(Collectors.toList());
        if (nodesToVisit.isEmpty()) {
            return true;
        }
        for (Node n2 : nodesToVisit) {
            if (unsuccessfulCriteria.test(n2)) {
                return false;
            }
            if (extremityCriteria.test(n2)) {
                nodesResult.add(n2);
                continue;
            }
            if (GraphTraversal.run(n2, extremityCriteria, unsuccessfulCriteria, nodesResult, outsideNodes)) continue;
            return false;
        }
        return true;
    }

    static Set<Node> run(Node node, Predicate<Node> extremityCriteria, Set<Node> outsideNodes) {
        LinkedHashSet<Node> nodesResult = new LinkedHashSet<Node>();
        GraphTraversal.run(node, extremityCriteria, n -> false, nodesResult, outsideNodes);
        return nodesResult;
    }
}

