/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.layout.LBSCluster;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.nodes.BusNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class HorizontalBusLane {
    private final List<BusNode> busNodes = new ArrayList<BusNode>();
    private int startingIndex;
    private LBSCluster lbsCluster;

    HorizontalBusLane(BusNode busNode, LBSCluster lbsCluster) {
        this.busNodes.add(busNode);
        this.lbsCluster = lbsCluster;
        this.startingIndex = 0;
    }

    void reverse(int parentSize) {
        Collections.reverse(this.busNodes);
        this.startingIndex = parentSize - this.getEndingIndex();
    }

    public void shift(int i) {
        this.startingIndex += i;
    }

    public void merge(HorizontalBusLane otherLane) {
        BusNode myRightBus = this.getSideNode(Side.RIGHT);
        for (int i = this.getEndingIndex(); i < otherLane.getStartingIndex() + (this.lbsCluster == otherLane.lbsCluster ? 0 : this.lbsCluster.getLength()); ++i) {
            this.busNodes.add(myRightBus == otherLane.getSideNode(Side.LEFT) ? myRightBus : null);
        }
        this.busNodes.addAll(otherLane.getBusNodes());
    }

    void establishBusPosition(int v) {
        int h = 1;
        Object prevBus = null;
        for (BusNode busNode : this.busNodes) {
            if (busNode == prevBus) continue;
            busNode.setBusBarIndexSectionIndex(v, h);
            ++h;
        }
    }

    public List<BusNode> getBusNodes() {
        return this.busNodes;
    }

    public BusNode getSideNode(Side side) {
        if (side == Side.UNDEFINED || this.busNodes.isEmpty()) {
            return null;
        }
        if (side == Side.LEFT) {
            return this.busNodes.get(0);
        }
        return this.busNodes.get(this.busNodes.size() - 1);
    }

    public int getStartingIndex() {
        return this.startingIndex;
    }

    public int getEndingIndex() {
        return this.startingIndex + this.busNodes.size();
    }

    public BusNode getBusNode(int index) {
        if (index < this.startingIndex || index >= this.getEndingIndex()) {
            return null;
        }
        return this.busNodes.get(index - this.startingIndex);
    }

    public void setLbsCluster(LBSCluster lbsCluster) {
        this.lbsCluster = lbsCluster;
    }

    public String toString() {
        return String.join((CharSequence)";", this.busNodes.stream().map(node -> node == null ? "null" : node.getId()).collect(Collectors.toList()));
    }
}

