/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.layout.AbstractSubstationLayout;
import com.powsybl.sld.layout.InfosNbSnakeLinesHorizontal;
import com.powsybl.sld.layout.Layout;
import com.powsybl.sld.layout.LayoutParameters;
import com.powsybl.sld.layout.VoltageLevelLayoutFactory;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.coordinate.Point;
import com.powsybl.sld.model.graphs.BaseGraph;
import com.powsybl.sld.model.graphs.SubstationGraph;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.Node;
import java.util.List;

public class HorizontalSubstationLayout
extends AbstractSubstationLayout {
    private final InfosNbSnakeLinesHorizontal infosNbSnakeLines;

    public HorizontalSubstationLayout(SubstationGraph graph, VoltageLevelLayoutFactory vLayoutFactory) {
        super(graph, vLayoutFactory);
        this.infosNbSnakeLines = InfosNbSnakeLinesHorizontal.create(graph);
    }

    @Override
    protected List<Point> calculatePolylineSnakeLine(LayoutParameters layoutParam, Node node1, Node node2, boolean increment) {
        double yMin = this.getGraph().getVoltageLevels().stream().mapToDouble(VoltageLevelGraph::getY).min().orElse(0.0);
        double yMax = this.getGraph().getVoltageLevels().stream().mapToDouble(g -> g.getY() + g.getInnerHeight(layoutParam.getVerticalSpaceBus())).max().orElse(0.0);
        return this.calculatePolylineSnakeLineForHorizontalLayout(layoutParam, node1, node2, increment, this.infosNbSnakeLines, yMin, yMax);
    }

    @Override
    protected void calculateCoordVoltageLevels(LayoutParameters layoutParameters) {
        LayoutParameters.Padding diagramPadding = layoutParameters.getDiagramPadding();
        LayoutParameters.Padding voltageLevelPadding = layoutParameters.getVoltageLevelPadding();
        double topPadding = diagramPadding.getTop() + voltageLevelPadding.getTop();
        double x = diagramPadding.getLeft();
        double substationHeight = 0.0;
        for (VoltageLevelGraph vlGraph : this.getGraph().getVoltageLevels()) {
            Layout vLayout = this.vLayoutFactory.create(vlGraph);
            vLayout.run(layoutParameters);
            vlGraph.setCoord(x += voltageLevelPadding.getLeft(), this.computeCoordY(layoutParameters, topPadding, vlGraph));
            x += vlGraph.getWidth() + voltageLevelPadding.getRight();
            substationHeight = Math.max(substationHeight, vlGraph.getHeight());
        }
        double substationWidth = x - diagramPadding.getLeft();
        this.getGraph().setSize(substationWidth, substationHeight);
    }

    @Override
    public void manageSnakeLines(LayoutParameters layoutParameters) {
        this.getGraph().getVoltageLevels().forEach(g -> this.manageSnakeLines((BaseGraph)g, layoutParameters));
        this.manageSnakeLines(this.getGraph(), layoutParameters);
        this.adaptPaddingToSnakeLines(layoutParameters);
    }

    private void adaptPaddingToSnakeLines(LayoutParameters layoutParameters) {
        double heightSnakeLinesTop = HorizontalSubstationLayout.getHeightSnakeLines(layoutParameters, Direction.TOP, this.infosNbSnakeLines);
        LayoutParameters.Padding diagramPadding = layoutParameters.getDiagramPadding();
        LayoutParameters.Padding voltageLevelPadding = layoutParameters.getVoltageLevelPadding();
        double topPadding = heightSnakeLinesTop + diagramPadding.getTop() + voltageLevelPadding.getTop();
        double x = diagramPadding.getLeft();
        for (VoltageLevelGraph vlGraph : this.getGraph().getVoltageLevels()) {
            vlGraph.setCoord((x += HorizontalSubstationLayout.getWidthVerticalSnakeLines(vlGraph.getId(), layoutParameters, this.infosNbSnakeLines)) + voltageLevelPadding.getLeft(), this.computeCoordY(layoutParameters, topPadding, vlGraph));
            x += vlGraph.getWidth();
        }
        double substationWidth = x - diagramPadding.getLeft();
        double heightSnakeLinesBottom = HorizontalSubstationLayout.getHeightSnakeLines(layoutParameters, Direction.BOTTOM, this.infosNbSnakeLines);
        double substationHeight = this.getGraph().getHeight() + heightSnakeLinesTop + heightSnakeLinesBottom;
        this.getGraph().setSize(substationWidth, substationHeight);
        this.infosNbSnakeLines.reset();
        this.getGraph().getVoltageLevels().forEach(g -> this.manageSnakeLines((BaseGraph)g, layoutParameters));
        this.manageSnakeLines(this.getGraph(), layoutParameters);
    }

    double computeCoordY(LayoutParameters layoutParameters, double topPadding, VoltageLevelGraph vlGraph) {
        double y;
        double maxTopExternCellHeight = this.getGraph().getVoltageLevelStream().mapToDouble(g -> g.getExternCellHeight(Direction.TOP)).max().orElse(0.0);
        double delta = maxTopExternCellHeight - vlGraph.getExternCellHeight(Direction.TOP);
        double maxV = this.getGraph().getVoltageLevelStream().mapToDouble(VoltageLevelGraph::getMaxV).max().orElse(0.0);
        double bbsHeight = layoutParameters.getVerticalSpaceBus() * (maxV - (double)vlGraph.getMaxV());
        switch (layoutParameters.getBusbarsAlignment()) {
            case FIRST: {
                y = topPadding + delta;
                break;
            }
            case LAST: {
                y = topPadding + delta + bbsHeight;
                break;
            }
            case MIDDLE: {
                y = topPadding + delta + bbsHeight / 2.0;
                break;
            }
            default: {
                y = topPadding;
            }
        }
        return y;
    }
}

