/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.layout.CellDetector;
import com.powsybl.sld.layout.GraphTraversal;
import com.powsybl.sld.model.cells.Cell;
import com.powsybl.sld.model.cells.ExternCell;
import com.powsybl.sld.model.cells.InternCell;
import com.powsybl.sld.model.cells.ShuntCell;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.ConnectivityNode;
import com.powsybl.sld.model.nodes.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplicitCellDetector
implements CellDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImplicitCellDetector.class);
    private final boolean exceptionIfPatternNotHandled;

    public ImplicitCellDetector(boolean exceptionIfPatternNotHandled) {
        this.exceptionIfPatternNotHandled = exceptionIfPatternNotHandled;
    }

    public ImplicitCellDetector() {
        this(false);
    }

    @Override
    public void detectCells(VoltageLevelGraph graph) {
        LOGGER.info("Detecting cells...");
        ArrayList<Node> allocatedNodes = new ArrayList<Node>();
        ArrayList<Node.NodeType> exclusionTypes = new ArrayList<Node.NodeType>();
        exclusionTypes.add(Node.NodeType.FEEDER);
        ArrayList<Node.NodeType> stopTypes = new ArrayList<Node.NodeType>();
        stopTypes.add(Node.NodeType.BUS);
        List<Set<Node>> internCellsNodes = this.detectCell(graph, stopTypes, exclusionTypes, allocatedNodes);
        for (Set<Node> nodes : internCellsNodes) {
            graph.addCell(new InternCell(graph.getNextCellNumber(), nodes, this.exceptionIfPatternNotHandled));
        }
        stopTypes.add(Node.NodeType.FEEDER);
        List<Set<Node>> externCellsNodes = this.detectCell(graph, stopTypes, new ArrayList<Node.NodeType>(), allocatedNodes);
        for (Set<Node> nodes : externCellsNodes) {
            this.createExternAndShuntCells(graph, nodes);
        }
        graph.getCellStream().forEach(Cell::getFullId);
        graph.logCellDetectionStatus();
    }

    private void createExternAndShuntCells(VoltageLevelGraph graph, Set<Node> nodes) {
        this.createExternAndShuntCells(graph, nodes, Collections.emptyList());
    }

    private void createExternAndShuntCells(VoltageLevelGraph graph, Set<Node> nodes, List<ShuntCell> shuntCells) {
        if (this.isPureExternCell(graph, nodes)) {
            graph.addCell(new ExternCell(graph.getNextCellNumber(), nodes, shuntCells));
        } else {
            this.detectAndTypeShunt(graph, nodes, shuntCells);
        }
    }

    private List<Set<Node>> detectCell(VoltageLevelGraph graph, List<Node.NodeType> typeStops, List<Node.NodeType> exclusionTypes, List<Node> allocatedNodes) {
        ArrayList<Set<Node>> cellsNodes = new ArrayList<Set<Node>>();
        graph.getNodeBuses().forEach(bus -> bus.getAdjacentNodes().forEach(adj -> {
            LinkedHashSet<Node> cellNodes = new LinkedHashSet<Node>();
            cellNodes.add((Node)bus);
            HashSet<Node> outsideNodes = new HashSet<Node>(allocatedNodes);
            outsideNodes.add((Node)bus);
            if (GraphTraversal.run(adj, node -> typeStops.contains((Object)node.getType()), node -> exclusionTypes.contains((Object)node.getType()), cellNodes, outsideNodes)) {
                cellsNodes.add(cellNodes);
                cellNodes.stream().filter(node -> node.getType() != Node.NodeType.BUS).forEach(allocatedNodes::add);
            }
        }));
        return cellsNodes;
    }

    private boolean isPureExternCell(VoltageLevelGraph graph, Set<Node> cellNodes) {
        for (Node n : cellNodes) {
            ArrayList<Node> nodes = new ArrayList<Node>(cellNodes);
            nodes.remove(n);
            List<List<Node>> connexComponents = graph.getConnexComponents(nodes);
            if (!this.checkExternComponents(connexComponents)) continue;
            return true;
        }
        return false;
    }

    private boolean checkExternComponents(List<List<Node>> connexComponents) {
        if (connexComponents.size() > 1) {
            boolean hasDepartBranch = false;
            boolean hasBusBranch = false;
            boolean hasMixBranch = false;
            for (List<Node> nodesConnex : connexComponents) {
                List types = nodesConnex.stream().map(Node::getType).distinct().filter(t -> t == Node.NodeType.FEEDER || t == Node.NodeType.BUS).collect(Collectors.toList());
                if (types.size() == 2) {
                    hasMixBranch = true;
                    continue;
                }
                if (types.isEmpty()) {
                    return false;
                }
                if (((Node.NodeType)((Object)types.get(0))).equals((Object)Node.NodeType.FEEDER)) {
                    hasDepartBranch = true;
                    continue;
                }
                hasBusBranch = true;
            }
            return hasBusBranch && hasDepartBranch && !hasMixBranch;
        }
        return false;
    }

    private void detectAndTypeShunt(VoltageLevelGraph graph, Set<Node> nodes, List<ShuntCell> shuntCells) {
        List<Node> externalNodes = graph.getNodes().stream().filter(node -> !nodes.contains(node)).collect(Collectors.toList());
        Optional<List> cellNodesExtern = nodes.stream().filter(n -> n.getAdjacentNodes().size() > 2 && n instanceof ConnectivityNode).map(n -> this.checkCandidateShuntNode((ConnectivityNode)n, externalNodes)).filter(nodesExternCell -> !nodesExternCell.isEmpty()).findFirst();
        if (cellNodesExtern.isPresent()) {
            LinkedHashSet<Node> remainingNodes = new LinkedHashSet<Node>(nodes);
            ArrayList<ShuntCell> shuntCellsCreated = new ArrayList<ShuntCell>(shuntCells);
            ConnectivityNode shuntNode = (ConnectivityNode)cellNodesExtern.get().get(0);
            this.splitNodes(graph, nodes, shuntNode, cellNodesExtern.get(), remainingNodes, externalNodes, shuntCellsCreated);
            remainingNodes.removeIf(rn -> this.isIsolatedBusOrShunt((Set<Node>)remainingNodes, (Node)rn));
            List<ShuntCell> linkedShuntCells = shuntCellsCreated.stream().filter(sc -> remainingNodes.contains(sc.getSideShuntNode(Side.RIGHT))).collect(Collectors.toList());
            this.createExternAndShuntCells(graph, remainingNodes, linkedShuntCells);
        } else {
            graph.addCell(new ExternCell(graph.getNextCellNumber(), nodes, shuntCells));
        }
    }

    private static boolean isShunt(Node node) {
        return node instanceof ConnectivityNode && ((ConnectivityNode)node).isShunt();
    }

    private void splitNodes(VoltageLevelGraph graph, Set<Node> nodes, ConnectivityNode shuntNode, List<Node> cellNodesExtern, Set<Node> remainingNodes, List<Node> externalNodes, List<ShuntCell> shuntCellsCreated) {
        List<ShuntCell> linkedShuntCells = shuntCellsCreated.stream().filter(shuntCell -> cellNodesExtern.contains(shuntCell.getSideShuntNode(Side.RIGHT))).collect(Collectors.toList());
        ExternCell newExternCell = new ExternCell(graph.getNextCellNumber(), cellNodesExtern, linkedShuntCells);
        graph.addCell(newExternCell);
        cellNodesExtern.stream().filter(m -> m.getType() != Node.NodeType.BUS && !ImplicitCellDetector.isShunt(m)).forEach(remainingNodes::remove);
        List<List<Node>> shuntsNodes = this.createShuntCellNodes(graph, shuntNode, newExternCell, nodes);
        shuntsNodes.stream().flatMap(Collection::stream).filter(m -> !ImplicitCellDetector.isShunt(m)).forEach(remainingNodes::remove);
        shuntsNodes.stream().map(shuntNodes -> this.createShuntCell(graph, (List<Node>)shuntNodes)).forEach(shuntCell -> {
            newExternCell.addShuntCell((ShuntCell)shuntCell);
            shuntCellsCreated.add((ShuntCell)shuntCell);
        });
        for (List<Node> shuntNodes2 : shuntsNodes) {
            ConnectivityNode consecutiveShuntNode = (ConnectivityNode)shuntNodes2.get(shuntNodes2.size() - 1);
            List<Node> cellNodesExtern2 = this.checkCandidateShuntNode(consecutiveShuntNode, externalNodes);
            if (cellNodesExtern2.isEmpty()) continue;
            this.splitNodes(graph, nodes, consecutiveShuntNode, cellNodesExtern2, remainingNodes, externalNodes, shuntCellsCreated);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isIsolatedBusOrShunt(Set<Node> remainingNodes, Node rn) {
        if (rn.getType() != Node.NodeType.BUS) {
            if (!ImplicitCellDetector.isShunt(rn)) return false;
        }
        if (!rn.getAdjacentNodes().stream().noneMatch(remainingNodes::contains)) return false;
        return true;
    }

    private ShuntCell createShuntCell(VoltageLevelGraph vlGraph, List<Node> shuntNodes) {
        int cellNumber = vlGraph.getNextCellNumber();
        ConnectivityNode iNode1 = vlGraph.insertConnectivityNode(shuntNodes.get(0), shuntNodes.get(1), "Shunt " + cellNumber + ".1");
        shuntNodes.add(1, iNode1);
        ConnectivityNode iNode2 = vlGraph.insertConnectivityNode(shuntNodes.get(shuntNodes.size() - 1), shuntNodes.get(shuntNodes.size() - 2), "Shunt " + cellNumber + ".2");
        shuntNodes.add(shuntNodes.size() - 1, iNode2);
        return ShuntCell.create(cellNumber, shuntNodes, vlGraph);
    }

    private List<Node> checkCandidateShuntNode(ConnectivityNode candidateShuntNode, List<Node> externalNodes) {
        Predicate<Node> filter = node -> node.getType() == Node.NodeType.BUS || node.getType() == Node.NodeType.FEEDER || ImplicitCellDetector.isShunt(node);
        HashSet<Node> visitedNodes = new HashSet<Node>(externalNodes);
        visitedNodes.add(candidateShuntNode);
        ArrayList<Node> cellNodesExtern = new ArrayList<Node>();
        cellNodesExtern.add(candidateShuntNode);
        boolean hasFeederBranch = false;
        boolean hasBusBranch = false;
        boolean hasMixBranch = false;
        ArrayList<Node> adjList = new ArrayList<Node>(candidateShuntNode.getAdjacentNodes());
        adjList.removeAll(visitedNodes);
        for (Node adj : adjList) {
            boolean hasFeeder;
            boolean hasBus;
            Set<Node> resultNodes = GraphTraversal.run(adj, filter, visitedNodes);
            boolean hasShunt = resultNodes.stream().anyMatch(ImplicitCellDetector::isShunt);
            int nbTypes = (hasShunt ? 1 : 0) + ((hasBus = resultNodes.stream().anyMatch(node -> node.getType() == Node.NodeType.BUS)) ? 1 : 0) + ((hasFeeder = resultNodes.stream().anyMatch(node -> node.getType() == Node.NodeType.FEEDER)) ? 1 : 0);
            if (nbTypes > 1) {
                hasMixBranch = true;
            } else if (nbTypes == 1) {
                hasBusBranch |= hasBus;
                hasFeederBranch |= hasFeeder;
                if (hasBus || hasFeeder) {
                    cellNodesExtern.addAll(resultNodes);
                }
            }
            resultNodes.stream().filter(m -> m.getType() != Node.NodeType.BUS).forEach(visitedNodes::add);
        }
        return ImplicitCellDetector.selectShuntNode(candidateShuntNode, cellNodesExtern, hasBusBranch, hasFeederBranch, hasMixBranch);
    }

    private static List<Node> selectShuntNode(ConnectivityNode candidateShuntNode, List<Node> cellNodesExtern, boolean hasBusBranch, boolean hasFeederBranch, boolean hasMixBranc) {
        if (hasBusBranch && hasFeederBranch && hasMixBranc) {
            candidateShuntNode.setShunt(true);
            return cellNodesExtern;
        }
        return Collections.emptyList();
    }

    private List<List<Node>> createShuntCellNodes(VoltageLevelGraph graph, ConnectivityNode shuntNode, ExternCell cellExtern1, Set<Node> cellNodes) {
        ArrayList<List<Node>> shuntCellsNodes = new ArrayList<List<Node>>();
        shuntNode.getAdjacentNodes().stream().filter(node -> !cellExtern1.getNodes().contains(node)).filter(node -> !ImplicitCellDetector.isShunt(node)).filter(node -> graph.getCell((Node)node).map(c -> c.getType() != Cell.CellType.SHUNT).orElse(true)).forEach(node -> {
            ArrayList<Node> shuntCellNodes = new ArrayList<Node>();
            shuntCellsNodes.add(shuntCellNodes);
            shuntCellNodes.add(shuntNode);
            Node currentNode = node;
            while (currentNode.getAdjacentNodes().size() == 2 && cellNodes.contains(currentNode)) {
                shuntCellNodes.add(currentNode);
                currentNode = shuntCellNodes.contains(currentNode.getAdjacentNodes().get(0)) ? currentNode.getAdjacentNodes().get(1) : currentNode.getAdjacentNodes().get(0);
            }
            if (currentNode instanceof ConnectivityNode) {
                shuntCellNodes.add(currentNode);
                ((ConnectivityNode)currentNode).setShunt(true);
            } else {
                shuntCellsNodes.remove(shuntCellNodes);
            }
        });
        return shuntCellsNodes;
    }
}

