/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.graphs.SubstationGraph;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class InfosNbSnakeLinesHorizontal {
    private final Map<Direction, Integer> nbSnakeLinesTopBottom;
    private final Map<String, Integer> nbSnakeLinesVerticalBetween;

    static InfosNbSnakeLinesHorizontal create(SubstationGraph substationGraph) {
        Map<Direction, Integer> nbSnakeLinesTopBottom = EnumSet.allOf(Direction.class).stream().collect(Collectors.toMap(Function.identity(), v -> 0));
        Map<String, Integer> nbSnakeLinesVerticalBetween = substationGraph.getVoltageLevelStream().collect(Collectors.toMap(g -> g.getVoltageLevelInfos().getId(), v -> 0));
        return new InfosNbSnakeLinesHorizontal(nbSnakeLinesTopBottom, nbSnakeLinesVerticalBetween);
    }

    static InfosNbSnakeLinesHorizontal create(VoltageLevelGraph graph) {
        Map<Direction, Integer> nbSnakeLinesTopBottom = EnumSet.allOf(Direction.class).stream().collect(Collectors.toMap(Function.identity(), v -> 0));
        Map<String, Integer> nbSnakeLinesBetween = Stream.of(graph).collect(Collectors.toMap(g -> g.getVoltageLevelInfos().getId(), v -> 0));
        return new InfosNbSnakeLinesHorizontal(nbSnakeLinesTopBottom, nbSnakeLinesBetween);
    }

    private InfosNbSnakeLinesHorizontal(Map<Direction, Integer> nbSnakeLinesTopBottom, Map<String, Integer> nbSnakeLinesVerticalBetween) {
        this.nbSnakeLinesTopBottom = nbSnakeLinesTopBottom;
        this.nbSnakeLinesVerticalBetween = nbSnakeLinesVerticalBetween;
    }

    public Map<Direction, Integer> getNbSnakeLinesTopBottom() {
        return this.nbSnakeLinesTopBottom;
    }

    public Map<String, Integer> getNbSnakeLinesVerticalBetween() {
        return this.nbSnakeLinesVerticalBetween;
    }

    public void reset() {
        this.nbSnakeLinesTopBottom.keySet().forEach(side -> this.nbSnakeLinesTopBottom.compute((Direction)((Object)side), (k, v) -> 0));
        this.nbSnakeLinesVerticalBetween.keySet().forEach(side -> this.nbSnakeLinesVerticalBetween.compute((String)side, (k, v) -> 0));
    }
}

