/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.graphs.SubstationGraph;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InfosNbSnakeLinesVertical {
    private final Map<Side, Integer> nbSnakeLinesLeftRight;
    private final List<String> vlYSorted;
    private final int[] nbSnakeLinesHorizontalBetween;

    static InfosNbSnakeLinesVertical create(SubstationGraph substationGraph) {
        Map<Side, Integer> nbSnakeLinesLeftRight = EnumSet.allOf(Side.class).stream().collect(Collectors.toMap(Function.identity(), v -> 0));
        List<String> vlYSorted = substationGraph.getVoltageLevelStream().map(VoltageLevelGraph::getId).collect(Collectors.toList());
        int[] nbSnakeLinesHorizontalBetween = new int[(int)substationGraph.getVoltageLevelStream().count() + 1];
        return new InfosNbSnakeLinesVertical(nbSnakeLinesLeftRight, vlYSorted, nbSnakeLinesHorizontalBetween);
    }

    protected InfosNbSnakeLinesVertical(Map<Side, Integer> nbSnakeLinesLeftRight, List<String> vlYSorted, int[] nbSnakeLinesHorizontalBetween) {
        this.nbSnakeLinesLeftRight = nbSnakeLinesLeftRight;
        this.vlYSorted = vlYSorted;
        this.nbSnakeLinesHorizontalBetween = nbSnakeLinesHorizontalBetween;
    }

    public Map<Side, Integer> getNbSnakeLinesLeftRight() {
        return this.nbSnakeLinesLeftRight;
    }

    private int getSnakeLinesIndex(Direction direction, String vlId) {
        int vlIndex = this.vlYSorted.indexOf(vlId);
        return direction == Direction.BOTTOM ? vlIndex + 1 : vlIndex;
    }

    public int getNbSnakeLinesHorizontalBetween(String vlId, Direction direction) {
        return this.nbSnakeLinesHorizontalBetween[this.getSnakeLinesIndex(direction, vlId)];
    }

    public void setNbSnakeLinesTopBottom(String vlId, Direction direction, int nbSnakeLines) {
        this.nbSnakeLinesHorizontalBetween[this.getSnakeLinesIndex((Direction)direction, (String)vlId)] = nbSnakeLines;
    }

    public int incrementAndGetNbSnakeLinesTopBottom(String vlId, Direction direction) {
        int n = this.getSnakeLinesIndex(direction, vlId);
        int n2 = this.nbSnakeLinesHorizontalBetween[n] + 1;
        this.nbSnakeLinesHorizontalBetween[n] = n2;
        return n2;
    }

    public void reset() {
        this.nbSnakeLinesLeftRight.keySet().forEach(side -> this.nbSnakeLinesLeftRight.compute((Side)((Object)side), (k, v) -> 0));
        Arrays.fill(this.nbSnakeLinesHorizontalBetween, 0);
    }
}

