/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.layout.HorizontalBusLane;
import com.powsybl.sld.layout.HorizontalBusLaneManager;
import com.powsybl.sld.layout.LegBusSet;
import com.powsybl.sld.model.cells.InternCell;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.nodes.BusNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class LBSCluster {
    private final List<LegBusSet> lbsList = new ArrayList<LegBusSet>();
    private final List<HorizontalBusLane> horizontalBusLanes = new ArrayList<HorizontalBusLane>();
    private final int nb;

    public LBSCluster(LegBusSet lbs, int nb) {
        Objects.requireNonNull(lbs);
        this.lbsList.add(lbs);
        lbs.getBusNodeSet().forEach(nodeBus -> this.horizontalBusLanes.add(new HorizontalBusLane((BusNode)nodeBus, this)));
        this.nb = nb;
    }

    public static List<LBSCluster> createLBSClusters(List<LegBusSet> legBusSets) {
        ArrayList<LBSCluster> lbsClusters = new ArrayList<LBSCluster>();
        int nb = 0;
        for (LegBusSet lbs : legBusSets) {
            lbsClusters.add(new LBSCluster(lbs, nb++));
        }
        return lbsClusters;
    }

    public void merge(Side myConcernedSide, LBSCluster otherLbsCluster, Side otherSide, HorizontalBusLaneManager hblManager) {
        if (myConcernedSide == Side.LEFT) {
            this.reverse();
        }
        if (otherSide == Side.RIGHT) {
            otherLbsCluster.reverse();
        }
        hblManager.mergeHorizontalBusLanes(this, otherLbsCluster);
        this.lbsList.addAll(otherLbsCluster.lbsList);
    }

    public List<BusNode> laneSideBuses(Side side) {
        return LBSCluster.laneSideBuses(side, this.horizontalBusLanes);
    }

    public static List<BusNode> laneSideBuses(Side side, List<HorizontalBusLane> horizontalBusLaneList) {
        return horizontalBusLaneList.stream().map(hl -> hl.getSideNode(side)).collect(Collectors.toList());
    }

    public void removeHorizontalBusLane(HorizontalBusLane lane) {
        this.horizontalBusLanes.remove(lane);
    }

    public void establishBusNodePosition() {
        int v = 1;
        for (HorizontalBusLane lane : this.horizontalBusLanes) {
            lane.establishBusPosition(v);
            ++v;
        }
    }

    public HorizontalBusLane getHorizontalLaneFromSideBus(BusNode busNode, Side side) {
        return this.horizontalBusLanes.stream().filter(horizontalBusLane -> horizontalBusLane.getSideNode(side) == busNode).findAny().orElse(null);
    }

    List<BusNode> getVerticalBuseNodes(int i) {
        return this.horizontalBusLanes.stream().map(hbl -> hbl.getBusNode(i)).collect(Collectors.toList());
    }

    private void reverse() {
        Collections.reverse(this.lbsList);
        this.horizontalBusLanes.forEach(lane -> lane.reverse(this.lbsList.size()));
    }

    private LegBusSet getLbsSideFromBusNode(BusNode busNode, Side side) {
        if (side != Side.RIGHT && side != Side.LEFT) {
            return null;
        }
        for (int i = 0; i < this.lbsList.size(); ++i) {
            int j;
            int n = j = side == Side.LEFT ? i : this.lbsList.size() - i - 1;
            if (!this.lbsList.get(j).getBusNodeSet().contains(busNode)) continue;
            return this.lbsList.get(j);
        }
        return null;
    }

    public List<InternCell> getSideCandidateFlatCell(Side side) {
        return this.laneSideBuses(side).stream().map(busNode -> this.getLbsSideFromBusNode((BusNode)busNode, side)).distinct().filter(Objects::nonNull).flatMap(lbs -> lbs.getInternCellsFromShape(InternCell.Shape.MAYBE_FLAT).stream()).collect(Collectors.toList());
    }

    public List<InternCell> getInternCellsFromShape(InternCell.Shape shape) {
        return this.lbsList.stream().flatMap(legBusSet -> legBusSet.getInternCellsFromShape(shape).stream()).collect(Collectors.toList());
    }

    public void sortHorizontalBusLanesByVPos() {
        this.horizontalBusLanes.sort(Comparator.comparingInt(hbl -> hbl.getBusNodes().get(0).getBusbarIndex()));
    }

    public int getLength() {
        return this.lbsList.size();
    }

    public List<HorizontalBusLane> getHorizontalBusLanes() {
        return this.horizontalBusLanes;
    }

    public List<LegBusSet> getLbsList() {
        return this.lbsList;
    }

    public String toString() {
        return this.lbsList.toString() + "\n" + this.horizontalBusLanes.toString();
    }

    int getNb() {
        return this.nb;
    }
}

