/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.powsybl.diagram.util.ValueFormatter;
import com.powsybl.sld.library.ComponentSize;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class LayoutParameters {
    private double verticalSpaceBus = 25.0;
    private double horizontalBusPadding = 20.0;
    private double cellWidth = 50.0;
    private double externCellHeight = 250.0;
    private double internCellHeight = 40.0;
    private double stackHeight = 30.0;
    private boolean showGrid = false;
    private boolean showInternalNodes = false;
    private double scaleFactor = 1.0;
    private String diagramName = null;
    private boolean drawStraightWires = false;
    private double horizontalSnakeLinePadding = 20.0;
    private double verticalSnakeLinePadding = 25.0;
    private double feederInfosOuterMargin = 20.0;
    private double spaceForFeederInfos = 50.0;
    private boolean avoidSVGComponentsDuplication = false;
    private boolean adaptCellHeightToContent = true;
    private double maxComponentHeight = 12.0;
    private double minSpaceBetweenComponents = 15.0;
    private double minExternCellHeight = 80.0;
    private double angleLabelShift = 15.0;
    private boolean labelCentered = false;
    private boolean labelDiagonal = false;
    private boolean tooltipEnabled = false;
    private boolean addNodesInfos = false;
    private boolean feederInfoSymmetry = false;
    private CssLocation cssLocation = CssLocation.INSERTED_IN_SVG;
    private Padding voltageLevelPadding = new Padding(20.0, 60.0, 20.0, 60.0);
    private Padding diagramPadding = new Padding(20);
    private boolean svgWidthAndHeightAdded = false;
    private boolean useName = false;
    private double feederInfosIntraMargin = 10.0;
    private Alignment busbarsAlignment = Alignment.FIRST;
    private boolean removeFictitiousSwitchNodes = false;
    private double busInfoMargin = 0.0;
    private List<String> componentsOnBusbars = List.of("DISCONNECTOR");
    private String languageTag = "en";
    private int voltageValuePrecision = 1;
    private int powerValuePrecision = 0;
    private int angleValuePrecision = 1;
    private int currentValuePrecision = 0;
    private String undefinedValueSymbol = "\u2014";
    @JsonIgnore
    private Map<String, ComponentSize> componentsSize;
    private boolean displayCurrentFeederInfo = false;

    @JsonCreator
    public LayoutParameters() {
    }

    @JsonCreator
    public LayoutParameters(@JsonProperty(value="voltageLevelPadding") Padding voltageLevelPadding, @JsonProperty(value="diagramPadding") Padding diagramPadding, @JsonProperty(value="verticalSpaceBus") double verticalSpaceBus, @JsonProperty(value="horizontalBusPadding") double horizontalBusPadding, @JsonProperty(value="cellWidth") double cellWidth, @JsonProperty(value="externCellHeight") double externCellHeight, @JsonProperty(value="internCellHeight") double internCellHeight, @JsonProperty(value="stackHeight") double stackHeight, @JsonProperty(value="showGrid") boolean showGrid, @JsonProperty(value="tooltipEnabled") boolean tooltipEnabled, @JsonProperty(value="showInternalNodes") boolean showInternalNodes, @JsonProperty(value="scaleFactor") double scaleFactor, @JsonProperty(value="drawStraightWires") boolean drawStraightWires, @JsonProperty(value="horizontalSnakeLinePadding") double horizontalSnakeLinePadding, @JsonProperty(value="verticalSnakeLinePadding") double verticalSnakeLinePadding, @JsonProperty(value="feederInfosOuterMargin") double feederInfosOuterMargin, @JsonProperty(value="spaceForFeederInfos") double spaceForFeederInfos, @JsonProperty(value="diagramName") String diagramName, @JsonProperty(value="avoidSVGComponentsDuplication") boolean avoidSVGComponentsDuplication, @JsonProperty(value="adaptCellHeightToContent") boolean adaptCellHeightToContent, @JsonProperty(value="maxComponentHeight") double maxComponentHeight, @JsonProperty(value="minSpaceBetweenComponents") double minSpaceBetweenComponents, @JsonProperty(value="minExternCellHeight") double minExternCellHeight, @JsonProperty(value="labelCentered") boolean labelCentered, @JsonProperty(value="labelDiagonal") boolean labelDiagonal, @JsonProperty(value="angleLabelShift") double angleLabelShift, @JsonProperty(value="addNodesInfos") boolean addNodesInfos, @JsonProperty(value="feederInfoSymmetry") boolean feederInfoSymmetry, @JsonProperty(value="cssLocation") CssLocation cssLocation, @JsonProperty(value="svgWidthAndHeightAdded") boolean svgWidthAndHeightAdded, @JsonProperty(value="useName") boolean useName, @JsonProperty(value="feederInfosIntraMargin") double feederInfosIntraMargin, @JsonProperty(value="busInfoMargin") double busInfoMargin, @JsonProperty(value="busbarsAlignment") Alignment busbarsAlignment, @JsonProperty(value="componentsOnBusbars") List<String> componentsOnBusbars, @JsonProperty(value="languageTag") String languageTag, @JsonProperty(value="voltageValuePrecision") int voltageValuePrecision, @JsonProperty(value="powerValuePrecision") int powerValuePrecision, @JsonProperty(value="angleValuePrecision") int angleValuePrecision, @JsonProperty(value="currentValuePrecision") int currentValuePrecision, @JsonProperty(value="displayCurrentFeederInfo") boolean displayCurrentFeederInfo, @JsonProperty(value="undefinedValueSymbol") String undefinedValueSymbol, @JsonProperty(value="removeFictitiousSwitchNodes") boolean removeFictitiousSwitchNodes) {
        this.diagramPadding = diagramPadding;
        this.voltageLevelPadding = voltageLevelPadding;
        this.verticalSpaceBus = verticalSpaceBus;
        this.horizontalBusPadding = horizontalBusPadding;
        this.cellWidth = cellWidth;
        this.externCellHeight = externCellHeight;
        this.internCellHeight = internCellHeight;
        this.stackHeight = stackHeight;
        this.showGrid = showGrid;
        this.tooltipEnabled = tooltipEnabled;
        this.showInternalNodes = showInternalNodes;
        this.scaleFactor = scaleFactor;
        this.drawStraightWires = drawStraightWires;
        this.horizontalSnakeLinePadding = horizontalSnakeLinePadding;
        this.verticalSnakeLinePadding = verticalSnakeLinePadding;
        this.feederInfosOuterMargin = feederInfosOuterMargin;
        this.spaceForFeederInfos = spaceForFeederInfos;
        this.diagramName = diagramName;
        this.avoidSVGComponentsDuplication = avoidSVGComponentsDuplication;
        this.adaptCellHeightToContent = adaptCellHeightToContent;
        this.maxComponentHeight = maxComponentHeight;
        this.minSpaceBetweenComponents = minSpaceBetweenComponents;
        this.minExternCellHeight = minExternCellHeight;
        this.labelCentered = labelCentered;
        this.labelDiagonal = labelDiagonal;
        this.angleLabelShift = angleLabelShift;
        this.addNodesInfos = addNodesInfos;
        this.feederInfoSymmetry = feederInfoSymmetry;
        this.cssLocation = cssLocation;
        this.svgWidthAndHeightAdded = svgWidthAndHeightAdded;
        this.useName = useName;
        this.feederInfosIntraMargin = feederInfosIntraMargin;
        this.busInfoMargin = busInfoMargin;
        this.busbarsAlignment = busbarsAlignment;
        this.componentsOnBusbars = new ArrayList<String>(componentsOnBusbars);
        this.languageTag = languageTag;
        this.voltageValuePrecision = voltageValuePrecision;
        this.powerValuePrecision = powerValuePrecision;
        this.angleValuePrecision = angleValuePrecision;
        this.currentValuePrecision = currentValuePrecision;
        this.displayCurrentFeederInfo = displayCurrentFeederInfo;
        this.undefinedValueSymbol = undefinedValueSymbol;
        this.removeFictitiousSwitchNodes = removeFictitiousSwitchNodes;
    }

    public LayoutParameters(LayoutParameters other) {
        Objects.requireNonNull(other);
        this.diagramPadding = new Padding(other.diagramPadding);
        this.voltageLevelPadding = new Padding(other.voltageLevelPadding);
        this.verticalSpaceBus = other.verticalSpaceBus;
        this.horizontalBusPadding = other.horizontalBusPadding;
        this.cellWidth = other.cellWidth;
        this.externCellHeight = other.externCellHeight;
        this.internCellHeight = other.internCellHeight;
        this.stackHeight = other.stackHeight;
        this.showGrid = other.showGrid;
        this.tooltipEnabled = other.tooltipEnabled;
        this.showInternalNodes = other.showInternalNodes;
        this.scaleFactor = other.scaleFactor;
        this.drawStraightWires = other.drawStraightWires;
        this.horizontalSnakeLinePadding = other.horizontalSnakeLinePadding;
        this.verticalSnakeLinePadding = other.verticalSnakeLinePadding;
        this.feederInfosOuterMargin = other.feederInfosOuterMargin;
        this.spaceForFeederInfos = other.spaceForFeederInfos;
        this.diagramName = other.diagramName;
        this.avoidSVGComponentsDuplication = other.avoidSVGComponentsDuplication;
        this.adaptCellHeightToContent = other.adaptCellHeightToContent;
        this.maxComponentHeight = other.maxComponentHeight;
        this.minSpaceBetweenComponents = other.minSpaceBetweenComponents;
        this.minExternCellHeight = other.minExternCellHeight;
        this.componentsSize = other.componentsSize;
        this.angleLabelShift = other.angleLabelShift;
        this.labelDiagonal = other.labelDiagonal;
        this.labelCentered = other.labelCentered;
        this.addNodesInfos = other.addNodesInfos;
        this.feederInfoSymmetry = other.feederInfoSymmetry;
        this.cssLocation = other.cssLocation;
        this.svgWidthAndHeightAdded = other.svgWidthAndHeightAdded;
        this.useName = other.useName;
        this.feederInfosIntraMargin = other.feederInfosIntraMargin;
        this.busInfoMargin = other.busInfoMargin;
        this.busbarsAlignment = other.busbarsAlignment;
        this.componentsOnBusbars = new ArrayList<String>(other.componentsOnBusbars);
        this.languageTag = other.languageTag;
        this.voltageValuePrecision = other.voltageValuePrecision;
        this.powerValuePrecision = other.powerValuePrecision;
        this.angleValuePrecision = other.angleValuePrecision;
        this.currentValuePrecision = other.currentValuePrecision;
        this.displayCurrentFeederInfo = other.displayCurrentFeederInfo;
        this.undefinedValueSymbol = other.undefinedValueSymbol;
        this.removeFictitiousSwitchNodes = other.removeFictitiousSwitchNodes;
    }

    public double getVerticalSpaceBus() {
        return this.verticalSpaceBus;
    }

    public LayoutParameters setVerticalSpaceBus(double verticalSpaceBus) {
        this.verticalSpaceBus = verticalSpaceBus;
        return this;
    }

    public double getHorizontalBusPadding() {
        return this.horizontalBusPadding;
    }

    public LayoutParameters setHorizontalBusPadding(double horizontalSpaceBus) {
        this.horizontalBusPadding = horizontalSpaceBus;
        return this;
    }

    public double getCellWidth() {
        return this.cellWidth;
    }

    public LayoutParameters setCellWidth(double cellWidth) {
        this.cellWidth = cellWidth;
        return this;
    }

    public double getExternCellHeight() {
        return this.externCellHeight;
    }

    public LayoutParameters setExternCellHeight(double externCellHeight) {
        this.externCellHeight = externCellHeight;
        return this;
    }

    public double getInternCellHeight() {
        return this.internCellHeight;
    }

    public LayoutParameters setInternCellHeight(double internCellHeight) {
        this.internCellHeight = internCellHeight;
        return this;
    }

    public double getStackHeight() {
        return this.stackHeight;
    }

    public LayoutParameters setStackHeight(double stackHeight) {
        this.stackHeight = stackHeight;
        return this;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public LayoutParameters setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
        return this;
    }

    public boolean isShowInternalNodes() {
        return this.showInternalNodes;
    }

    public LayoutParameters setShowInternalNodes(boolean showInternalNodes) {
        this.showInternalNodes = showInternalNodes;
        return this;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public LayoutParameters setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
        return this;
    }

    public String getDiagramName() {
        return this.diagramName;
    }

    public LayoutParameters setDiagramName(String diagramName) {
        this.diagramName = diagramName;
        return this;
    }

    public boolean isDrawStraightWires() {
        return this.drawStraightWires;
    }

    public LayoutParameters setDrawStraightWires(boolean drawStraightWires) {
        this.drawStraightWires = drawStraightWires;
        return this;
    }

    public double getHorizontalSnakeLinePadding() {
        return this.horizontalSnakeLinePadding;
    }

    public LayoutParameters setHorizontalSnakeLinePadding(double horizontalSnakeLinePadding) {
        this.horizontalSnakeLinePadding = horizontalSnakeLinePadding;
        return this;
    }

    public double getVerticalSnakeLinePadding() {
        return this.verticalSnakeLinePadding;
    }

    public LayoutParameters setVerticalSnakeLinePadding(double verticalSnakeLinePadding) {
        this.verticalSnakeLinePadding = verticalSnakeLinePadding;
        return this;
    }

    public double getFeederInfosOuterMargin() {
        return this.feederInfosOuterMargin;
    }

    public LayoutParameters setFeederInfosOuterMargin(double feederInfosOuterMargin) {
        this.feederInfosOuterMargin = feederInfosOuterMargin;
        return this;
    }

    public boolean isAvoidSVGComponentsDuplication() {
        return this.avoidSVGComponentsDuplication;
    }

    public LayoutParameters setAvoidSVGComponentsDuplication(boolean avoidSVGComponentsDuplication) {
        this.avoidSVGComponentsDuplication = avoidSVGComponentsDuplication;
        return this;
    }

    public boolean isAdaptCellHeightToContent() {
        return this.adaptCellHeightToContent;
    }

    public LayoutParameters setAdaptCellHeightToContent(boolean adaptCellHeightToContent) {
        this.adaptCellHeightToContent = adaptCellHeightToContent;
        return this;
    }

    public double getMaxComponentHeight() {
        return this.maxComponentHeight;
    }

    public LayoutParameters setMaxComponentHeight(double maxComponentHeight) {
        this.maxComponentHeight = maxComponentHeight;
        return this;
    }

    public double getMinSpaceBetweenComponents() {
        return this.minSpaceBetweenComponents;
    }

    public LayoutParameters setMinSpaceBetweenComponents(double minSpaceBetweenComponents) {
        this.minSpaceBetweenComponents = minSpaceBetweenComponents;
        return this;
    }

    public double getMinExternCellHeight() {
        return this.minExternCellHeight;
    }

    public LayoutParameters setMinExternCellHeight(double minExternCellHeight) {
        this.minExternCellHeight = minExternCellHeight;
        return this;
    }

    public void setComponentsSize(Map<String, ComponentSize> componentsSize) {
        this.componentsSize = componentsSize;
    }

    public Map<String, ComponentSize> getComponentsSize() {
        return this.componentsSize;
    }

    public double getAngleLabelShift() {
        return this.angleLabelShift;
    }

    public LayoutParameters setAngleLabelShift(double angleLabelShift) {
        this.angleLabelShift = angleLabelShift;
        return this;
    }

    public boolean isLabelCentered() {
        return this.labelCentered;
    }

    public LayoutParameters setLabelCentered(boolean labelCentered) {
        this.labelCentered = labelCentered;
        return this;
    }

    public boolean isLabelDiagonal() {
        return this.labelDiagonal;
    }

    public LayoutParameters setLabelDiagonal(boolean labelDiagonal) {
        this.labelDiagonal = labelDiagonal;
        return this;
    }

    public boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    public LayoutParameters setTooltipEnabled(boolean tooltipEnabled) {
        this.tooltipEnabled = tooltipEnabled;
        return this;
    }

    public boolean isAddNodesInfos() {
        return this.addNodesInfos;
    }

    public LayoutParameters setAddNodesInfos(boolean addNodesInfos) {
        this.addNodesInfos = addNodesInfos;
        return this;
    }

    public double getSpaceForFeederInfos() {
        return this.spaceForFeederInfos;
    }

    public LayoutParameters setSpaceForFeederInfos(double spaceForFeederInfos) {
        this.spaceForFeederInfos = spaceForFeederInfos;
        return this;
    }

    public boolean isFeederInfoSymmetry() {
        return this.feederInfoSymmetry;
    }

    public LayoutParameters setFeederInfoSymmetry(boolean feederInfoSymmetry) {
        this.feederInfoSymmetry = feederInfoSymmetry;
        return this;
    }

    public CssLocation getCssLocation() {
        return this.cssLocation;
    }

    public LayoutParameters setCssLocation(CssLocation cssLocation) {
        this.cssLocation = cssLocation;
        return this;
    }

    public Padding getVoltageLevelPadding() {
        return this.voltageLevelPadding;
    }

    public LayoutParameters setVoltageLevelPadding(double paddingLeft, double paddingTop, double paddingRight, double paddingBottom) {
        this.voltageLevelPadding = new Padding(paddingLeft, paddingTop, paddingRight, paddingBottom);
        return this;
    }

    public Padding getDiagramPadding() {
        return this.diagramPadding;
    }

    public LayoutParameters setDiagrammPadding(double paddingLeft, double paddingTop, double paddingRight, double paddingBottom) {
        this.diagramPadding = new Padding(paddingLeft, paddingTop, paddingRight, paddingBottom);
        return this;
    }

    public boolean isSvgWidthAndHeightAdded() {
        return this.svgWidthAndHeightAdded;
    }

    public LayoutParameters setSvgWidthAndHeightAdded(boolean svgWidthAndHeightAdded) {
        this.svgWidthAndHeightAdded = svgWidthAndHeightAdded;
        return this;
    }

    @JsonIgnore
    public double getBusPadding() {
        return this.getCellWidth() / 4.0;
    }

    public boolean isUseName() {
        return this.useName;
    }

    public LayoutParameters setUseName(boolean useName) {
        this.useName = useName;
        return this;
    }

    public double getFeederInfosIntraMargin() {
        return this.feederInfosIntraMargin;
    }

    public LayoutParameters setFeederInfosIntraMargin(double feederInfosIntraMargin) {
        this.feederInfosIntraMargin = feederInfosIntraMargin;
        return this;
    }

    public double getBusInfoMargin() {
        return this.busInfoMargin;
    }

    public LayoutParameters setBusInfoMargin(double busInfoMargin) {
        this.busInfoMargin = busInfoMargin;
        return this;
    }

    public Alignment getBusbarsAlignment() {
        return this.busbarsAlignment;
    }

    public LayoutParameters setBusbarsAlignment(Alignment busbarsAlignment) {
        this.busbarsAlignment = busbarsAlignment;
        return this;
    }

    public List<String> getComponentsOnBusbars() {
        return this.componentsOnBusbars;
    }

    public LayoutParameters setComponentsOnBusbars(List<String> componentsOnBusbars) {
        this.componentsOnBusbars = componentsOnBusbars;
        return this;
    }

    public String getLanguageTag() {
        return this.languageTag;
    }

    public LayoutParameters setLanguageTag(String languageTag) {
        this.languageTag = languageTag;
        return this;
    }

    public int getVoltageValuePrecision() {
        return this.voltageValuePrecision;
    }

    public LayoutParameters setVoltageValuePrecision(int voltageValuePrecision) {
        this.voltageValuePrecision = voltageValuePrecision;
        return this;
    }

    public int getPowerValuePrecision() {
        return this.powerValuePrecision;
    }

    public LayoutParameters setPowerValuePrecision(int powerValuePrecision) {
        this.powerValuePrecision = powerValuePrecision;
        return this;
    }

    public int getAngleValuePrecision() {
        return this.angleValuePrecision;
    }

    public LayoutParameters setAngleValuePrecision(int angleValuePrecision) {
        this.angleValuePrecision = angleValuePrecision;
        return this;
    }

    public int getCurrentValuePrecision() {
        return this.currentValuePrecision;
    }

    public LayoutParameters setCurrentValuePrecision(int currentValuePrecision) {
        this.currentValuePrecision = currentValuePrecision;
        return this;
    }

    public ValueFormatter createValueFormatter() {
        return new ValueFormatter(this.powerValuePrecision, this.voltageValuePrecision, this.currentValuePrecision, this.angleValuePrecision, Locale.forLanguageTag(this.languageTag), this.undefinedValueSymbol);
    }

    public boolean isDisplayCurrentFeederInfo() {
        return this.displayCurrentFeederInfo;
    }

    public LayoutParameters setDisplayCurrentFeederInfo(boolean displayCurrentFeederInfo) {
        this.displayCurrentFeederInfo = displayCurrentFeederInfo;
        return this;
    }

    @JsonIgnore
    public double getFeederSpan() {
        return this.getSpaceForFeederInfos() + this.getMaxComponentHeight();
    }

    public String getUndefinedValueSymbol() {
        return this.undefinedValueSymbol;
    }

    public LayoutParameters setUndefinedValueSymbol(String undefinedValueSymbol) {
        this.undefinedValueSymbol = undefinedValueSymbol;
        return this;
    }

    public boolean isRemoveFictitiousSwitchNodes() {
        return this.removeFictitiousSwitchNodes;
    }

    public LayoutParameters setRemoveFictitiousSwitchNodes(boolean removeFictitiousSwitchNodes) {
        this.removeFictitiousSwitchNodes = removeFictitiousSwitchNodes;
        return this;
    }

    public static class Padding {
        private final double left;
        private final double top;
        private final double right;
        private final double bottom;

        @JsonCreator
        public Padding(@JsonProperty(value="left") double left, @JsonProperty(value="top") double top, @JsonProperty(value="right") double right, @JsonProperty(value="bottom") double bottom) {
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }

        public Padding(int padding) {
            this(padding, padding, padding, padding);
        }

        public Padding(Padding padding) {
            this(padding.left, padding.top, padding.right, padding.bottom);
        }

        public double getLeft() {
            return this.left;
        }

        public double getRight() {
            return this.right;
        }

        public double getTop() {
            return this.top;
        }

        public double getBottom() {
            return this.bottom;
        }
    }

    public static enum CssLocation {
        INSERTED_IN_SVG,
        EXTERNAL_IMPORTED,
        EXTERNAL_NO_IMPORT;

    }

    public static enum Alignment {
        FIRST,
        LAST,
        MIDDLE,
        NONE;

    }
}

