/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.layout.InternCellSide;
import com.powsybl.sld.model.cells.Cell;
import com.powsybl.sld.model.cells.ExternCell;
import com.powsybl.sld.model.cells.InternCell;
import com.powsybl.sld.model.cells.ShuntCell;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.BusNode;
import com.powsybl.sld.model.nodes.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LegBusSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegBusSet.class);
    private final Set<BusNode> busNodeSet;
    private final Set<BusNode> extendedNodeSet;
    private final Set<ExternCell> externCells = new LinkedHashSet<ExternCell>();
    private final Set<InternCellSide> internCellSides = new LinkedHashSet<InternCellSide>();

    private LegBusSet(Map<BusNode, Integer> nodeToNb, List<BusNode> busNodes) {
        this.busNodeSet = new TreeSet<BusNode>(Comparator.comparingInt(nodeToNb::get));
        this.extendedNodeSet = new TreeSet<BusNode>(Comparator.comparingInt(nodeToNb::get));
        this.busNodeSet.addAll(busNodes);
    }

    private LegBusSet(Map<BusNode, Integer> nodeToNb, ExternCell cell) {
        this(nodeToNb, cell.getBusNodes());
        this.externCells.add(cell);
    }

    private LegBusSet(Map<BusNode, Integer> nodeToNb, ShuntCell cell) {
        this(nodeToNb, cell.getParentBusNodes());
        this.externCells.addAll(cell.getSideCells());
    }

    private LegBusSet(Map<BusNode, Integer> nodeToNb, InternCell internCell, Side side) {
        this(nodeToNb, internCell.getSideBusNodes(side));
        this.addInternCell(internCell, side);
    }

    private LegBusSet(Map<BusNode, Integer> nodeToNb, BusNode busNode) {
        this(nodeToNb, Collections.singletonList(busNode));
    }

    void addInternCell(InternCell internCell, Side side) {
        this.internCellSides.add(new InternCellSide(internCell, side));
    }

    private boolean contains(Collection<BusNode> busNodeCollection) {
        return this.busNodeSet.containsAll(busNodeCollection);
    }

    private boolean contains(LegBusSet lbs) {
        return this.contains(lbs.getBusNodeSet());
    }

    private void absorbs(LegBusSet lbsToAbsorb) {
        this.busNodeSet.addAll(lbsToAbsorb.busNodeSet);
        this.externCells.addAll(lbsToAbsorb.externCells);
        this.internCellSides.addAll(lbsToAbsorb.internCellSides);
    }

    List<InternCell> getInternCellsFromShape(InternCell.Shape shape) {
        return this.internCellSides.stream().map(InternCellSide::getCell).filter(cell -> cell.checkIsShape(shape)).distinct().collect(Collectors.toList());
    }

    public Set<BusNode> getBusNodeSet() {
        return this.busNodeSet;
    }

    public Set<ExternCell> getExternCells() {
        return this.externCells;
    }

    Set<InternCellSide> getInternCellSides() {
        return this.internCellSides;
    }

    void setExtendedNodeSet(Collection<BusNode> busNodes) {
        if (busNodes.containsAll(this.busNodeSet)) {
            this.extendedNodeSet.addAll(busNodes.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        } else {
            LOGGER.error("ExtendedNodeSet inconsistent with NodeBusSet");
        }
    }

    Set<BusNode> getExtendedNodeSet() {
        return this.extendedNodeSet;
    }

    static List<LegBusSet> createLegBusSets(VoltageLevelGraph graph, Map<BusNode, Integer> nodeToNb, boolean handleShunts) {
        ArrayList<LegBusSet> legBusSets = new ArrayList<LegBusSet>();
        List<ExternCell> externCells = graph.getExternCellStream().sorted(Comparator.comparing(Cell::getFullId)).collect(Collectors.toList());
        if (handleShunts) {
            LegBusSet.manageShunts(graph, externCells, legBusSets, nodeToNb);
        }
        externCells.forEach(cell -> LegBusSet.pushLBS(legBusSets, new LegBusSet(nodeToNb, (ExternCell)cell)));
        graph.getInternCellStream().filter(cell -> cell.checkIsShape(InternCell.Shape.ONE_LEG)).sorted(Comparator.comparing(Cell::getFullId)).forEachOrdered(cell -> LegBusSet.pushLBS(legBusSets, new LegBusSet(nodeToNb, (InternCell)cell, Side.UNDEFINED)));
        graph.getInternCellStream().filter(cell -> cell.checkIsNotShape(InternCell.Shape.ONE_LEG, InternCell.Shape.UNHANDLED_PATTERN)).sorted(Comparator.comparing(cell -> -((InternCell)cell).getBusNodes().size()).thenComparing(cell -> ((InternCell)cell).getFullId())).forEachOrdered(cell -> LegBusSet.pushNonUnilegInternCell(legBusSets, nodeToNb, cell));
        ArrayList<BusNode> allBusNodes = new ArrayList<BusNode>(graph.getNodeBuses());
        allBusNodes.removeAll(legBusSets.stream().flatMap(legBusSet -> legBusSet.getBusNodeSet().stream()).collect(Collectors.toList()));
        allBusNodes.stream().sorted(Comparator.comparing(Node::getId)).forEach(busNode -> legBusSets.add(new LegBusSet(nodeToNb, (BusNode)busNode)));
        return legBusSets;
    }

    private static void manageShunts(VoltageLevelGraph graph, List<ExternCell> externCells, List<LegBusSet> legBusSets, Map<BusNode, Integer> nodeToNb) {
        List sameBusNodesShuntCells = graph.getShuntCellStream().map(sc -> new ArrayList<ShuntCell>(Collections.singletonList(sc))).collect(Collectors.toList());
        for (int i = 0; i < sameBusNodesShuntCells.size(); ++i) {
            int j = i + 1;
            while (j < sameBusNodesShuntCells.size()) {
                if (LegBusSet.crossContains(((ShuntCell)((List)sameBusNodesShuntCells.get(i)).get(0)).getParentBusNodes(), ((ShuntCell)((List)sameBusNodesShuntCells.get(j)).get(0)).getParentBusNodes())) {
                    ((List)sameBusNodesShuntCells.get(i)).addAll((Collection)sameBusNodesShuntCells.get(j));
                    sameBusNodesShuntCells.remove(j);
                    continue;
                }
                ++j;
            }
        }
        sameBusNodesShuntCells.stream().filter(scs -> scs.size() > 2).flatMap(Collection::stream).forEach(sc -> {
            LegBusSet.pushLBS(legBusSets, new LegBusSet(nodeToNb, (ShuntCell)sc));
            externCells.removeAll(sc.getSideCells());
        });
    }

    private static boolean crossContains(List<BusNode> busNodes1, List<BusNode> busNodes2) {
        return busNodes1.containsAll(busNodes2) && busNodes2.containsAll(busNodes1);
    }

    public static void pushLBS(List<LegBusSet> legBusSets, LegBusSet legBusSet) {
        for (LegBusSet lbs : legBusSets) {
            if (!lbs.contains(legBusSet)) continue;
            lbs.absorbs(legBusSet);
            return;
        }
        ArrayList<LegBusSet> absorbedLBS = new ArrayList<LegBusSet>();
        for (LegBusSet lbs : legBusSets) {
            if (!legBusSet.contains(lbs)) continue;
            absorbedLBS.add(lbs);
            legBusSet.absorbs(lbs);
        }
        legBusSets.removeAll(absorbedLBS);
        legBusSets.add(legBusSet);
    }

    private static void pushNonUnilegInternCell(List<LegBusSet> legBusSets, Map<BusNode, Integer> nodeToNb, InternCell internCell) {
        for (LegBusSet lbs : legBusSets) {
            if (!lbs.contains(internCell.getBusNodes())) continue;
            lbs.addInternCell(internCell, Side.UNDEFINED);
            internCell.setShape(InternCell.Shape.VERTICAL);
            return;
        }
        LegBusSet.pushLBS(legBusSets, new LegBusSet(nodeToNb, internCell, Side.LEFT));
        LegBusSet.pushLBS(legBusSets, new LegBusSet(nodeToNb, internCell, Side.RIGHT));
    }
}

