/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.google.auto.service.AutoService;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.BusbarSectionPosition;
import com.powsybl.iidm.network.extensions.ConnectablePosition;
import com.powsybl.sld.layout.PositionVoltageLevelLayoutFactory;
import com.powsybl.sld.layout.VoltageLevelLayoutFactory;
import com.powsybl.sld.layout.VoltageLevelLayoutFactorySmartSelector;

@AutoService(value=VoltageLevelLayoutFactorySmartSelector.class)
public class PositionFromExtensionVoltageLevelLayoutFactorySmartSelector
implements VoltageLevelLayoutFactorySmartSelector {
    private static final int PRIORITY = 1000;

    @Override
    public int getPriority(VoltageLevel vl) {
        return vl.getTopologyKind() == TopologyKind.BUS_BREAKER ? Integer.MAX_VALUE : 1000;
    }

    private static boolean hasAtLeastOneExtension(VoltageLevel vl) {
        for (Connectable c : vl.getConnectables()) {
            if (c.getExtension(ConnectablePosition.class) == null && c.getExtension(BusbarSectionPosition.class) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelectable(VoltageLevel vl) {
        return vl.getTopologyKind() == TopologyKind.BUS_BREAKER || PositionFromExtensionVoltageLevelLayoutFactorySmartSelector.hasAtLeastOneExtension(vl);
    }

    @Override
    public VoltageLevelLayoutFactory createFactory(Network network) {
        return new PositionVoltageLevelLayoutFactory();
    }
}

