/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.layout.AbstractVoltageLevelLayout;
import com.powsybl.sld.layout.BlockOrganizer;
import com.powsybl.sld.layout.CalculateCellHeightBlockVisitor;
import com.powsybl.sld.layout.CalculateCoordCellVisitor;
import com.powsybl.sld.layout.CellDetector;
import com.powsybl.sld.layout.GraphRefiner;
import com.powsybl.sld.layout.LayoutContext;
import com.powsybl.sld.layout.LayoutParameters;
import com.powsybl.sld.model.cells.BusCell;
import com.powsybl.sld.model.cells.Cell;
import com.powsybl.sld.model.cells.InternCell;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.coordinate.Position;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.BusNode;
import java.util.EnumMap;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionVoltageLevelLayout
extends AbstractVoltageLevelLayout {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionVoltageLevelLayout.class);
    private final CellDetector cellDetector;
    private final BlockOrganizer blockOrganizer;
    private final GraphRefiner graphAdapter;

    public PositionVoltageLevelLayout(VoltageLevelGraph graph, GraphRefiner graphRefiner, CellDetector cellDetector, BlockOrganizer blockOrganizer) {
        super(graph);
        this.graphAdapter = graphRefiner;
        this.cellDetector = cellDetector;
        this.blockOrganizer = blockOrganizer;
    }

    @Override
    public void run(LayoutParameters layoutParam) {
        LOGGER.info("Running voltage level layout");
        this.graphAdapter.run(this.getGraph(), layoutParam);
        this.cellDetector.detectCells(this.getGraph());
        this.blockOrganizer.organize(this.getGraph(), layoutParam);
        this.calculateMaxCellHeight(layoutParam);
        this.calculateBusNodeCoord(this.getGraph(), layoutParam);
        this.calculateCellCoord(this.getGraph(), layoutParam);
        this.setGraphCoord(layoutParam);
        this.setGraphSize(layoutParam);
        this.manageSnakeLines(layoutParam);
        if (this.getGraph().isForVoltageLevelDiagram()) {
            this.adaptPaddingToSnakeLines(layoutParam);
        }
    }

    private void setGraphCoord(LayoutParameters layoutParam) {
        LayoutParameters.Padding vlPadding = layoutParam.getVoltageLevelPadding();
        LayoutParameters.Padding dPadding = layoutParam.getDiagramPadding();
        this.getGraph().setCoord(dPadding.getLeft() + vlPadding.getLeft(), dPadding.getTop() + vlPadding.getTop());
    }

    private void setGraphSize(LayoutParameters layoutParam) {
        VoltageLevelGraph graph = this.getGraph();
        double elementaryWidth = layoutParam.getCellWidth() / 2.0;
        double widthWithoutPadding = (double)graph.getMaxH() * elementaryWidth;
        double heightWithoutPadding = graph.getInnerHeight(layoutParam.getVerticalSpaceBus());
        LayoutParameters.Padding padding = layoutParam.getVoltageLevelPadding();
        double width = widthWithoutPadding + padding.getLeft() + padding.getRight();
        double height = heightWithoutPadding + padding.getTop() + padding.getBottom();
        this.getGraph().setSize(width, height);
    }

    private void adaptPaddingToSnakeLines(LayoutParameters layoutParam) {
        VoltageLevelGraph graph = this.getGraph();
        double widthSnakeLinesLeft = PositionVoltageLevelLayout.getWidthVerticalSnakeLines(graph.getId(), layoutParam, this.infosNbSnakeLines);
        double heightSnakeLinesTop = PositionVoltageLevelLayout.getHeightSnakeLines(layoutParam, Direction.TOP, this.infosNbSnakeLines);
        double heightSnakeLinesBottom = PositionVoltageLevelLayout.getHeightSnakeLines(layoutParam, Direction.BOTTOM, this.infosNbSnakeLines);
        double width = graph.getWidth() + widthSnakeLinesLeft;
        double height = graph.getHeight() + heightSnakeLinesTop + heightSnakeLinesBottom;
        graph.setSize(width, height);
        graph.setCoord(graph.getX() + widthSnakeLinesLeft, graph.getY() + heightSnakeLinesTop);
        this.infosNbSnakeLines.reset();
        this.manageSnakeLines(this.getGraph(), layoutParam);
    }

    private void calculateBusNodeCoord(VoltageLevelGraph graph, LayoutParameters layoutParam) {
        graph.getNodeBuses().forEach(nb -> this.calculateNodeCoord((BusNode)nb, layoutParam, graph.getFirstBusY()));
    }

    private void calculateNodeCoord(BusNode busNode, LayoutParameters layoutParameters, double firstBusY) {
        double elementaryWidth = layoutParameters.getCellWidth() / 2.0;
        double busPadding = busNode.isFictitious() ? elementaryWidth : layoutParameters.getBusPadding();
        Position position = busNode.getPosition();
        busNode.setCoordinates((double)position.get(Position.Dimension.H) * elementaryWidth + busPadding, firstBusY + (double)position.get(Position.Dimension.V) * layoutParameters.getVerticalSpaceBus());
        busNode.setPxWidth((double)position.getSpan(Position.Dimension.H) * elementaryWidth - 2.0 * busPadding);
    }

    private void calculateCellCoord(VoltageLevelGraph graph, LayoutParameters layoutParam) {
        graph.getBusCellStream().forEach(cell -> cell.accept(new CalculateCoordCellVisitor(layoutParam, this.createLayoutContext(graph, (BusCell)cell, layoutParam))));
        graph.getShuntCellStream().forEach(cell -> cell.accept(new CalculateCoordCellVisitor(layoutParam, null)));
    }

    private LayoutContext createLayoutContext(VoltageLevelGraph graph, BusCell cell, LayoutParameters layoutParam) {
        double firstBusY = graph.getFirstBusY();
        double lastBusY = graph.getLastBusY(layoutParam.getVerticalSpaceBus());
        Double externCellHeight = graph.getExternCellHeight(cell.getDirection());
        if (cell.getType() != Cell.CellType.INTERN) {
            return new LayoutContext(firstBusY, lastBusY, externCellHeight, cell.getDirection());
        }
        boolean isFlat = ((InternCell)cell).getShape() == InternCell.Shape.FLAT;
        boolean isUnileg = ((InternCell)cell).getShape() == InternCell.Shape.ONE_LEG;
        return new LayoutContext(firstBusY, lastBusY, externCellHeight, cell.getDirection(), true, isFlat, isUnileg);
    }

    private void calculateMaxCellHeight(LayoutParameters layoutParam) {
        EnumMap<Direction, Double> maxCellHeight = new EnumMap<Direction, Double>(Direction.class);
        if (layoutParam.isAdaptCellHeightToContent()) {
            EnumMap maxInternCellHeight = new EnumMap(Direction.class);
            this.getGraph().getInternCellStream().forEach(cell -> maxInternCellHeight.merge(cell.getDirection(), this.calculateCellHeight(layoutParam, (BusCell)cell), Math::max));
            this.getGraph().getExternCellStream().forEach(cell -> maxCellHeight.merge(cell.getDirection(), this.calculateCellHeight(layoutParam, (BusCell)cell), Math::max));
            EnumSet.allOf(Direction.class).forEach(d -> maxCellHeight.compute((Direction)((Object)d), (k, v) -> {
                Double vIntern = (Double)maxInternCellHeight.get(d);
                if (v == null && vIntern == null) {
                    return 0.0;
                }
                if (v == null) {
                    return vIntern + layoutParam.getStackHeight();
                }
                return Math.max(v, layoutParam.getMinExternCellHeight()) + layoutParam.getFeederSpan() + layoutParam.getStackHeight();
            }));
        } else {
            maxCellHeight.put(Direction.TOP, layoutParam.getExternCellHeight() + layoutParam.getStackHeight());
            maxCellHeight.put(Direction.BOTTOM, layoutParam.getExternCellHeight() + layoutParam.getStackHeight());
        }
        this.getGraph().setMaxCellHeight(maxCellHeight);
    }

    double calculateCellHeight(LayoutParameters layoutParameters, BusCell cell) {
        CalculateCellHeightBlockVisitor cchbv = CalculateCellHeightBlockVisitor.create(layoutParameters);
        cell.getRootBlock().accept(cchbv);
        return cchbv.getBlockHeight();
    }
}

