/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.layout.BlockOrganizer;
import com.powsybl.sld.layout.GraphRefiner;
import com.powsybl.sld.layout.ImplicitCellDetector;
import com.powsybl.sld.layout.Layout;
import com.powsybl.sld.layout.PositionFinder;
import com.powsybl.sld.layout.PositionVoltageLevelLayout;
import com.powsybl.sld.layout.VoltageLevelLayoutFactory;
import com.powsybl.sld.layout.positionfromextension.PositionFromExtension;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PositionVoltageLevelLayoutFactory
implements VoltageLevelLayoutFactory {
    private final PositionFinder positionFinder;
    private boolean feederStacked = true;
    private boolean removeUnnecessaryFictitiousNodes = true;
    private boolean substituteSingularFictitiousByFeederNode = true;
    private boolean exceptionIfPatternNotHandled = false;
    private boolean handleShunts = false;
    private Map<String, Side> busInfoMap = new HashMap<String, Side>();

    public PositionVoltageLevelLayoutFactory() {
        this(new PositionFromExtension());
    }

    public PositionVoltageLevelLayoutFactory(PositionFinder positionFinder) {
        this.positionFinder = Objects.requireNonNull(positionFinder);
    }

    public boolean isFeederStacked() {
        return this.feederStacked;
    }

    public PositionVoltageLevelLayoutFactory setFeederStacked(boolean feederStacked) {
        this.feederStacked = feederStacked;
        return this;
    }

    public boolean isExceptionIfPatternNotHandled() {
        return this.exceptionIfPatternNotHandled;
    }

    public PositionVoltageLevelLayoutFactory setExceptionIfPatternNotHandled(boolean exceptionIfPatternNotHandled) {
        this.exceptionIfPatternNotHandled = exceptionIfPatternNotHandled;
        return this;
    }

    public boolean isRemoveUnnecessaryFictitiousNodes() {
        return this.removeUnnecessaryFictitiousNodes;
    }

    public PositionVoltageLevelLayoutFactory setRemoveUnnecessaryFictitiousNodes(boolean removeUnnecessaryFictitiousNodes) {
        this.removeUnnecessaryFictitiousNodes = removeUnnecessaryFictitiousNodes;
        return this;
    }

    public boolean isSubstituteSingularFictitiousByFeederNode() {
        return this.substituteSingularFictitiousByFeederNode;
    }

    public PositionVoltageLevelLayoutFactory setSubstituteSingularFictitiousByFeederNode(boolean substituteSingularFictitiousByFeederNode) {
        this.substituteSingularFictitiousByFeederNode = substituteSingularFictitiousByFeederNode;
        return this;
    }

    public boolean isHandleShunts() {
        return this.handleShunts;
    }

    public PositionVoltageLevelLayoutFactory setHandleShunts(boolean handleShunts) {
        this.handleShunts = handleShunts;
        return this;
    }

    public Map<String, Side> getBusInfoMap() {
        return this.busInfoMap;
    }

    public PositionVoltageLevelLayoutFactory setBusInfoMap(Map<String, Side> busInfoMap) {
        this.busInfoMap = busInfoMap;
        return this;
    }

    @Override
    public Layout create(VoltageLevelGraph graph) {
        GraphRefiner graphRefiner = new GraphRefiner(this.removeUnnecessaryFictitiousNodes, this.substituteSingularFictitiousByFeederNode);
        ImplicitCellDetector cellDetector = new ImplicitCellDetector(this.exceptionIfPatternNotHandled);
        BlockOrganizer blockOrganizer = new BlockOrganizer(this.positionFinder, this.feederStacked, this.exceptionIfPatternNotHandled, this.handleShunts, this.busInfoMap);
        return new PositionVoltageLevelLayout(graph, graphRefiner, cellDetector, blockOrganizer);
    }
}

